/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.maps;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.json.JsonManager;
import com.wynntils.core.persisted.config.HiddenConfig;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.map.MainMapFeature;
import com.wynntils.models.marker.MarkerModel;
import com.wynntils.screens.base.WynntilsGridLayoutScreen;
import com.wynntils.screens.base.widgets.InfoButton;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.maps.IconFilterScreen;
import com.wynntils.screens.maps.MainMapScreen;
import com.wynntils.screens.maps.widgets.PoiManagerWidget;
import com.wynntils.screens.maps.widgets.PoiSortButton;
import com.wynntils.services.map.pois.CustomPoi;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class PoiManagementScreen
extends WynntilsGridLayoutScreen {
    private static final int GRID_ROWS_PER_PAGE = 43;
    private static final int HEADER_HEIGHT = 12;
    private final List<AbstractWidget> poiManagerWidgets = new ArrayList<AbstractWidget>();
    private final List<CustomPoi> deletedPois = new ArrayList<CustomPoi>();
    private final List<Integer> deletedIndexes = new ArrayList<Integer>();
    private final MainMapScreen oldMapScreen;
    private Button deleteSelectedButton;
    private Button deselectAllButton;
    private Button downButton;
    private Button exportButton;
    private Button filterButton;
    private Button removeMarkersButton;
    private Button selectAllButton;
    private Button setMarkersButton;
    private Button undoDeleteButton;
    private Button upButton;
    private PoiSortButton activeSortButton;
    private PoiSortButton iconSortButton;
    private PoiSortButton nameSortButton;
    private PoiSortButton xSortButton;
    private PoiSortButton ySortButton;
    private PoiSortButton zSortButton;
    private TextInputBoxWidget focusedTextInput;
    private TextInputBoxWidget searchInput;
    private boolean draggingScroll = false;
    private float backgroundHeight;
    private float backgroundWidth;
    private float backgroundX;
    private float backgroundY;
    private float scrollButtonHeight;
    private float scrollButtonRenderX;
    private float scrollButtonRenderY;
    private int maxPoisToDisplay;
    private int scrollAreaHeight;
    private int scrollOffset = 0;
    private boolean selectionMode = false;
    private List<CustomPoi> selectedPois = new ArrayList<CustomPoi>();
    private List<CustomPoi> pois;
    private Map<Texture, Boolean> filteredIcons = new EnumMap<Texture, Boolean>(Texture.class);
    private PoiSortOrder sortOrder;

    private PoiManagementScreen(MainMapScreen oldMapScreen) {
        super((Component)Component.literal((String)"Poi Management Screen"));
        this.oldMapScreen = oldMapScreen;
    }

    public static Screen create() {
        return new PoiManagementScreen(null);
    }

    public static Screen create(MainMapScreen oldMapScreen) {
        return new PoiManagementScreen(oldMapScreen);
    }

    public void onClose() {
        McUtils.mc().setScreen((Screen)this.oldMapScreen);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.maxPoisToDisplay = (int)(this.dividedHeight * 43.0f) / 20;
        this.backgroundX = this.dividedWidth * 10.0f;
        this.backgroundWidth = this.dividedWidth * 44.0f;
        this.backgroundY = this.dividedHeight * 7.0f;
        this.backgroundHeight = this.dividedHeight * 50.0f;
        this.scrollButtonHeight = this.dividedWidth / 2.0f / (float)Texture.SCROLL_BUTTON.width() * (float)Texture.SCROLL_BUTTON.height();
        this.scrollAreaHeight = (int)(this.backgroundHeight - this.scrollButtonHeight) - (int)(this.dividedHeight * 4.0f);
        this.scrollButtonRenderX = (float)((int)(this.dividedWidth * 52.0f)) + this.dividedWidth / 4.0f;
        int importExportButtonWidth = (int)(this.dividedWidth * 6.0f);
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"X").withStyle(ChatFormatting.RED), button -> this.onClose()).pos((int)(this.dividedWidth * 60.0f), (int)(this.dividedHeight * 4.0f)).size(20, 20).build());
        this.addRenderableWidget((GuiEventListener)new InfoButton((int)(this.dividedWidth * 3.0f), (int)(this.dividedHeight * 4.0f), (Component)Component.literal((String)"").append((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.help").withStyle(ChatFormatting.UNDERLINE)).append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.help1").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.help2").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.help3").withStyle(ChatFormatting.GRAY))));
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.import"), button -> this.importFromClipboard()).pos((int)(this.dividedWidth * 22.0f), (int)(this.dividedHeight * 58.0f)).size(importExportButtonWidth, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.import.tooltip"))).build());
        this.exportButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.export"), button -> this.exportToClipboard()).pos((int)(this.dividedWidth * 36.0f), (int)(this.dividedHeight * 58.0f)).size(importExportButtonWidth, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.exportAll.tooltip"))).build();
        this.addRenderableWidget((GuiEventListener)this.exportButton);
        this.undoDeleteButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.undo"), button -> this.undoDelete()).pos((int)(this.dividedWidth * 55.0f), (int)(this.dividedHeight * 58.0f)).size((int)(this.dividedWidth * 8.0f), 20).build();
        this.addRenderableWidget((GuiEventListener)this.undoDeleteButton);
        this.deleteSelectedButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.deleteSelected"), button -> this.deleteSelectedPois()).pos((int)(this.dividedWidth * 55.0f), (int)(this.dividedHeight * 58.0f) - 25).size((int)(this.dividedWidth * 8.0f), 20).build();
        this.deleteSelectedButton.active = false;
        this.addRenderableWidget((GuiEventListener)this.deleteSelectedButton);
        this.setMarkersButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.setMarkers"), button -> this.toggleMarkers(true)).pos((int)this.dividedWidth, (int)(this.dividedHeight * 58.0f) - 75).size((int)(this.dividedWidth * 8.0f), 20).tooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.setMarkers.tooltip"))).build();
        this.setMarkersButton.active = false;
        this.addRenderableWidget((GuiEventListener)this.setMarkersButton);
        this.removeMarkersButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.removeMarkers"), button -> this.toggleMarkers(false)).pos((int)this.dividedWidth, (int)(this.dividedHeight * 58.0f) - 50).size((int)(this.dividedWidth * 8.0f), 20).tooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.removeMarkers.tooltip"))).build();
        this.removeMarkersButton.active = false;
        this.addRenderableWidget((GuiEventListener)this.removeMarkersButton);
        this.deselectAllButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.deselectAll"), button -> this.toggleSelectAll(false)).pos((int)this.dividedWidth, (int)(this.dividedHeight * 58.0f)).size((int)(this.dividedWidth * 8.0f), 20).build();
        this.deselectAllButton.active = false;
        this.addRenderableWidget((GuiEventListener)this.deselectAllButton);
        this.selectAllButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.selectAll"), button -> this.toggleSelectAll(true)).pos((int)this.dividedWidth, (int)(this.dividedHeight * 58.0f) - 25).size((int)(this.dividedWidth * 8.0f), 20).build();
        this.addRenderableWidget((GuiEventListener)this.selectAllButton);
        this.upButton = new Button.Builder((Component)Component.literal((String)"\ud83e\udc1d"), button -> this.updateSelectedPoiPositions(-1)).pos(this.width / 2 - 22, (int)(this.dividedHeight * 58.0f)).size(20, 20).build();
        this.upButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.upButton);
        this.downButton = new Button.Builder((Component)Component.literal((String)"\ud83e\udc1f"), button -> this.updateSelectedPoiPositions(1)).pos(this.width / 2 + 2, (int)(this.dividedHeight * 58.0f)).size(20, 20).build();
        this.downButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.downButton);
        int filterButtonWidth = (int)(this.dividedWidth * 10.0f);
        this.filterButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.filter"), button -> {
            this.scrollOffset = 0;
            McUtils.mc().setScreen(IconFilterScreen.create(this, this.filteredIcons));
        }).pos((int)(this.dividedWidth * 44.0f), (int)(this.dividedHeight * 3.0f)).size(filterButtonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.filterButton);
        this.searchInput = new TextInputBoxWidget((int)(this.dividedWidth * 10.0f) + 5, (int)(this.dividedHeight * 3.0f), (int)(this.backgroundWidth - (float)filterButtonWidth - 10.0f), 20, s -> {
            this.scrollOffset = 0;
            this.populatePois();
        }, this, this.searchInput);
        this.addRenderableWidget((GuiEventListener)this.searchInput);
        this.setFocusedTextInput(this.searchInput);
        int iconTitleWidth = McUtils.mc().font.width(I18n.get((String)"screens.wynntils.poiManagementGui.icon", (Object[])new Object[0])) + 1;
        int nameTitleWidth = McUtils.mc().font.width(I18n.get((String)"screens.wynntils.poiManagementGui.name", (Object[])new Object[0])) + 1;
        int coordinateTitleWidth = McUtils.mc().font.width("X") + 1;
        this.iconSortButton = (PoiSortButton)this.addRenderableWidget((GuiEventListener)new PoiSortButton((int)(this.dividedWidth * 13.0f) - iconTitleWidth / 2, (int)(this.dividedHeight * 12.0f) - 10, iconTitleWidth, 10, (Component)Component.translatable((String)"screens.wynntils.poiManagementGui.icon"), this, PoiSortType.ICON));
        this.nameSortButton = (PoiSortButton)this.addRenderableWidget((GuiEventListener)new PoiSortButton((int)(this.dividedWidth * 22.0f) - nameTitleWidth / 2, (int)(this.dividedHeight * 12.0f) - 10, nameTitleWidth, 10, (Component)Component.translatable((String)"screens.wynntils.poiManagementGui.name"), this, PoiSortType.NAME));
        this.xSortButton = (PoiSortButton)this.addRenderableWidget((GuiEventListener)new PoiSortButton((int)(this.dividedWidth * 32.0f) - coordinateTitleWidth / 2, (int)(this.dividedHeight * 12.0f) - 10, coordinateTitleWidth, 10, (Component)Component.literal((String)"X"), this, PoiSortType.X));
        this.ySortButton = (PoiSortButton)this.addRenderableWidget((GuiEventListener)new PoiSortButton((int)(this.dividedWidth * 35.0f) - coordinateTitleWidth / 2, (int)(this.dividedHeight * 12.0f) - 10, coordinateTitleWidth, 10, (Component)Component.literal((String)"Y"), this, PoiSortType.Y));
        this.zSortButton = (PoiSortButton)this.addRenderableWidget((GuiEventListener)new PoiSortButton((int)(this.dividedWidth * 38.0f) - coordinateTitleWidth / 2, (int)(this.dividedHeight * 12.0f) - 10, coordinateTitleWidth, 10, (Component)Component.literal((String)"Z"), this, PoiSortType.Z));
        if (this.deletedIndexes.isEmpty()) {
            this.undoDeleteButton.active = false;
        }
        this.pois = (List)Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois.get();
        if (this.pois.isEmpty()) {
            this.searchInput.visible = false;
            this.filterButton.visible = false;
            this.iconSortButton.visible = false;
            this.nameSortButton.visible = false;
            this.xSortButton.visible = false;
            this.ySortButton.visible = false;
            this.zSortButton.visible = false;
            this.exportButton.active = false;
        }
        this.updateAllUsedIcons();
        this.populatePois();
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        PoseStack poseStack = guiGraphics.pose();
        this.renderScrollButton(poseStack);
        if (((List)Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois.get()).isEmpty()) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.noPois")), (int)(this.dividedWidth * 32.0f), (int)(this.dividedHeight * 32.0f), CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
            return;
        }
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.search")), (int)(this.dividedWidth * 10.0f) + 5, (int)this.dividedHeight, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL);
        if (this.pois.isEmpty()) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.noFilteredPois")), (int)(this.dividedWidth * 32.0f), (int)(this.dividedHeight * 32.0f), CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        } else {
            RenderUtils.drawRect(poseStack, CommonColors.WHITE, (int)(this.dividedWidth * 12.0f), (int)(this.dividedHeight * 12.0f), 0.0f, (int)(this.dividedWidth * 38.0f), 1.0f);
        }
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        RenderUtils.drawScalingTexturedRect(guiGraphics.pose(), Texture.WAYPOINT_MANAGER_BACKGROUND.resource(), this.backgroundX, this.backgroundY, 0.0f, this.backgroundWidth, this.backgroundHeight, Texture.WAYPOINT_MANAGER_BACKGROUND.width(), Texture.WAYPOINT_MANAGER_BACKGROUND.height());
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.draggingScroll && this.pois.size() > this.maxPoisToDisplay && MathUtils.isInside((int)mouseX, (int)mouseY, (int)this.scrollButtonRenderX, (int)(this.scrollButtonRenderX + this.dividedWidth / 2.0f), (int)this.scrollButtonRenderY, (int)(this.scrollButtonRenderY + this.scrollButtonHeight))) {
            this.draggingScroll = true;
            return true;
        }
        return super.doMouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.draggingScroll) {
            return false;
        }
        int renderY = (int)(((float)this.height - this.backgroundHeight) / 2.0f + (float)((int)(this.dividedHeight * 3.0f)));
        int scrollAreaStartY = renderY + 7;
        int newValue = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, scrollAreaStartY + this.scrollAreaHeight, 0.0f, Math.max(0, this.pois.size() - this.maxPoisToDisplay)));
        this.scroll(newValue - this.scrollOffset);
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.draggingScroll = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        double scrollValue = -Math.signum(deltaY);
        this.scroll((int)scrollValue);
        return true;
    }

    public void selectPoi(CustomPoi selectedPoi) {
        boolean addedPoi = true;
        if (this.selectedPois.contains(selectedPoi)) {
            this.selectedPois.remove(selectedPoi);
            addedPoi = false;
        } else {
            this.selectedPois.add(selectedPoi);
        }
        boolean bl = this.selectAllButton.active = this.selectedPois.size() < this.pois.size();
        if (addedPoi || this.selectedPois.isEmpty()) {
            this.selectionMode = addedPoi;
            this.deselectAllButton.active = addedPoi;
            this.deleteSelectedButton.active = addedPoi;
            this.setMarkersButton.active = addedPoi;
            this.removeMarkersButton.active = addedPoi;
            this.upButton.visible = addedPoi;
            this.downButton.visible = addedPoi;
            MutableComponent tooltip = addedPoi ? Component.translatable((String)"screens.wynntils.poiManagementGui.exportSelected.tooltip", (Object[])new Object[]{this.selectedPois.size()}) : Component.translatable((String)"screens.wynntils.poiManagementGui.exportAll.tooltip");
            this.exportButton.setTooltip(Tooltip.create((Component)tooltip));
        }
        this.populatePois();
    }

    public void toggleSortType(PoiSortType sortType, PoiSortButton selectedButton) {
        if (this.activeSortButton != null && this.activeSortButton != selectedButton) {
            this.activeSortButton.setSelected(false);
        }
        this.activeSortButton = selectedButton;
        boolean selected = this.toggleSortOrder(sortType);
        selectedButton.setSelected(selected);
        this.populatePois();
    }

    public void deletePoi(CustomPoi poiToDelete, boolean save) {
        HiddenConfig<List<CustomPoi>> customPois = Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois;
        int deletedPoiIndex = ((List)customPois.get()).indexOf(poiToDelete);
        ((List)customPois.get()).remove(poiToDelete);
        if (save) {
            customPois.touched();
        }
        Managers.Feature.getFeatureInstance(MainMapFeature.class).updateWaypoints();
        this.deletedPois.add(poiToDelete);
        this.deletedIndexes.add(deletedPoiIndex);
        this.undoDeleteButton.active = true;
        if (((List)customPois.get()).isEmpty()) {
            this.searchInput.visible = false;
            this.iconSortButton.visible = false;
            this.nameSortButton.visible = false;
            this.xSortButton.visible = false;
            this.ySortButton.visible = false;
            this.zSortButton.visible = false;
            this.selectAllButton.active = false;
            this.exportButton.active = false;
        }
        if (this.scrollOffset == Math.max(0, this.pois.size() - this.maxPoisToDisplay)) {
            this.scroll(-1);
        }
        this.updateAllUsedIcons();
        this.populatePois();
    }

    public void updatePoiPosition(CustomPoi poiToMove, int direction) {
        int poiToMoveIndex = this.pois.indexOf(poiToMove);
        if (poiToMoveIndex == -1 || poiToMoveIndex + direction < 0 || poiToMoveIndex + direction > this.pois.size() - 1) {
            return;
        }
        CustomPoi poiToSwap = this.pois.get(this.pois.indexOf(poiToMove) + direction);
        HiddenConfig<List<CustomPoi>> customPois = Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois;
        Collections.swap((List)customPois.get(), ((List)customPois.get()).indexOf(poiToMove), ((List)customPois.get()).indexOf(poiToSwap));
        customPois.touched();
        Managers.Feature.getFeatureInstance(MainMapFeature.class).updateWaypoints();
        this.populatePois();
    }

    public List<CustomPoi> getPois() {
        return Collections.unmodifiableList(this.pois);
    }

    public void setFilteredIcons(Map<Texture, Boolean> filteredIcons) {
        this.filteredIcons = filteredIcons;
    }

    private void renderScrollButton(PoseStack poseStack) {
        if (this.pois.size() <= this.maxPoisToDisplay) {
            return;
        }
        this.scrollButtonRenderY = ((float)this.height - this.backgroundHeight) / 2.0f + (float)((int)(this.dividedHeight * 3.0f)) + MathUtils.map(this.scrollOffset, 0.0f, this.pois.size() - this.maxPoisToDisplay, 0.0f, this.scrollAreaHeight);
        RenderUtils.drawScalingTexturedRect(poseStack, Texture.SCROLL_BUTTON.resource(), this.scrollButtonRenderX, this.scrollButtonRenderY, 1.0f, this.dividedWidth / 2.0f, this.scrollButtonHeight, Texture.SCROLL_BUTTON.width(), Texture.SCROLL_BUTTON.height());
    }

    private void scroll(int delta) {
        this.scrollOffset = MathUtils.clamp(this.scrollOffset + delta, 0, Math.max(0, this.pois.size() - this.maxPoisToDisplay));
        this.populatePois();
    }

    private void populatePois() {
        int currentPoi;
        for (AbstractWidget widget : this.poiManagerWidgets) {
            this.removeWidget((GuiEventListener)widget);
        }
        this.poiManagerWidgets.clear();
        this.pois = ((List)Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois.get()).stream().filter(poi -> this.searchMatches(poi.getName())).collect(Collectors.toList());
        if (this.pois.isEmpty()) {
            return;
        }
        this.pois = this.pois.stream().filter(poi -> this.filteredIcons.getOrDefault((Object)poi.getIcon(), true)).collect(Collectors.toList());
        this.iconSortButton.visible = !this.pois.isEmpty();
        this.nameSortButton.visible = !this.pois.isEmpty();
        this.xSortButton.visible = !this.pois.isEmpty();
        this.ySortButton.visible = !this.pois.isEmpty();
        this.zSortButton.visible = !this.pois.isEmpty();
        this.exportButton.active = !this.pois.isEmpty();
        this.selectAllButton.active = !this.pois.isEmpty();
        this.deselectAllButton.active = !this.selectedPois.isEmpty();
        this.setMarkersButton.active = !this.selectedPois.isEmpty();
        boolean bl = this.removeMarkersButton.active = !this.selectedPois.isEmpty();
        if (((List)Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois.get()).isEmpty()) {
            this.searchInput.visible = false;
            this.filterButton.visible = false;
        }
        if (this.pois.isEmpty()) {
            return;
        }
        if (this.sortOrder != null) {
            this.sortPois();
        }
        int row = (int)((float)((int)(this.dividedHeight * 12.0f)) + this.dividedHeight / 2.0f);
        for (int i = 0; i < this.maxPoisToDisplay && (currentPoi = i + this.scrollOffset) <= this.pois.size() - 1; ++i) {
            CustomPoi poi2 = this.pois.get(currentPoi);
            PoiManagerWidget poiWidget = new PoiManagerWidget((int)(this.dividedWidth * 12.0f), row, (int)(this.dividedWidth * 38.0f), 20, poi2, this, this.dividedWidth, this.selectionMode, this.selectedPois.contains(poi2));
            row += 20;
            this.poiManagerWidgets.add(poiWidget);
            this.addRenderableWidget((GuiEventListener)poiWidget);
        }
    }

    private void sortPois() {
        switch (this.sortOrder.ordinal()) {
            case 0: {
                this.pois.sort(Comparator.comparing(CustomPoi::getIcon));
                break;
            }
            case 1: {
                this.pois.sort(Comparator.comparing(CustomPoi::getIcon).reversed());
                break;
            }
            case 2: {
                this.pois.sort(Comparator.comparing(CustomPoi::getName, String.CASE_INSENSITIVE_ORDER));
                break;
            }
            case 3: {
                this.pois.sort(Comparator.comparing(CustomPoi::getName, String.CASE_INSENSITIVE_ORDER).reversed());
                break;
            }
            case 4: {
                this.pois.sort(Comparator.comparing(poi -> poi.getLocation().getX()));
                break;
            }
            case 5: {
                this.pois.sort(Comparator.comparing(poi -> poi.getLocation().getX(), Comparator.reverseOrder()));
                break;
            }
            case 6: {
                this.pois.sort(Comparator.comparing(poi -> poi.getLocation().getY().orElse(null), Comparator.nullsFirst(Comparator.naturalOrder())));
                break;
            }
            case 7: {
                this.pois.sort(Comparator.comparing(poi -> poi.getLocation().getY().orElse(null), Comparator.nullsLast(Comparator.reverseOrder())));
                break;
            }
            case 8: {
                this.pois.sort(Comparator.comparing(poi -> poi.getLocation().getZ()));
                break;
            }
            case 9: {
                this.pois.sort(Comparator.comparing(poi -> poi.getLocation().getZ(), Comparator.reverseOrder()));
            }
        }
    }

    private void toggleMarkers(boolean addMarkers) {
        if (addMarkers) {
            this.selectedPois.forEach(poi -> MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(poi.getLocation().asLocation(), poi.getIcon(), poi.getColor(), poi.getColor(), poi.getName()));
        } else {
            this.selectedPois.forEach(poi -> MarkerModel.USER_WAYPOINTS_PROVIDER.removeLocation(poi.getLocation().asLocation()));
        }
    }

    private void toggleSelectAll(boolean select) {
        MutableComponent tooltip;
        this.selectionMode = select;
        this.upButton.visible = select;
        this.downButton.visible = select;
        this.deleteSelectedButton.active = select;
        if (select) {
            this.selectedPois = this.pois;
            tooltip = Component.translatable((String)"screens.wynntils.poiManagementGui.exportSelected.tooltip", (Object[])new Object[]{this.selectedPois.size()});
        } else {
            this.selectedPois.clear();
            tooltip = Component.translatable((String)"screens.wynntils.poiManagementGui.exportAll.tooltip");
        }
        this.exportButton.setTooltip(Tooltip.create((Component)tooltip));
        this.populatePois();
    }

    private boolean toggleSortOrder(PoiSortType sortType) {
        PoiSortOrder newOrder = null;
        boolean selected = true;
        switch (sortType.ordinal()) {
            case 0: {
                if (this.sortOrder == null) {
                    newOrder = PoiSortOrder.ICON_ASC;
                    break;
                }
                if (this.sortOrder != PoiSortOrder.ICON_ASC) break;
                newOrder = PoiSortOrder.ICON_DESC;
                break;
            }
            case 1: {
                if (this.sortOrder == null) {
                    newOrder = PoiSortOrder.NAME_ASC;
                    break;
                }
                if (this.sortOrder != PoiSortOrder.NAME_ASC) break;
                newOrder = PoiSortOrder.NAME_DESC;
                break;
            }
            case 2: {
                if (this.sortOrder == null) {
                    newOrder = PoiSortOrder.X_ASC;
                    break;
                }
                if (this.sortOrder != PoiSortOrder.X_ASC) break;
                newOrder = PoiSortOrder.X_DESC;
                break;
            }
            case 3: {
                if (this.sortOrder == null) {
                    newOrder = PoiSortOrder.Y_ASC;
                    break;
                }
                if (this.sortOrder != PoiSortOrder.Y_ASC) break;
                newOrder = PoiSortOrder.Y_DESC;
                break;
            }
            case 4: {
                if (this.sortOrder == null) {
                    newOrder = PoiSortOrder.Z_ASC;
                    break;
                }
                if (this.sortOrder != PoiSortOrder.Z_ASC) break;
                newOrder = PoiSortOrder.Z_DESC;
                break;
            }
            default: {
                selected = false;
            }
        }
        this.sortOrder = newOrder;
        return newOrder != null && selected;
    }

    private void updateAllUsedIcons() {
        this.filteredIcons = ((List)Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois.get()).stream().map(CustomPoi::getIcon).distinct().collect(Collectors.toMap(Function.identity(), texture -> this.filteredIcons.getOrDefault(texture, true), (existing, replacement) -> existing, () -> new EnumMap(Texture.class)));
        this.filterButton.visible = this.filteredIcons.size() > 1;
    }

    private boolean searchMatches(String poiName) {
        return StringUtils.partialMatch(poiName, this.searchInput.getTextBoxInput());
    }

    private void updateSelectedPoiPositions(int direction) {
        List orderedPois = this.pois.stream().filter(poi -> this.selectedPois.contains(poi)).collect(Collectors.toList());
        if (direction == 1) {
            Collections.reverse(orderedPois);
        }
        for (CustomPoi selectedPoi : orderedPois) {
            this.updatePoiPosition(selectedPoi, direction);
        }
    }

    private void deleteSelectedPois() {
        HiddenConfig<List<CustomPoi>> customPois = Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois;
        for (CustomPoi poi : this.selectedPois) {
            this.deletePoi(poi, false);
        }
        customPois.touched();
        McUtils.sendMessageToClient((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.deletedPois", (Object[])new Object[]{this.selectedPois.size()}).withStyle(ChatFormatting.GREEN));
        if (((List)customPois.get()).isEmpty()) {
            this.selectAllButton.active = false;
            this.filterButton.visible = false;
            this.iconSortButton.visible = false;
            this.nameSortButton.visible = false;
            this.xSortButton.visible = false;
            this.ySortButton.visible = false;
            this.zSortButton.visible = false;
        }
        if (this.scrollOffset == Math.max(0, this.pois.size() - this.maxPoisToDisplay)) {
            this.scroll(-1);
        }
        this.toggleSelectAll(false);
    }

    private void importFromClipboard() {
        CustomPoi[] customPois;
        String clipboard = McUtils.mc().keyboardHandler.getClipboard();
        try {
            customPois = (CustomPoi[])JsonManager.GSON.fromJson(clipboard, CustomPoi[].class);
        }
        catch (JsonSyntaxException e) {
            McUtils.sendErrorToClient(I18n.get((String)"screens.wynntils.poiManagementGui.import.error", (Object[])new Object[0]));
            return;
        }
        if (customPois == null) {
            McUtils.sendErrorToClient(I18n.get((String)"screens.wynntils.poiManagementGui.import.error", (Object[])new Object[0]));
            return;
        }
        HiddenConfig<List<CustomPoi>> customPoiConfig = Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois;
        ArrayList<CustomPoi> existingPois = new ArrayList<CustomPoi>((Collection)customPoiConfig.get());
        List<CustomPoi> poisToAdd = Stream.of(customPois).filter(newPoi -> !existingPois.contains(newPoi)).toList();
        existingPois.addAll(poisToAdd);
        customPoiConfig.setValue(existingPois);
        customPoiConfig.touched();
        Managers.Feature.getFeatureInstance(MainMapFeature.class).updateWaypoints();
        if (!((List)customPoiConfig.get()).isEmpty()) {
            this.searchInput.visible = true;
            this.filterButton.visible = true;
        }
        this.updateAllUsedIcons();
        this.populatePois();
        McUtils.sendMessageToClient((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.import.success", (Object[])new Object[]{poisToAdd.size()}).withStyle(ChatFormatting.GREEN));
    }

    private void exportToClipboard() {
        List poisToExport = this.selectedPois.isEmpty() ? (List)Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois.get() : this.selectedPois;
        McUtils.mc().keyboardHandler.setClipboard(poisToExport.stream().map(arg_0 -> ((Gson)JsonManager.GSON).toJson(arg_0)).toList().toString());
        McUtils.sendMessageToClient((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.exportedPois", (Object[])new Object[]{poisToExport.size()}).withStyle(ChatFormatting.GREEN));
    }

    private void undoDelete() {
        HiddenConfig<List<CustomPoi>> allPois = Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois;
        if (!((List)allPois.get()).contains(this.deletedPois.getLast())) {
            ((List)allPois.get()).add(this.deletedIndexes.getLast(), this.deletedPois.getLast());
            allPois.touched();
            Managers.Feature.getFeatureInstance(MainMapFeature.class).updateWaypoints();
            this.scrollOffset = Math.max(this.scrollOffset - 1, 0);
            this.updateAllUsedIcons();
            this.populatePois();
        }
        this.deletedIndexes.removeLast();
        this.deletedPois.removeLast();
        this.undoDeleteButton.active = !this.deletedIndexes.isEmpty();
    }

    public static enum PoiSortType {
        ICON,
        NAME,
        X,
        Y,
        Z;

    }

    private static enum PoiSortOrder {
        ICON_ASC,
        ICON_DESC,
        NAME_ASC,
        NAME_DESC,
        X_ASC,
        X_DESC,
        Y_ASC,
        Y_DESC,
        Z_ASC,
        Z_DESC;

    }
}

