/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.maps.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.screens.maps.IconFilterScreen;
import com.wynntils.utils.EnumUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class IconFilterWidget
extends AbstractWidget {
    private final boolean included;
    private final float iconHeight;
    private final float iconRenderX;
    private final float iconRenderY;
    private final float iconWidth;
    private final List<Component> tooltip;
    private final IconFilterScreen filterScreen;
    private final Texture icon;

    public IconFilterWidget(int x, int y, int width, int height, Texture icon, IconFilterScreen filterScreen, boolean included) {
        super(x, y, width, height, (Component)Component.literal((String)"Icon Filter Widget"));
        this.icon = icon;
        this.filterScreen = filterScreen;
        this.included = included;
        float scaleFactor = 0.5f * (float)Math.min(width, height) / (float)Math.max(icon.width(), icon.height());
        this.iconWidth = (float)icon.width() * scaleFactor;
        this.iconHeight = (float)icon.height() * scaleFactor;
        this.iconRenderX = (float)x + (float)width / 2.0f - this.iconWidth / 2.0f;
        this.iconRenderY = (float)y + (float)height / 2.0f - this.iconHeight / 2.0f;
        this.tooltip = included ? List.of(Component.translatable((String)"screens.wynntils.iconFilter.filterExclude.tooltip", (Object[])new Object[]{EnumUtils.toNiceString(icon)})) : List.of(Component.translatable((String)"screens.wynntils.iconFilter.filterInclude.tooltip", (Object[])new Object[]{EnumUtils.toNiceString(icon)}));
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawRect(poseStack, CommonColors.BLACK.withAlpha(this.isHovered ? 0.7f : 0.5f), this.getX(), this.getY(), 0.0f, this.width, this.height);
        RenderUtils.drawScalingTexturedRect(poseStack, this.icon.resource(), this.iconRenderX, this.iconRenderY, 1.0f, this.iconWidth, this.iconHeight, this.icon.width(), this.icon.height());
        if (this.isHovered) {
            McUtils.mc().screen.setTooltipForNextRenderPass(Lists.transform(this.tooltip, Component::getVisualOrderText));
        }
        if (this.included) {
            RenderUtils.drawRect(poseStack, CommonColors.RED.withAlpha(35), this.getX(), this.getY(), 1.0f, this.width, this.height);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        this.filterScreen.toggleIcon(this.icon);
        return true;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

