/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.maps.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.maps.CustomSeaskipperScreen;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class SeaskipperTravelButton
extends WynntilsButton {
    private final CustomSeaskipperScreen seaskipperScreen;

    public SeaskipperTravelButton(int x, int y, int width, int height, CustomSeaskipperScreen seaskipperScreen) {
        super(x, y, width, height, (Component)Component.literal((String)"Travel Button"));
        this.seaskipperScreen = seaskipperScreen;
    }

    public void onPress() {
        this.seaskipperScreen.travelToDestination();
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawTexturedRect(poseStack, Texture.TRAVEL_BUTTON.resource(), this.getX(), this.getY(), 0.0f, this.width, this.height, 0, this.seaskipperScreen.getSelectedDestination() != null ? 0 : Texture.TRAVEL_BUTTON.height() / 2, Texture.TRAVEL_BUTTON.width(), Texture.TRAVEL_BUTTON.height() / 2, Texture.TRAVEL_BUTTON.width(), Texture.TRAVEL_BUTTON.height());
        if (this.isHovered && this.seaskipperScreen.getSelectedDestination() != null) {
            List<MutableComponent> tooltip = List.of(Component.translatable((String)"screens.wynntils.customSeaskipperScreen.travelToDestination", (Object[])new Object[]{this.seaskipperScreen.getSelectedDestination().getName()}).withStyle(ChatFormatting.GRAY));
            McUtils.mc().screen.setTooltipForNextRenderPass(Lists.transform(tooltip, Component::getVisualOrderText));
        }
    }
}

