/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.overlays.selection;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.overlays.CustomNameProperty;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.persisted.Translatable;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.OverlayGroupHolder;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.overlays.CustomBarsOverlayFeature;
import com.wynntils.features.overlays.InfoBoxFeature;
import com.wynntils.overlays.custombars.CustomBarOverlayBase;
import com.wynntils.overlays.infobox.InfoBoxOverlay;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.base.widgets.SearchWidget;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.base.widgets.WynntilsCheckbox;
import com.wynntils.screens.overlays.placement.OverlayManagementScreen;
import com.wynntils.screens.overlays.selection.CustomBarSelectionScreen;
import com.wynntils.screens.overlays.selection.widgets.OverlayButton;
import com.wynntils.screens.overlays.selection.widgets.OverlayOptionsButton;
import com.wynntils.screens.settings.widgets.ConfigTile;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;

public final class OverlaySelectionScreen
extends WynntilsScreen {
    private static final float SCROLL_FACTOR = 10.0f;
    private static final int CONFIG_MASK_TOP_Y = 25;
    private static final int CONFIG_MASK_BOTTOM_Y = 197;
    private static final int CONFIGS_PER_PAGE = 4;
    private static final int MAX_OVERLAYS_PER_PAGE = 8;
    private List<Overlay> overlayList = new ArrayList<Overlay>();
    private List<OverlayButton> overlays = new ArrayList<OverlayButton>();
    private List<OverlayOptionsButton> optionButtons = new ArrayList<OverlayOptionsButton>();
    private List<WynntilsButton> configs = new ArrayList<WynntilsButton>();
    private final SearchWidget searchWidget;
    private Button exitPreviewButton;
    private OverlayOptionsButton allButton;
    private OverlayOptionsButton builtInButton;
    private OverlayOptionsButton customButton;
    private OverlayOptionsButton selectedFilterButton;
    private TextInputBoxWidget focusedTextInput;
    private WynntilsCheckbox renderOverlaysCheckbox;
    private boolean draggingOverlayScroll = false;
    private boolean draggingConfigScroll = false;
    private float configScrollY;
    private float overlayScrollY;
    private int offsetX;
    private int offsetY;
    private int configScrollOffset = 0;
    private int overlayScrollOffset = 0;
    private boolean renderPreview = false;
    private boolean showOverlays = false;
    private FilterType filterType = FilterType.ALL;
    private Overlay selectedOverlay;

    private OverlaySelectionScreen() {
        super((Component)Component.translatable((String)"screens.wynntils.overlaySelection.name"));
        this.searchWidget = new SearchWidget(7, 6, 120, 20, s -> {
            this.overlayScrollOffset = 0;
            this.populateOverlays();
        }, this);
        this.setFocusedTextInput(this.searchWidget);
    }

    public static Screen create() {
        return new OverlaySelectionScreen();
    }

    @Override
    protected void doInit() {
        this.offsetX = (int)((float)(this.width - Texture.OVERLAY_SELECTION_GUI.width()) / 2.0f);
        this.offsetY = (int)((float)(this.height - Texture.OVERLAY_SELECTION_GUI.height()) / 2.0f);
        this.searchWidget.setX(7 + this.offsetX);
        this.searchWidget.setY(6 + this.offsetY);
        this.addOptionButtons();
        this.exitPreviewButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"screens.wynntils.overlaySelection.exitPreview"), button -> this.togglePreview(false)).pos((int)((float)Texture.OVERLAY_SELECTION_GUI.width() / 2.0f - 40.0f) + this.offsetX, this.height - 25).size(80, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.overlaySelection.exitPreviewTooltip"))).build());
        this.renderOverlaysCheckbox = (WynntilsCheckbox)this.addRenderableWidget((GuiEventListener)new WynntilsCheckbox(Texture.OVERLAY_SELECTION_GUI.width() / 2 - 70 + this.offsetX, this.height - 70, 20, (Component)Component.translatable((String)"screens.wynntils.overlaySelection.showOverlays"), this.showOverlays, 120, (c, b) -> {
            this.showOverlays = b;
        }, ComponentUtils.wrapTooltips(List.of(Component.translatable((String)"screens.wynntils.overlaySelection.showOverlaysTooltip")), 150)));
        this.togglePreview(this.renderPreview);
        this.addRenderableWidget((GuiEventListener)this.searchWidget);
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        if (!this.renderPreview) {
            RenderUtils.drawTexturedRect(poseStack, Texture.OVERLAY_SELECTION_GUI, this.offsetX, this.offsetY);
            this.searchWidget.render(guiGraphics, mouseX, mouseY, partialTick);
            this.renderWidgets(guiGraphics, mouseX, mouseY, partialTick);
            if (this.selectedOverlay != null) {
                CustomNameProperty customNameProperty;
                String textToRender = this.selectedOverlay.getTranslatedName();
                Overlay overlay = this.selectedOverlay;
                if (overlay instanceof CustomNameProperty && !((String)(customNameProperty = (CustomNameProperty)((Object)overlay)).getCustomName().get()).isEmpty()) {
                    textToRender = (String)customNameProperty.getCustomName().get();
                }
                FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(textToRender), 146 + this.offsetX, 338 + this.offsetX, 4 + this.offsetY, 24 + this.offsetY, 200.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
            } else {
                FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.overlaySelection.unselectedOverlay")), 146 + this.offsetX, 338 + this.offsetX, 67 + this.offsetY, 160 + this.offsetY, 200.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NORMAL);
            }
            if (this.overlayList.size() > 8) {
                this.renderOverlayScroll(poseStack);
            }
            if (this.selectedOverlay != null && this.selectedOverlay.getVisibleConfigOptions().size() > 4) {
                this.renderConfigScroll(poseStack);
            }
            this.renderTooltips(guiGraphics, mouseX, mouseY);
        } else {
            if (this.selectedOverlay == null) {
                this.renderPreview = false;
                return;
            }
            this.renderOverlaysCheckbox.render(guiGraphics, mouseX, mouseY, partialTick);
            this.exitPreviewButton.render(guiGraphics, mouseX, mouseY, partialTick);
            this.selectedOverlay.renderPreview(guiGraphics, (MultiBufferSource)guiGraphics.bufferSource, DeltaTracker.ZERO, McUtils.window());
            RenderUtils.drawRectBorders(poseStack, CommonColors.RED, this.selectedOverlay.getRenderX(), this.selectedOverlay.getRenderY(), this.selectedOverlay.getRenderX() + this.selectedOverlay.getWidth(), this.selectedOverlay.getRenderY() + this.selectedOverlay.getHeight(), 1.0f, 1.0f);
        }
    }

    public void added() {
        this.searchWidget.opened();
        super.added();
    }

    public void onClose() {
        super.onClose();
        this.renderPreview = false;
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.renderPreview) {
            if (!this.draggingOverlayScroll && this.overlayList.size() > 8 && MathUtils.isInside((int)mouseX, (int)mouseY, this.offsetX + 133, this.offsetX + 133 + Texture.SCROLL_BUTTON.width(), (int)this.overlayScrollY, (int)(this.overlayScrollY + (float)Texture.SCROLL_BUTTON.height()))) {
                this.draggingOverlayScroll = true;
                return true;
            }
            if (!this.draggingConfigScroll && this.selectedOverlay != null && this.selectedOverlay.getVisibleConfigOptions().size() > 4 && MathUtils.isInside((int)mouseX, (int)mouseY, this.offsetX + 344, this.offsetX + 344 + Texture.SCROLL_BUTTON.width(), (int)this.configScrollY, (int)(this.configScrollY + (float)Texture.SCROLL_BUTTON.height()))) {
                this.draggingConfigScroll = true;
                return true;
            }
        }
        for (GuiEventListener listener : this.getWidgetsForIteration().toList()) {
            if (!listener.isMouseOver(mouseX, mouseY)) continue;
            if (listener instanceof OverlayOptionsButton && MathUtils.isInside((int)mouseX, (int)mouseY, this.offsetX, this.offsetX + Texture.OVERLAY_SELECTION_GUI.width(), this.offsetY, this.offsetY + Texture.OVERLAY_SELECTION_GUI.height())) {
                return false;
            }
            listener.mouseClicked(mouseX, mouseY, button);
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingOverlayScroll) {
            int scrollAreaStartY = 34 + this.offsetY;
            int scrollAreaHeight = 168 - Texture.SCROLL_BUTTON.height();
            int newOffset = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, scrollAreaStartY + scrollAreaHeight, 0.0f, this.getMaxOverlayScrollOffset()));
            newOffset = Math.max(0, Math.min(newOffset, this.getMaxOverlayScrollOffset()));
            this.scrollOverlays(newOffset);
            return true;
        }
        if (this.draggingConfigScroll) {
            int scrollAreaStartY = 34 + this.offsetY;
            int scrollAreaHeight = 172 - Texture.SCROLL_BUTTON.height();
            int newOffset = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, scrollAreaStartY + scrollAreaHeight, 0.0f, this.getMaxConfigScrollOffset()));
            newOffset = Math.max(0, Math.min(newOffset, this.getMaxConfigScrollOffset()));
            this.scrollConfigs(newOffset);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (GuiEventListener listener : this.getWidgetsForIteration().toList()) {
            if (!listener.isMouseOver(mouseX, mouseY)) continue;
            listener.mouseReleased(mouseX, mouseY, button);
        }
        this.draggingOverlayScroll = false;
        this.draggingConfigScroll = false;
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        int scrollAmount = (int)(-deltaY * 10.0);
        if (!this.renderPreview) {
            if (mouseX < (double)(145 + this.offsetX) || this.selectedOverlay == null) {
                int newOffset = Math.max(0, Math.min(this.overlayScrollOffset + scrollAmount, this.getMaxOverlayScrollOffset()));
                this.scrollOverlays(newOffset);
            } else if (this.selectedOverlay.getVisibleConfigOptions().size() > 4) {
                int newOffset = Math.max(0, Math.min(this.configScrollOffset + scrollAmount, this.getMaxConfigScrollOffset()));
                this.scrollConfigs(newOffset);
            }
        }
        return true;
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        return this.focusedTextInput != null && this.focusedTextInput.charTyped(codePoint, modifiers);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.renderPreview) {
                this.togglePreview(false);
            } else {
                this.onClose();
            }
            return true;
        }
        for (OverlayButton overlayButton : this.overlays) {
            if (!overlayButton.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return this.focusedTextInput != null && this.focusedTextInput.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public TextInputBoxWidget getFocusedTextInput() {
        return this.focusedTextInput;
    }

    @Override
    public void setFocusedTextInput(TextInputBoxWidget focusedTextInput) {
        this.focusedTextInput = focusedTextInput;
    }

    public boolean configOptionContains(Config<?> config) {
        return !this.searchWidget.getTextBoxInput().isEmpty() && StringUtils.containsIgnoreCase(config.getDisplayName(), this.searchWidget.getTextBoxInput());
    }

    public void populateOverlays() {
        for (AbstractWidget abstractWidget : this.overlays) {
            this.removeWidget((GuiEventListener)abstractWidget);
        }
        this.overlays = new ArrayList<OverlayButton>();
        this.overlayList = Managers.Overlay.getOverlays().stream().sorted(Overlay::compareTo).filter(this::searchMatches).toList();
        if (this.filterType == FilterType.BUILT_IN) {
            this.overlayList = this.overlayList.stream().filter(overlay -> !(overlay instanceof CustomBarOverlayBase) && !(overlay instanceof InfoBoxOverlay)).toList();
        } else if (this.filterType == FilterType.CUSTOM) {
            this.overlayList = this.overlayList.stream().filter(overlay -> overlay instanceof CustomBarOverlayBase || overlay instanceof InfoBoxOverlay).toList();
        }
        if (!(this.overlayList.contains(this.selectedOverlay) || this.filterType != FilterType.BUILT_IN && (this.selectedOverlay instanceof CustomBarOverlayBase || this.selectedOverlay instanceof InfoBoxOverlay))) {
            this.setSelectedOverlay(null);
        }
        int yPos = 31 + this.offsetY;
        for (Overlay value : this.overlayList) {
            this.overlays.add(new OverlayButton(7 + this.offsetX, yPos, 120, 18, value, this));
            yPos += 21;
        }
        if (this.selectedOverlay != null) {
            Stream stream = Managers.Feature.getFeatures().stream().map(Managers.Overlay::getFeatureOverlays).flatMap(Collection::stream);
            Overlay newSelected = stream.filter(overlay -> overlay.getJsonName().equals(this.selectedOverlay.getJsonName())).findFirst().orElse(null);
            this.setSelectedOverlay(newSelected);
        }
        this.scrollOverlays(this.overlayScrollOffset);
    }

    public void selectOverlay(Overlay selectedOverlay) {
        this.configScrollOffset = 0;
        this.setSelectedOverlay(selectedOverlay);
    }

    private void setSelectedOverlay(Overlay selectedOverlay) {
        if (this.selectedOverlay != null) {
            for (OverlayButton overlayButton : this.overlays) {
                if (overlayButton.getOverlay() != this.selectedOverlay) continue;
                overlayButton.hideEditInput();
                break;
            }
        }
        this.selectedOverlay = selectedOverlay;
        this.populateConfigs();
        this.addOptionButtons();
    }

    private void deleteOverlay() {
        int overlayId = -1;
        Overlay overlay = this.selectedOverlay;
        if (overlay instanceof InfoBoxOverlay) {
            InfoBoxOverlay infoBoxOverlay = (InfoBoxOverlay)overlay;
            overlayId = infoBoxOverlay.getId();
        } else {
            overlay = this.selectedOverlay;
            if (overlay instanceof CustomBarOverlayBase) {
                CustomBarOverlayBase customBarOverlay = (CustomBarOverlayBase)overlay;
                overlayId = customBarOverlay.getId();
            }
        }
        if (overlayId == -1) {
            return;
        }
        OverlayGroupHolder overlayGroupHolder = this.getGroupHolder();
        if (overlayGroupHolder == null) {
            WynntilsMod.error("Failed to delete, overlay group not found for overlay " + this.selectedOverlay.getJsonName());
            return;
        }
        Managers.Overlay.removeIdFromOverlayGroup(overlayGroupHolder, overlayId);
        Managers.Config.reloadConfiguration(false);
        Managers.Config.saveConfig();
        Managers.Config.reloadConfiguration(true);
        this.selectedOverlay = null;
        this.populateConfigs();
        this.overlayScrollOffset = 0;
        this.populateOverlays();
        this.addOptionButtons();
    }

    private OverlayGroupHolder getGroupHolder() {
        Feature feature = this.selectedOverlay instanceof InfoBoxOverlay ? Managers.Feature.getFeatureInstance(InfoBoxFeature.class) : Managers.Feature.getFeatureInstance(CustomBarsOverlayFeature.class);
        for (OverlayGroupHolder group : Managers.Overlay.getFeatureOverlayGroups(feature)) {
            if (!group.getOverlays().contains(this.selectedOverlay)) continue;
            return group;
        }
        return null;
    }

    public Overlay getSelectedOverlay() {
        return this.selectedOverlay;
    }

    public boolean renderingPreview() {
        return this.renderPreview;
    }

    public boolean shouldShowOverlays() {
        return this.showOverlays;
    }

    public int getConfigMaskTopY() {
        return this.offsetY + 25;
    }

    public int getConfigMaskBottomY() {
        return this.offsetY + 197;
    }

    private void populateConfigs() {
        this.configs = new ArrayList<WynntilsButton>();
        if (this.selectedOverlay == null) {
            return;
        }
        List<Config> configsOptions = this.selectedOverlay.getVisibleConfigOptions().stream().sorted(Comparator.comparing(config -> !Objects.equals(config.getFieldName(), "userEnabled"))).toList();
        int renderY = 31 + this.offsetY;
        for (Config config2 : configsOptions) {
            this.configs.add(new ConfigTile(148 + this.offsetX, renderY, 188, 41, this, config2, this.selectedOverlay));
            renderY += 43;
        }
        this.scrollConfigs(this.configScrollOffset);
    }

    private void togglePreview(boolean enabled) {
        if (this.selectedOverlay == null && enabled) {
            return;
        }
        this.renderPreview = enabled;
        for (OverlayOptionsButton optionsButton : this.optionButtons) {
            optionsButton.visible = !enabled;
        }
        this.exitPreviewButton.visible = enabled;
        if (enabled) {
            this.overlays = new ArrayList<OverlayButton>();
            this.configs = new ArrayList<WynntilsButton>();
        } else {
            this.populateOverlays();
            this.populateConfigs();
        }
    }

    private void scrollOverlays(int newOffset) {
        this.overlayScrollOffset = newOffset;
        for (OverlayButton overlay : this.overlays) {
            int newY = 31 + this.offsetY + this.overlays.indexOf((Object)overlay) * 21 - this.overlayScrollOffset;
            overlay.setY(newY);
            overlay.visible = newY >= 31 + this.offsetY - 21 && newY <= 31 + this.offsetY + 168;
        }
    }

    private int getMaxOverlayScrollOffset() {
        return (this.overlayList.size() - 8) * 21;
    }

    private void scrollConfigs(int newOffset) {
        this.configScrollOffset = newOffset;
        for (WynntilsButton config : this.configs) {
            int newY = 31 + this.offsetY + this.configs.indexOf((Object)config) * 43 - this.configScrollOffset;
            config.setY(newY);
            config.visible = newY >= 31 + this.offsetY - 43 && newY <= 31 + this.offsetY + 215;
        }
    }

    private int getMaxConfigScrollOffset() {
        return (this.configs.size() - 4) * 43 + 6;
    }

    private void addInfoBox() {
        Managers.Config.saveConfig();
        InfoBoxFeature infoBoxFeature = Managers.Feature.getFeatureInstance(InfoBoxFeature.class);
        for (OverlayGroupHolder group : Managers.Overlay.getFeatureOverlayGroups(infoBoxFeature)) {
            if (group.getParent() != infoBoxFeature) continue;
            int id = Managers.Overlay.extendOverlayGroup(group);
            Managers.Config.reloadConfiguration(false);
            Managers.Config.saveConfig();
            Managers.Config.reloadConfiguration(true);
            this.populateOverlays();
            this.setSelectedOverlay(group.getOverlays().getLast());
            McUtils.sendMessageToClient((Component)Component.translatable((String)"screens.wynntils.overlaySelection.createdOverlay", (Object[])new Object[]{group.getOverlayClass().getSimpleName(), group.getFieldName(), id}).withStyle(ChatFormatting.GREEN));
            return;
        }
    }

    private void setSelectedFilter(FilterType newFilter) {
        this.selectedFilterButton.setIsSelected(false);
        switch (newFilter.ordinal()) {
            case 1: {
                this.builtInButton.setIsSelected(true);
                this.selectedFilterButton = this.builtInButton;
                break;
            }
            case 2: {
                this.customButton.setIsSelected(true);
                this.selectedFilterButton = this.customButton;
                break;
            }
            default: {
                this.allButton.setIsSelected(true);
                this.selectedFilterButton = this.allButton;
            }
        }
        this.filterType = newFilter;
        this.overlayScrollOffset = 0;
        this.populateOverlays();
    }

    private boolean searchMatches(Translatable translatable) {
        CustomNameProperty customNameProperty;
        if (translatable instanceof CustomNameProperty && StringUtils.partialMatch((String)(customNameProperty = (CustomNameProperty)((Object)translatable)).getCustomName().get(), this.searchWidget.getTextBoxInput())) {
            return true;
        }
        return StringUtils.partialMatch(translatable.getTranslatedName(), this.searchWidget.getTextBoxInput());
    }

    private Stream<GuiEventListener> getWidgetsForIteration() {
        return Stream.concat(this.children.stream(), Stream.concat(this.optionButtons.stream(), Stream.concat(this.overlays.stream(), this.configs.stream())));
    }

    private void addOptionButtons() {
        this.optionButtons = new ArrayList<OverlayOptionsButton>();
        this.optionButtons.add(new OverlayOptionsButton((int)((float)Texture.OVERLAY_SELECTION_GUI.width() / 2.0f - 130.0f + (float)this.offsetX), (int)(-((float)Texture.BUTTON_TOP.height() / 2.0f) + 4.0f + (float)this.offsetY), Texture.BUTTON_TOP.width(), Texture.BUTTON_TOP.height() / 2, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.overlaySelection.addInfoBox")), button -> this.addInfoBox(), List.of(Component.translatable((String)"screens.wynntils.overlaySelection.addInfoBoxTooltip")), Texture.BUTTON_TOP, false, this.offsetX, this.offsetY));
        this.optionButtons.add(new OverlayOptionsButton((int)((float)Texture.OVERLAY_SELECTION_GUI.width() / 2.0f + 10.0f + (float)this.offsetX), (int)(-((float)Texture.BUTTON_TOP.height() / 2.0f) + 4.0f + (float)this.offsetY), Texture.BUTTON_TOP.width(), Texture.BUTTON_TOP.height() / 2, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.overlaySelection.addCustomBar")), button -> McUtils.mc().setScreen(CustomBarSelectionScreen.create(this)), List.of(Component.translatable((String)"screens.wynntils.overlaySelection.addCustomBarTooltip")), Texture.BUTTON_TOP, false, this.offsetX, this.offsetY));
        this.allButton = new OverlayOptionsButton(-Texture.BUTTON_LEFT.width() + 4 + this.offsetX, 8 + this.offsetY, Texture.BUTTON_LEFT.width(), Texture.BUTTON_LEFT.height() / 2, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.overlaySelection.all")), button -> this.setSelectedFilter(FilterType.ALL), List.of(Component.translatable((String)"screens.wynntils.overlaySelection.allTooltip")), Texture.BUTTON_LEFT, this.filterType == FilterType.ALL, this.offsetX, this.offsetY);
        this.optionButtons.add(this.allButton);
        this.builtInButton = new OverlayOptionsButton(-Texture.BUTTON_LEFT.width() + 4 + this.offsetX, (int)(12.0f + (float)Texture.BUTTON_LEFT.height() / 2.0f + (float)this.offsetY), Texture.BUTTON_LEFT.width(), Texture.BUTTON_LEFT.height() / 2, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.overlaySelection.builtIn")), button -> this.setSelectedFilter(FilterType.BUILT_IN), List.of(Component.translatable((String)"screens.wynntils.overlaySelection.builtInTooltip")), Texture.BUTTON_LEFT, this.filterType == FilterType.BUILT_IN, this.offsetX, this.offsetY);
        this.optionButtons.add(this.builtInButton);
        this.customButton = new OverlayOptionsButton(-Texture.BUTTON_LEFT.width() + 4 + this.offsetX, (int)(16.0f + (float)Texture.BUTTON_LEFT.height() / 2.0f * 2.0f + (float)this.offsetY), Texture.BUTTON_LEFT.width(), Texture.BUTTON_LEFT.height() / 2, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.overlaySelection.custom")), button -> this.setSelectedFilter(FilterType.CUSTOM), List.of(Component.translatable((String)"screens.wynntils.overlaySelection.customTooltip")), Texture.BUTTON_LEFT, this.filterType == FilterType.CUSTOM, this.offsetX, this.offsetY);
        this.optionButtons.add(this.customButton);
        switch (this.filterType.ordinal()) {
            case 1: {
                this.selectedFilterButton = this.builtInButton;
                break;
            }
            case 2: {
                this.selectedFilterButton = this.customButton;
                break;
            }
            default: {
                this.selectedFilterButton = this.allButton;
            }
        }
        OverlayOptionsButton deleteButton = new OverlayOptionsButton(-Texture.BUTTON_LEFT.width() + 4 + this.offsetX, (int)(28.0f + (float)Texture.BUTTON_LEFT.height() / 2.0f * 5.0f + (float)this.offsetY), Texture.BUTTON_LEFT.width(), Texture.BUTTON_LEFT.height() / 2, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.overlaySelection.delete")), button -> this.deleteOverlay(), List.of(Component.translatable((String)"screens.wynntils.overlaySelection.deleteTooltip")), Texture.BUTTON_LEFT, false, this.offsetX, this.offsetY);
        this.optionButtons.add(deleteButton);
        deleteButton.visible = this.selectedOverlay != null && (this.selectedOverlay instanceof InfoBoxOverlay || this.selectedOverlay instanceof CustomBarOverlayBase);
        this.optionButtons.add(new OverlayOptionsButton((int)((float)Texture.OVERLAY_SELECTION_GUI.width() / 2.0f - 100.0f + (float)this.offsetX), Texture.OVERLAY_SELECTION_GUI.height() - 4 + this.offsetY, Texture.BUTTON_BOTTOM.width(), Texture.BUTTON_BOTTOM.height() / 2, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.overlaySelection.freeMove")), button -> {
            Managers.Config.saveConfig();
            McUtils.mc().setScreen(OverlayManagementScreen.create(this));
        }, List.of(Component.translatable((String)"screens.wynntils.overlaySelection.freeMoveTooltip")), Texture.BUTTON_BOTTOM, false, this.offsetX, this.offsetY));
        this.optionButtons.add(new OverlayOptionsButton((int)((float)Texture.OVERLAY_SELECTION_GUI.width() / 2.0f - 30.0f + (float)this.offsetX), Texture.OVERLAY_SELECTION_GUI.height() - 4 + this.offsetY, Texture.BUTTON_BOTTOM.width(), Texture.BUTTON_BOTTOM.height() / 2, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.overlaySelection.close")), button -> this.onClose(), List.of(Component.translatable((String)"screens.wynntils.overlaySelection.closeTooltip")), Texture.BUTTON_BOTTOM, false, this.offsetX, this.offsetY));
        this.optionButtons.add(new OverlayOptionsButton((int)((float)Texture.OVERLAY_SELECTION_GUI.width() / 2.0f + 40.0f + (float)this.offsetX), Texture.OVERLAY_SELECTION_GUI.height() - 4 + this.offsetY, Texture.BUTTON_BOTTOM.width(), Texture.BUTTON_BOTTOM.height() / 2, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.overlaySelection.save")), button -> {
            Managers.Config.saveConfig();
            this.onClose();
        }, List.of(Component.translatable((String)"screens.wynntils.overlaySelection.saveTooltip")), Texture.BUTTON_BOTTOM, false, this.offsetX, this.offsetY));
        if (this.selectedOverlay != null) {
            this.optionButtons.add(new OverlayOptionsButton((int)((float)Texture.OVERLAY_SELECTION_GUI.width() / 2.0f - 170.0f + (float)this.offsetX), Texture.OVERLAY_SELECTION_GUI.height() - 4 + this.offsetY, Texture.BUTTON_BOTTOM.width(), Texture.BUTTON_BOTTOM.height() / 2, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.overlaySelection.preview")), button -> this.togglePreview(true), List.of(Component.translatable((String)"screens.wynntils.overlaySelection.previewTooltip")), Texture.BUTTON_BOTTOM, false, this.offsetX, this.offsetY));
            this.optionButtons.add(new OverlayOptionsButton((int)((float)Texture.OVERLAY_SELECTION_GUI.width() / 2.0f + 110.0f + (float)this.offsetX), Texture.OVERLAY_SELECTION_GUI.height() - 4 + this.offsetY, Texture.BUTTON_BOTTOM.width(), Texture.BUTTON_BOTTOM.height() / 2, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.overlaySelection.edit")), button -> {
                if (this.selectedOverlay != null) {
                    Managers.Config.saveConfig();
                    McUtils.mc().setScreen(OverlayManagementScreen.create(this, this.selectedOverlay));
                }
            }, List.of(Component.translatable((String)"screens.wynntils.overlaySelection.editTooltip")), Texture.BUTTON_BOTTOM, false, this.offsetX, this.offsetY));
        }
    }

    private void renderWidgets(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (OverlayOptionsButton overlayOptionsButton : this.optionButtons) {
            overlayOptionsButton.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        RenderUtils.enableScissor(guiGraphics, 6 + this.offsetX, 28 + this.offsetY, 122, 170);
        for (AbstractWidget abstractWidget : this.overlays) {
            abstractWidget.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        RenderUtils.disableScissor(guiGraphics);
        RenderUtils.enableScissor(guiGraphics, 148 + this.offsetX, 28 + this.offsetY, 188, 170);
        for (AbstractWidget abstractWidget : this.configs) {
            abstractWidget.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        RenderUtils.disableScissor(guiGraphics);
    }

    private void renderOverlayScroll(PoseStack poseStack) {
        this.overlayScrollY = (float)(24 + this.offsetY) + MathUtils.map(this.overlayScrollOffset, 0.0f, this.getMaxOverlayScrollOffset(), 0.0f, 177 - Texture.CONFIG_BOOK_SCROLL_BUTTON.height());
        RenderUtils.drawTexturedRect(poseStack, Texture.SCROLL_BUTTON, 133 + this.offsetX, this.overlayScrollY);
    }

    private void renderConfigScroll(PoseStack poseStack) {
        this.configScrollY = (float)(24 + this.offsetY) + MathUtils.map(this.configScrollOffset, 0.0f, this.getMaxConfigScrollOffset(), 0.0f, 177 - Texture.CONFIG_BOOK_SCROLL_BUTTON.height());
        RenderUtils.drawTexturedRect(poseStack, Texture.SCROLL_BUTTON, 344 + this.offsetX, this.configScrollY);
    }

    private void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (MathUtils.isInside(mouseX, mouseY, this.offsetX, Texture.OVERLAY_SELECTION_GUI.width(), this.offsetY, Texture.OVERLAY_SELECTION_GUI.height())) {
            return;
        }
        for (GuiEventListener guiEventListener : this.optionButtons) {
            if (!(guiEventListener instanceof TooltipProvider)) continue;
            TooltipProvider tooltipProvider = (TooltipProvider)guiEventListener;
            if (!guiEventListener.isMouseOver((double)mouseX, (double)mouseY)) continue;
            guiGraphics.renderComponentTooltip(FontRenderer.getInstance().getFont(), tooltipProvider.getTooltipLines(), mouseX, mouseY);
            break;
        }
    }

    private static enum FilterType {
        ALL,
        BUILT_IN,
        CUSTOM;

    }
}

