/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.playerviewer;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.core.net.UrlId;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.inventory.type.InventoryAccessory;
import com.wynntils.models.inventory.type.InventoryArmor;
import com.wynntils.models.items.FakeItemStack;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.CharmItem;
import com.wynntils.models.items.items.game.CraftedGearItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.items.game.TomeItem;
import com.wynntils.screens.base.WynntilsContainerScreen;
import com.wynntils.screens.base.widgets.InfoButton;
import com.wynntils.screens.playerviewer.GearSharingSettingsScreen;
import com.wynntils.screens.playerviewer.PlayerViewerMenu;
import com.wynntils.screens.playerviewer.widgets.FriendButton;
import com.wynntils.screens.playerviewer.widgets.PartyButton;
import com.wynntils.screens.playerviewer.widgets.PlayerInteractionButton;
import com.wynntils.screens.playerviewer.widgets.SimplePlayerInteractionButton;
import com.wynntils.services.hades.HadesUser;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;

public final class PlayerViewerScreen
extends WynntilsContainerScreen<PlayerViewerMenu> {
    private static final String TEAM_NAME = "PlayerViewerTeam";
    private final Player player;
    private final Scoreboard scoreboard;
    private final PlayerTeam playerViewerTeam;
    private final PlayerTeam oldTeam;
    private final List<PlayerInteractionButton> interactionButtons = new ArrayList<PlayerInteractionButton>();
    private Button settingsButton;
    private FriendButton friendButton;
    private InfoButton infoButton;
    private PartyButton partyButton;
    private static boolean noGear = true;

    private PlayerViewerScreen(Player player, PlayerViewerMenu menu) {
        super(menu, player.getInventory(), (Component)Component.empty());
        this.player = player;
        this.scoreboard = player.level().getScoreboard();
        if (this.scoreboard.getTeamNames().contains(TEAM_NAME)) {
            this.playerViewerTeam = this.scoreboard.getPlayerTeam(TEAM_NAME);
        } else {
            this.playerViewerTeam = this.scoreboard.addPlayerTeam(TEAM_NAME);
            this.playerViewerTeam.setNameTagVisibility(Team.Visibility.NEVER);
        }
        this.oldTeam = this.scoreboard.getPlayersTeam(player.getScoreboardName());
        this.scoreboard.addPlayerToTeam(player.getScoreboardName(), this.playerViewerTeam);
    }

    public static Screen create(Player player) {
        Optional<HadesUser> hadesUserOpt = Services.Hades.getHadesUser(player.getUUID());
        ItemStack heldItem = ItemStack.EMPTY;
        ArrayList<ItemStack> armorItems = new ArrayList<ItemStack>();
        ArrayList<ItemStack> accessoryItems = new ArrayList<ItemStack>();
        if (hadesUserOpt.isPresent()) {
            WynnItem wynnItem;
            heldItem = PlayerViewerScreen.createDecoratedItemStack(hadesUserOpt.get().getHeldItem(), player);
            noGear = heldItem.isEmpty();
            for (InventoryAccessory inventoryAccessory : InventoryAccessory.values()) {
                wynnItem = (WynnItem)hadesUserOpt.get().getAccessories().get((Object)inventoryAccessory);
                if (wynnItem == null) {
                    accessoryItems.add(ItemStack.EMPTY);
                    continue;
                }
                ItemStack accessoryItemStack = PlayerViewerScreen.createDecoratedItemStack(wynnItem, player);
                accessoryItems.add(accessoryItemStack);
                noGear = false;
            }
            for (Enum enum_ : InventoryArmor.values()) {
                wynnItem = (WynnItem)hadesUserOpt.get().getArmor().get(enum_);
                if (wynnItem == null) {
                    armorItems.add(ItemStack.EMPTY);
                    continue;
                }
                ItemStack armorItemStack = PlayerViewerScreen.createDecoratedItemStack(wynnItem, player);
                armorItems.add(armorItemStack);
                noGear = false;
            }
        }
        return new PlayerViewerScreen(player, PlayerViewerMenu.create(heldItem, armorItems, accessoryItems));
    }

    private static ItemStack createDecoratedItemStack(WynnItem wynnItem, Player player) {
        ItemStack itemStack = ItemStack.EMPTY;
        if (wynnItem instanceof GearItem) {
            GearItem gearItem = (GearItem)wynnItem;
            itemStack = gearItem.getItemInfo().metaInfo().material().itemStack();
        } else if (wynnItem instanceof TomeItem) {
            TomeItem tomeItem = (TomeItem)wynnItem;
            itemStack = tomeItem.getItemInfo().metaInfo().material().itemStack();
        } else if (wynnItem instanceof CharmItem) {
            CharmItem charmItem = (CharmItem)wynnItem;
            itemStack = charmItem.getItemInfo().metaInfo().material().itemStack();
        } else if (wynnItem instanceof CraftedGearItem) {
            CraftedGearItem craftedGearItem = (CraftedGearItem)wynnItem;
            if (craftedGearItem.getGearType().isArmor()) {
                itemStack = (ItemStack)player.getInventory().armor.get(InventoryArmor.fromString(craftedGearItem.getGearType().name()).getArmorSlot());
            } else if (craftedGearItem.getGearType().isWeapon()) {
                itemStack = player.getMainHandItem();
            } else {
                itemStack = new ItemStack((ItemLike)Items.POTION);
                CustomModelData customModelData = new CustomModelData(List.of(Float.valueOf(craftedGearItem.getGearType().getDefaultModel())), List.of(), List.of(), List.of());
                DataComponentMap.Builder componentsBuilder = DataComponentMap.builder().set(DataComponents.CUSTOM_MODEL_DATA, (Object)customModelData);
                itemStack.applyComponents(componentsBuilder.build());
            }
        }
        return new FakeItemStack(wynnItem, itemStack, "From " + player.getScoreboardName());
    }

    @Override
    protected void doInit() {
        this.interactionButtons.clear();
        this.leftPos = (this.width - Texture.PLAYER_VIEWER_BACKGROUND.width()) / 2;
        this.topPos = (this.height - Texture.PLAYER_VIEWER_BACKGROUND.height()) / 2;
        String playerName = StyledText.fromComponent(this.player.getName()).getStringWithoutFormatting();
        this.interactionButtons.add(new SimplePlayerInteractionButton(this.leftPos - 21, this.topPos + (Texture.PLAYER_VIEWER_BACKGROUND.height() / 5 - 2), (Component)Component.translatable((String)"screens.wynntils.playerViewer.viewStats"), Texture.STATS_ICON, () -> Managers.Net.openLink(UrlId.LINK_WYNNCRAFT_PLAYER_STATS, Map.of("username", playerName))));
        this.friendButton = new FriendButton(this.leftPos - 21, this.topPos + Texture.PLAYER_VIEWER_BACKGROUND.height() / 5 + 18, playerName);
        this.interactionButtons.add(this.friendButton);
        this.partyButton = new PartyButton(this.leftPos - 21, this.topPos + Texture.PLAYER_VIEWER_BACKGROUND.height() / 5 + 38, playerName);
        this.interactionButtons.add(this.partyButton);
        this.interactionButtons.add(new SimplePlayerInteractionButton(this.leftPos + Texture.PLAYER_VIEWER_BACKGROUND.width() + 1, this.topPos + Texture.PLAYER_VIEWER_BACKGROUND.height() / 5 - 2, (Component)Component.translatable((String)"screens.wynntils.playerViewer.duel"), Texture.DUEL_ICON, () -> Handlers.Command.queueCommand("duel " + playerName)));
        this.interactionButtons.add(new SimplePlayerInteractionButton(this.leftPos + Texture.PLAYER_VIEWER_BACKGROUND.width() + 1, this.topPos + Texture.PLAYER_VIEWER_BACKGROUND.height() / 5 + 18, (Component)Component.translatable((String)"screens.wynntils.playerViewer.trade"), Texture.TRADE_ICON, () -> Handlers.Command.queueCommand("trade " + playerName)));
        this.interactionButtons.add(new SimplePlayerInteractionButton(this.leftPos + Texture.PLAYER_VIEWER_BACKGROUND.width() + 1, this.topPos + Texture.PLAYER_VIEWER_BACKGROUND.height() / 5 + 38, (Component)Component.translatable((String)"screens.wynntils.playerViewer.message"), Texture.MESSAGE_ICON, () -> {
            this.onClose();
            McUtils.mc().setScreen((Screen)new ChatScreen("/msg " + playerName + " "));
        }));
        this.settingsButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.playerViewer.sharingSettings"), b -> McUtils.mc().setScreen((Screen)GearSharingSettingsScreen.create((Screen)this))).pos(this.leftPos + 1, this.topPos - 21).size(Texture.PLAYER_VIEWER_BACKGROUND.width() - 23, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.playerViewer.sharingSettingsTooltip"))).build();
        if (noGear) {
            this.infoButton = new InfoButton(this.leftPos + Texture.PLAYER_VIEWER_BACKGROUND.width() - 21, this.topPos - 21, (Component)Component.literal((String)"").append((Component)Component.translatable((String)"screens.wynntils.playerViewer.helpTitle").withStyle(ChatFormatting.UNDERLINE)).append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)"screens.wynntils.playerViewer.help").withStyle(ChatFormatting.GRAY)));
        }
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        this.renderPlayerModel(guiGraphics, mouseX, mouseY);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.interactionButtons.forEach(button -> button.render(guiGraphics, mouseX, mouseY, partialTick));
        this.settingsButton.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.infoButton == null) {
            return;
        }
        this.infoButton.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderPlayerModel(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int renderX = (this.width - Texture.PLAYER_VIEWER_BACKGROUND.width()) / 2 + 13;
        int renderY = (this.height - Texture.PLAYER_VIEWER_BACKGROUND.height()) / 2 - 4;
        int renderWidth = Texture.PLAYER_VIEWER_BACKGROUND.width();
        int renderHeight = Texture.PLAYER_VIEWER_BACKGROUND.height();
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)renderX, (int)renderY, (int)(renderX + renderWidth), (int)(renderY + renderHeight), (int)30, (float)0.2f, (float)mouseX, (float)mouseY, (LivingEntity)this.player);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        BufferedRenderUtils.drawTexturedRect(guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource, Texture.PLAYER_VIEWER_BACKGROUND, this.leftPos, this.topPos);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (PlayerInteractionButton interactionButton : this.interactionButtons) {
            if (!interactionButton.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return this.settingsButton.mouseClicked(mouseX, mouseY, button);
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == McUtils.options().keyInventory.key.getValue()) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        this.scoreboard.removePlayerFromTeam(this.player.getScoreboardName(), this.playerViewerTeam);
        if (this.oldTeam != null) {
            this.scoreboard.addPlayerToTeam(this.player.getScoreboardName(), this.oldTeam);
        }
        super.onClose();
    }

    public Player getPlayer() {
        return this.player;
    }

    public void updateButtonIcons() {
        this.friendButton.updateIcon();
        this.partyButton.updateIcon();
    }
}

