/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.playerviewer.widgets;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Models;
import com.wynntils.screens.playerviewer.widgets.PlayerInteractionButton;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.Texture;
import java.util.List;
import net.minecraft.network.chat.Component;

public class PartyButton
extends PlayerInteractionButton {
    private final String playerName;

    public PartyButton(int x, int y, String playerName) {
        super(x, y);
        this.playerName = playerName;
        this.updateIcon();
    }

    @Override
    public void onPress() {
        super.onPress();
        Handlers.Command.queueCommand("party " + (Models.Party.getPartyMembers().contains(this.playerName) ? "kick " : "") + this.playerName);
    }

    public void updateIcon() {
        this.active = !Models.Party.isInParty() || Models.Party.isPartyLeader(McUtils.playerName());
        boolean isPartyMember = Models.Party.getPartyMembers().contains(this.playerName);
        this.icon = isPartyMember ? Texture.PARTY_KICK_ICON : Texture.PARTY_INVITE_ICON;
        this.tooltipText = List.of(Component.translatable((String)("screens.wynntils.playerViewer." + (isPartyMember ? "kickParty" : "inviteParty"))));
    }
}

