/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.update;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.changelog.ChangelogScreen;
import com.wynntils.services.athena.type.UpdateResult;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.UniversalTexture;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;

public final class UpdateScreen
extends WynntilsScreen {
    private final Screen titleScreen;
    private final ServerData serverData;
    private Button updateButton;
    private Button updateNowButton;
    private Button ignoreNowButton;
    private Button ignoreUpdateButton;
    private Button changelogButton;
    private Button titleScreenButton;
    private UpdateResult updateResult;
    private CompletionTrigger completionTrigger = null;
    private long completionFinish = 0L;

    private UpdateScreen(ServerData serverData, Screen titleScreen) {
        super((Component)Component.literal((String)"Update Screen"));
        this.serverData = serverData;
        this.titleScreen = titleScreen;
    }

    public static Screen create(ServerData serverData, Screen titleScreen) {
        return new UpdateScreen(serverData, titleScreen);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.updateButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.update.update"), button -> this.downloadUpdate(false)).pos(this.width / 2 - 150, this.height / 2 + 40).size(140, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.update.updateTooltip"))).build();
        this.addRenderableWidget((GuiEventListener)this.updateButton);
        this.updateNowButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.update.updateExit"), button -> this.downloadUpdate(true)).pos(this.width / 2 + 10, this.height / 2 + 40).size(140, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.update.updateExitTooltip"))).build();
        this.addRenderableWidget((GuiEventListener)this.updateNowButton);
        this.ignoreNowButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.update.ignoreNow"), button -> this.ignoreUpdate(false)).pos(this.width / 2 - 150, this.height / 2 + 70).size(140, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.update.ignoreNowTooltip"))).build();
        this.addRenderableWidget((GuiEventListener)this.ignoreNowButton);
        this.ignoreUpdateButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.update.ignorePermenantly"), button -> this.ignoreUpdate(true)).pos(this.width / 2 + 10, this.height / 2 + 70).size(140, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.update.ignorePermenantlyTooltip", (Object[])new Object[]{Services.Update.getModUpdateInfo().version()}))).build();
        this.addRenderableWidget((GuiEventListener)this.ignoreUpdateButton);
        this.changelogButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.update.changelog"), button -> this.showChangelog()).pos(this.width / 2 - 150, this.height / 2 + 100).size(140, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.update.changelogTooltip", (Object[])new Object[]{WynntilsMod.getVersion(), Services.Update.getModUpdateInfo().version()}))).build();
        this.addRenderableWidget((GuiEventListener)this.changelogButton);
        this.titleScreenButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.update.titleScreen"), button -> this.onClose()).pos(this.width / 2 + 10, this.height / 2 + 100).size(140, 20).build();
        this.addRenderableWidget((GuiEventListener)this.titleScreenButton);
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        PoseStack poseStack = guiGraphics.pose();
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.update.title", (Object[])new Object[]{Services.Update.getModUpdateInfo().version()}).withStyle(ChatFormatting.UNDERLINE)), (float)this.width / 2.0f, 30.0f, CommonColors.DARK_AQUA, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 3.0f);
        if (Services.Update.getUpdateProgress() != -1.0f) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.update.downloading")), (float)this.width / 2.0f, 60.0f, CommonColors.AQUA, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.5f);
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString((int)(Services.Update.getUpdateProgress() * 100.0f) + "%"), (float)this.width / 2.0f, (float)this.height / 2.0f - (float)Texture.UNIVERSAL_BAR.height(), CommonColors.LIGHT_GREEN, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
            BufferedRenderUtils.drawColoredProgressBar(poseStack, (MultiBufferSource)guiGraphics.bufferSource, Texture.UNIVERSAL_BAR, CommonColors.LIGHT_GREEN, (float)this.width / 2.0f - (float)Texture.UNIVERSAL_BAR.width(), (float)this.height / 2.0f - (float)UniversalTexture.A.getHeight(), (float)this.width / 2.0f + (float)Texture.UNIVERSAL_BAR.width(), (float)this.height / 2.0f + (float)UniversalTexture.A.getHeight(), 0, UniversalTexture.A.getTextureY1(), Texture.UNIVERSAL_BAR.width(), UniversalTexture.A.getTextureY2(), Services.Update.getUpdateProgress());
            return;
        }
        if (this.updateResult != null) {
            if (this.updateResult == UpdateResult.SUCCESSFUL) {
                FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.update.downloaded")), (float)this.width / 2.0f, 60.0f, CommonColors.GREEN, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.5f);
                if (this.completionTrigger == CompletionTrigger.CONNECT) {
                    FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.update.connecting", (Object[])new Object[]{(int)Math.ceil((float)(this.completionFinish - System.currentTimeMillis()) / 1000.0f)})), (float)this.width / 2.0f, 100.0f, CommonColors.AQUA, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.5f);
                } else {
                    FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.update.exiting", (Object[])new Object[]{(int)Math.ceil((float)(this.completionFinish - System.currentTimeMillis()) / 1000.0f)})), (float)this.width / 2.0f, 100.0f, CommonColors.AQUA, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.5f);
                }
            } else {
                FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)this.updateResult.getMessage()), (float)this.width / 2.0f, 60.0f, CommonColors.RED, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.5f);
            }
            return;
        }
        if (this.completionTrigger != null) {
            return;
        }
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.update.description")), (float)this.width / 2.0f - 200.0f, (float)this.width / 2.0f + 200.0f, 60.0f, 120.0f, 400.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.5f);
    }

    private void downloadUpdate(boolean exit) {
        this.completionTrigger = exit ? CompletionTrigger.EXIT : CompletionTrigger.CONNECT;
        Services.Update.setHasPromptedUpdate(true);
        this.toggleButtons(false);
        Services.Update.tryUpdate().thenAccept(result -> {
            if (result == UpdateResult.SUCCESSFUL) {
                this.completionFinish = System.currentTimeMillis() + 3000L;
                Executors.newSingleThreadScheduledExecutor().schedule(() -> McUtils.mc().execute(() -> {
                    if (exit) {
                        System.exit(0);
                    } else {
                        this.connectToServer();
                    }
                }), 3000L, TimeUnit.MILLISECONDS);
            } else {
                this.toggleButtons(true);
            }
            this.updateResult = result;
        });
    }

    private void ignoreUpdate(boolean ignorePermenantly) {
        if (ignorePermenantly) {
            Services.Update.ignoredUpdate.store(Services.Update.getModUpdateInfo().version());
        }
        Services.Update.setHasPromptedUpdate(true);
        this.connectToServer();
    }

    private void showChangelog() {
        Services.Update.getChangelog(WynntilsMod.getVersion(), Services.Update.getModUpdateInfo().version(), false).thenAccept(changelog -> {
            if (changelog == null || changelog.isEmpty()) {
                this.changelogButton.setMessage((Component)Component.translatable((String)"screens.wynntils.update.changelog").withStyle(ChatFormatting.RED));
                this.changelogButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.update.changelogFailed")));
                return;
            }
            Managers.TickScheduler.scheduleNextTick(() -> McUtils.mc().setScreen(ChangelogScreen.create(changelog, this)));
        });
    }

    private void connectToServer() {
        ConnectScreen.startConnecting((Screen)this.titleScreen, (Minecraft)McUtils.mc(), (ServerAddress)ServerAddress.parseString((String)this.serverData.ip), (ServerData)this.serverData, (boolean)false, null);
    }

    private void toggleButtons(boolean active) {
        this.updateButton.active = active;
        this.updateNowButton.active = active;
        this.ignoreNowButton.active = active;
        this.ignoreUpdateButton.active = active;
        this.changelogButton.active = active;
        this.titleScreenButton.active = active;
    }

    private static enum CompletionTrigger {
        CONNECT,
        EXIT;

    }
}

