/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.chat;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Service;
import com.wynntils.core.components.Services;
import com.wynntils.core.persisted.config.HiddenConfig;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.chat.ChatTabsFeature;
import com.wynntils.handlers.chat.type.MessageType;
import com.wynntils.handlers.chat.type.RecipientType;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.services.chat.WrappingChatComponent;
import com.wynntils.services.chat.type.ChatTab;
import com.wynntils.services.chat.type.ChatTabData;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.bus.api.SubscribeEvent;

public final class ChatTabService
extends Service {
    private final Map<ChatTab, ChatTabData> tabDataMap = new HashMap<ChatTab, ChatTabData>();
    private final List<ChatTab> chatTabs = new ArrayList<ChatTab>();
    private ChatComponent vanillaChatComponent = null;
    private ChatTab focusedTab = null;

    public ChatTabService() {
        super(List.of());
    }

    public List<ChatTab> getChatTabs() {
        return this.chatTabs;
    }

    public ChatTab getTab(int index) {
        return this.getChatTabs().get(index);
    }

    public int getTabCount() {
        return this.getChatTabs().size();
    }

    public int getTabIndex(ChatTab edited) {
        return this.getChatTabs().indexOf(edited);
    }

    public int getTabIndexAfterFocused() {
        return (this.getTabIndex(this.getFocusedTab()) + 1) % this.getTabCount();
    }

    public int getTabIndexBeforeFocused() {
        int tabIndex = this.getTabIndex(this.getFocusedTab());
        return (tabIndex - 1 + this.getTabCount()) % this.getTabCount();
    }

    public void addTab(int insertIndex, ChatTab chatTab) {
        this.getChatTabs().add(insertIndex, chatTab);
        HiddenConfig<List<ChatTab>> configChatTabs = Managers.Feature.getFeatureInstance(ChatTabsFeature.class).chatTabs;
        ((List)configChatTabs.get()).add(insertIndex, chatTab);
        configChatTabs.touched();
        this.tabDataMap.put(chatTab, new ChatTabData(new ChatComponent(McUtils.mc()), false, chatTab.customRegexString()));
    }

    public void removeTab(ChatTab chatTab) {
        this.getChatTabs().remove(chatTab);
        HiddenConfig<List<ChatTab>> configChatTabs = Managers.Feature.getFeatureInstance(ChatTabsFeature.class).chatTabs;
        ((List)configChatTabs.get()).remove(chatTab);
        configChatTabs.touched();
        this.tabDataMap.remove(chatTab);
    }

    public ChatComponent getChatComponent(ChatTab tab) {
        return this.tabDataMap.get(tab).getChatComponent();
    }

    public boolean hasUnreadMessages(ChatTab tab) {
        return this.tabDataMap.get(tab).hasUnreadMessages();
    }

    public ChatTab getFocusedTab() {
        return this.focusedTab;
    }

    public void setFocusedTab(int index) {
        this.setFocusedTab(this.getTab(index));
    }

    public void setFocusedTab(ChatTab focused) {
        this.focusedTab = focused;
        ChatTabData focusedChatTabData = this.tabDataMap.get(focused);
        focusedChatTabData.setUnreadMessages(false);
        McUtils.mc().gui.chat.allMessages = focusedChatTabData.getChatComponent().allMessages;
        McUtils.mc().gui.chat.trimmedMessages = focusedChatTabData.getChatComponent().trimmedMessages;
        McUtils.mc().gui.chat.refreshTrimmedMessages();
    }

    public void enable() {
        if (this.isEnabled()) {
            return;
        }
        if (this.getTabCount() == 0) {
            WynntilsMod.warn("Cannot enable Chat Tabs: no tabs configured");
            return;
        }
        this.reset();
        this.getChatTabs().forEach(chatTab -> this.tabDataMap.put((ChatTab)chatTab, new ChatTabData(new ChatComponent(McUtils.mc()), false, chatTab.customRegexString())));
        McUtils.mc().gui.chat.allMessages.reversed().forEach(msg -> {
            Component component = msg.content();
            StyledText styledText = StyledText.fromComponent(component);
            RecipientType recipientType = Handlers.Chat.getRecipientType(styledText, MessageType.FOREGROUND);
            List<ChatTab> recipientTabs = Services.ChatTab.getRecipientTabs(recipientType, styledText);
            recipientTabs.forEach(tab -> Services.ChatTab.getChatComponent((ChatTab)tab).addMessage(component));
        });
        this.vanillaChatComponent = McUtils.mc().gui.chat;
        McUtils.mc().gui.chat = new WrappingChatComponent(McUtils.mc());
        this.setFocusedTab(this.getChatTabs().getFirst());
    }

    public void disable() {
        if (!this.isEnabled()) {
            return;
        }
        McUtils.mc().gui.chat = this.vanillaChatComponent;
        this.vanillaChatComponent = null;
        this.reset();
        this.focusedTab = null;
    }

    public boolean isEnabled() {
        return this.focusedTab != null;
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (event.getNewState() == WorldState.NOT_CONNECTED) {
            this.reset();
        }
    }

    void clearMessages(boolean clearSentMsgHistory) {
        this.vanillaChatComponent.clearMessages(clearSentMsgHistory);
        this.tabDataMap.values().forEach(chatTabData -> chatTabData.getChatComponent().clearMessages(clearSentMsgHistory));
    }

    void addMessage(Component component, MessageSignature headerSignature, GuiMessageTag tag) {
        try {
            this.vanillaChatComponent.addMessage(component, headerSignature, tag);
            StyledText styledText = StyledText.fromComponent(component);
            RecipientType recipientType = Handlers.Chat.getRecipientType(styledText, MessageType.FOREGROUND);
            List<ChatTab> recipientTabs = this.getRecipientTabs(recipientType, styledText);
            recipientTabs.forEach(tab -> {
                this.getChatComponent((ChatTab)tab).addMessage(component);
                this.markAsNewMessages((ChatTab)tab);
            });
        }
        catch (Throwable t) {
            this.warnAboutBrokenMod(component, t);
        }
    }

    private void warnAboutBrokenMod(Component component, Throwable t) {
        MutableComponent warning = Component.literal((String)"<< WARNING: A chat message was lost due to a crash in a mod other than Wynntils. See log for details. >>").withStyle(ChatFormatting.RED);
        this.vanillaChatComponent.addMessage((Component)warning);
        this.getChatComponent(this.focusedTab).addMessage((Component)warning);
        WynntilsMod.warn("Another mod has caused an exception in ChatComponent.addMessage()");
        WynntilsMod.warn("The message that could not be displayed is:" + StyledText.fromComponent(component).getString());
        WynntilsMod.warn("This is not a Wynntils bug. Here is the exception that we caught.", t);
    }

    private void reset() {
        this.tabDataMap.clear();
    }

    private void markAsNewMessages(ChatTab tab) {
        if (tab != this.focusedTab) {
            this.tabDataMap.get(tab).setUnreadMessages(true);
        }
    }

    private List<ChatTab> getRecipientTabs(RecipientType recipientType, StyledText styledText) {
        ArrayList<ChatTab> recipientTabs = new ArrayList<ChatTab>();
        for (ChatTab chatTab : this.getChatTabs()) {
            if (!chatTab.consuming() || !this.matchMessage(chatTab, recipientType, styledText)) continue;
            recipientTabs.add(chatTab);
            return recipientTabs;
        }
        for (ChatTab chatTab : this.getChatTabs()) {
            if (chatTab.consuming() || !this.matchMessage(chatTab, recipientType, styledText)) continue;
            recipientTabs.add(chatTab);
        }
        return recipientTabs;
    }

    private boolean matchMessage(ChatTab chatTab, RecipientType recipientType, StyledText originalStyledText) {
        if (chatTab.filteredTypes() != null && !chatTab.filteredTypes().isEmpty() && !chatTab.filteredTypes().contains((Object)recipientType)) {
            return false;
        }
        Optional<Pattern> regex = this.tabDataMap.get(chatTab).getCustomRegex();
        if (regex.isEmpty()) {
            return true;
        }
        return originalStyledText.matches(regex.get());
    }

    public void modifyChatHistory(Consumer<List<GuiMessage>> allMessagesConsumer) {
        if (!this.isEnabled()) {
            ChatComponent chatComponent2 = McUtils.mc().gui.chat;
            allMessagesConsumer.accept(chatComponent2.allMessages);
            chatComponent2.refreshTrimmedMessages();
            return;
        }
        Stream.concat(Stream.of(this.vanillaChatComponent), this.tabDataMap.values().stream().map(ChatTabData::getChatComponent)).forEach(chatComponent -> {
            allMessagesConsumer.accept(chatComponent.allMessages);
            chatComponent.refreshTrimmedMessages();
        });
    }

    public void sendChat(String message) {
        if (message.isBlank()) {
            return;
        }
        if (!this.isEnabled()) {
            McUtils.sendChat(message);
            return;
        }
        String autoCommand = this.getFocusedTab().autoCommand();
        if (autoCommand != null && !autoCommand.isBlank()) {
            autoCommand = autoCommand.startsWith("/") ? autoCommand.substring(1) : autoCommand;
            Handlers.Command.sendCommandImmediately(autoCommand + " " + message);
        } else {
            McUtils.sendChat(message);
        }
    }

    public void setChatTabs(List<ChatTab> chatTabs) {
        this.chatTabs.clear();
        this.chatTabs.addAll(chatTabs);
        HashMap<ChatTab, ChatTabData> oldMap = new HashMap<ChatTab, ChatTabData>(this.tabDataMap);
        this.tabDataMap.clear();
        chatTabs.forEach(chatTab -> this.tabDataMap.put((ChatTab)chatTab, oldMap.containsKey(chatTab) ? (ChatTabData)oldMap.get(chatTab) : new ChatTabData(new ChatComponent(McUtils.mc()), false, chatTab.customRegexString())));
        if (this.focusedTab != null) {
            this.setFocusedTab(chatTabs.getFirst());
        }
    }
}

