/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.itemfilter;

import com.wynntils.core.components.Models;
import com.wynntils.core.components.Service;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.elements.type.Skill;
import com.wynntils.models.ingredients.type.IngredientPosition;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.profession.type.ProfessionType;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.models.territories.type.GuildResource;
import com.wynntils.models.territories.type.TerritoryUpgrade;
import com.wynntils.services.itemfilter.filters.AnyStatFilters;
import com.wynntils.services.itemfilter.filters.BooleanStatFilter;
import com.wynntils.services.itemfilter.filters.PercentageStatFilter;
import com.wynntils.services.itemfilter.filters.RangedStatFilters;
import com.wynntils.services.itemfilter.filters.StringStatFilter;
import com.wynntils.services.itemfilter.statproviders.ActualStatProvider;
import com.wynntils.services.itemfilter.statproviders.ChargesModifierStatProvider;
import com.wynntils.services.itemfilter.statproviders.ClassStatProvider;
import com.wynntils.services.itemfilter.statproviders.CountedItemStatProvider;
import com.wynntils.services.itemfilter.statproviders.DurabilityModifierStatProvider;
import com.wynntils.services.itemfilter.statproviders.DurabilityStatProvider;
import com.wynntils.services.itemfilter.statproviders.DurationModifierStatProvider;
import com.wynntils.services.itemfilter.statproviders.DurationStatProvider;
import com.wynntils.services.itemfilter.statproviders.EmeraldValueStatProvider;
import com.wynntils.services.itemfilter.statproviders.FavoriteStatProvider;
import com.wynntils.services.itemfilter.statproviders.GearRestrictionStatProvider;
import com.wynntils.services.itemfilter.statproviders.GearTypeStatProvider;
import com.wynntils.services.itemfilter.statproviders.HealthStatProvider;
import com.wynntils.services.itemfilter.statproviders.IngredientEffectivenessStatProvider;
import com.wynntils.services.itemfilter.statproviders.ItemTypeStatProvider;
import com.wynntils.services.itemfilter.statproviders.LevelStatProvider;
import com.wynntils.services.itemfilter.statproviders.MajorIdStatProvider;
import com.wynntils.services.itemfilter.statproviders.OverallStatProvider;
import com.wynntils.services.itemfilter.statproviders.PowderSlotsStatProvider;
import com.wynntils.services.itemfilter.statproviders.PriceStatProvider;
import com.wynntils.services.itemfilter.statproviders.ProfessionStatProvider;
import com.wynntils.services.itemfilter.statproviders.QualityTierStatProvider;
import com.wynntils.services.itemfilter.statproviders.RarityStatProvider;
import com.wynntils.services.itemfilter.statproviders.SkillReqStatProvider;
import com.wynntils.services.itemfilter.statproviders.SkillStatProvider;
import com.wynntils.services.itemfilter.statproviders.TargetStatProvider;
import com.wynntils.services.itemfilter.statproviders.TierStatProvider;
import com.wynntils.services.itemfilter.statproviders.TomeTypeStatProvider;
import com.wynntils.services.itemfilter.statproviders.TotalPriceStatProvider;
import com.wynntils.services.itemfilter.statproviders.TradeAmountStatProvider;
import com.wynntils.services.itemfilter.statproviders.UsesStatProvider;
import com.wynntils.services.itemfilter.statproviders.territory.TerritoryAlertStatProvider;
import com.wynntils.services.itemfilter.statproviders.territory.TerritoryDefenseStatProvider;
import com.wynntils.services.itemfilter.statproviders.territory.TerritoryNameStatProvider;
import com.wynntils.services.itemfilter.statproviders.territory.TerritoryOverallProductionStatProvider;
import com.wynntils.services.itemfilter.statproviders.territory.TerritoryProductionStatProvider;
import com.wynntils.services.itemfilter.statproviders.territory.TerritoryStorageStatProvider;
import com.wynntils.services.itemfilter.statproviders.territory.TerritoryTreasuryStatProvider;
import com.wynntils.services.itemfilter.statproviders.territory.TerritoryUpgradeCountStatProvider;
import com.wynntils.services.itemfilter.statproviders.territory.TerritoryUpgradeLevelStatProvider;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import com.wynntils.services.itemfilter.type.SortDirection;
import com.wynntils.services.itemfilter.type.SortInfo;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatFilterFactory;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.services.itemfilter.type.StatProviderFilterMap;
import com.wynntils.services.itemfilter.type.StatValue;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.Pair;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.item.ItemStack;

public class ItemFilterService
extends Service {
    private static final String SORT_KEY = "sort";
    private static final String SORT_REVERSE_KEY = "^";
    private static final String LIST_SEPARATOR = ",";
    @Persisted
    public final Storage<List<Pair<String, String>>> presets = new Storage(new ArrayList());
    private final List<ItemStatProvider<?>> itemStatProviders = new ArrayList();
    private final List<Pair<Class<?>, StatFilterFactory<? extends StatFilter<?>>>> statFilters = new ArrayList();

    public ItemFilterService() {
        super(List.of());
        this.registerStatProviders();
        this.registerStatFilters();
    }

    public List<ItemStatProvider<?>> getItemStatProviders() {
        return this.itemStatProviders;
    }

    public List<? extends StatFilterFactory<? extends StatFilter<?>>> getStatFilters() {
        return this.statFilters.stream().map(Pair::value).toList();
    }

    public ItemSearchQuery createSearchQuery(String queryString, boolean supportsSorting, List<ItemProviderType> supportedProviderTypes) {
        StatProviderFilterMap filters = new StatProviderFilterMap();
        ArrayList<SortInfo> sorts = new ArrayList<SortInfo>();
        ArrayList<Pair<ChatFormatting, Pair<Integer, Integer>>> colorRanges = new ArrayList<Pair<ChatFormatting, Pair<Integer, Integer>>>();
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> plainTextTokens = new ArrayList<String>();
        String[] tokens = queryString.split(" ");
        int tokenStartIndex = -1;
        String lastToken = "";
        for (String token : tokens) {
            tokenStartIndex += lastToken.length() + 1;
            lastToken = token;
            if (token.contains(":")) {
                String keyString = token.substring(0, token.indexOf(58));
                String inputString = token.substring(token.indexOf(58) + 1);
                if (keyString.equalsIgnoreCase(SORT_KEY)) {
                    if (!supportsSorting) {
                        colorRanges.add(Pair.of(ChatFormatting.RED, Pair.of(tokenStartIndex, tokenStartIndex + token.length())));
                        errors.add(I18n.get((String)"service.wynntils.itemFilter.sortingNotSupported", (Object[])new Object[0]));
                        continue;
                    }
                    ErrorOr<List<SortInfo>> statSortListOrError = this.getStatSortOrder(inputString, supportedProviderTypes);
                    if (statSortListOrError.hasError()) {
                        colorRanges.add(Pair.of(ChatFormatting.RED, Pair.of(tokenStartIndex, tokenStartIndex + token.length())));
                        errors.add(statSortListOrError.getError());
                        continue;
                    }
                    colorRanges.add(Pair.of(ChatFormatting.LIGHT_PURPLE, Pair.of(tokenStartIndex, tokenStartIndex + keyString.length())));
                    char[] inputStringCharArray = inputString.toCharArray();
                    for (int i = 0; i < inputStringCharArray.length; ++i) {
                        char c = inputStringCharArray[i];
                        String stringValue = String.valueOf(c);
                        if (stringValue.equals(SORT_REVERSE_KEY)) {
                            colorRanges.add(Pair.of(ChatFormatting.GOLD, Pair.of(tokenStartIndex + keyString.length() + i + 1, tokenStartIndex + keyString.length() + i + 2)));
                            continue;
                        }
                        if (!stringValue.equals(LIST_SEPARATOR)) continue;
                        colorRanges.add(Pair.of(ChatFormatting.GOLD, Pair.of(tokenStartIndex + keyString.length() + i + 1, tokenStartIndex + keyString.length() + i + 2)));
                    }
                    colorRanges.add(Pair.of(ChatFormatting.YELLOW, Pair.of(tokenStartIndex + keyString.length() + 1, tokenStartIndex + token.length())));
                    sorts.addAll((Collection<SortInfo>)statSortListOrError.getValue());
                    continue;
                }
                ErrorOr<ItemStatProvider<?>> itemStatProviderOrError = this.getItemStatProvider(keyString, supportedProviderTypes);
                if (itemStatProviderOrError.hasError()) {
                    colorRanges.add(Pair.of(ChatFormatting.RED, Pair.of(tokenStartIndex, tokenStartIndex + token.length())));
                    errors.add(itemStatProviderOrError.getError());
                    continue;
                }
                colorRanges.add(Pair.of(ChatFormatting.YELLOW, Pair.of(tokenStartIndex, tokenStartIndex + keyString.length())));
                if (inputString.isEmpty()) continue;
                ItemStatProvider<?> itemStatProvider = itemStatProviderOrError.getValue();
                String[] filterStrings = inputString.split(LIST_SEPARATOR);
                int processedFilterLength = 0;
                for (String filterString : filterStrings) {
                    ErrorOr<StatFilter<?>> statFilter = this.getStatFilter(itemStatProvider.getType(), filterString);
                    colorRanges.add(Pair.of(ChatFormatting.GOLD, Pair.of(tokenStartIndex + keyString.length() + processedFilterLength, tokenStartIndex + keyString.length() + processedFilterLength + 1)));
                    if (statFilter.hasError()) {
                        colorRanges.add(Pair.of(ChatFormatting.RED, Pair.of(tokenStartIndex + keyString.length() + processedFilterLength + 1, tokenStartIndex + keyString.length() + processedFilterLength + filterString.length() + 1)));
                        errors.add(statFilter.getError());
                        processedFilterLength += filterString.length() + 1;
                        continue;
                    }
                    colorRanges.add(Pair.of(ChatFormatting.GOLD, Pair.of(tokenStartIndex + keyString.length() + processedFilterLength + 1, tokenStartIndex + keyString.length() + processedFilterLength + filterString.length() + 1)));
                    filters.put(itemStatProvider, statFilter.getValue());
                    processedFilterLength += filterString.length() + 1;
                }
                continue;
            }
            if (token.isEmpty()) continue;
            plainTextTokens.add(token);
        }
        return new ItemSearchQuery(queryString, filters, sorts, colorRanges, errors, plainTextTokens);
    }

    public boolean matches(ItemSearchQuery searchQuery, ItemStack itemStack) {
        if (searchQuery.isEmpty()) {
            return true;
        }
        if (itemStack.isEmpty()) {
            return false;
        }
        Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem(itemStack);
        if (wynnItemOpt.isEmpty()) {
            return false;
        }
        return this.filterMatches(searchQuery, wynnItemOpt.get()) && this.itemNameMatches(searchQuery, StyledText.fromComponent(itemStack.getHoverName()).getStringWithoutFormatting());
    }

    public <T extends ItemStack> List<T> filterAndSort(ItemSearchQuery searchQuery, List<T> originalList) {
        Stream<ItemStack> filteredList = originalList.stream().filter(itemStack -> this.matches(searchQuery, (ItemStack)itemStack));
        filteredList = filteredList.filter(itemStack -> {
            Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem((ItemStack)itemStack);
            if (wynnItemOpt.isEmpty()) {
                return false;
            }
            WynnItem wynnItem = wynnItemOpt.get();
            for (SortInfo sortInfo : searchQuery.sorts()) {
                ItemStatProvider<?> statProvider = sortInfo.provider();
                if (!statProvider.getValue(wynnItem).isEmpty()) continue;
                return false;
            }
            return true;
        });
        filteredList = filteredList.sorted((itemStack1, itemStack2) -> {
            Optional<WynnItem> wynnItem1Opt = Models.Item.getWynnItem((ItemStack)itemStack1);
            Optional<WynnItem> wynnItem2Opt = Models.Item.getWynnItem((ItemStack)itemStack2);
            if (wynnItem1Opt.isEmpty() || wynnItem2Opt.isEmpty()) {
                return 0;
            }
            WynnItem wynnItem1 = wynnItem1Opt.get();
            WynnItem wynnItem2 = wynnItem2Opt.get();
            for (SortInfo sortInfo : searchQuery.sorts()) {
                int compare = sortInfo.provider().compare(wynnItem1, wynnItem2);
                if (compare == 0) continue;
                return switch (sortInfo.direction()) {
                    default -> throw new MatchException(null, null);
                    case SortDirection.ASCENDING -> -compare;
                    case SortDirection.DESCENDING -> compare;
                };
            }
            return 0;
        });
        return filteredList.toList();
    }

    public String getItemFilterString(Map<ItemStatProvider<?>, List<StatProviderAndFilterPair>> filterMap, List<SortInfo> sortInfos, List<String> plainTextTokens) {
        ArrayList<CallSite> filterStrings = new ArrayList<CallSite>();
        for (Map.Entry<ItemStatProvider<?>, List<StatProviderAndFilterPair>> entry : filterMap.entrySet()) {
            ItemStatProvider<?> itemStatProvider = entry.getKey();
            List<StatFilter> filters = entry.getValue().stream().map(StatProviderAndFilterPair::statFilter).toList();
            String filterString = itemStatProvider.getName() + ":" + String.join((CharSequence)LIST_SEPARATOR, filters.stream().map(StatFilter::asString).toList());
            filterStrings.add((CallSite)((Object)filterString));
        }
        String filterString = String.join((CharSequence)" ", filterStrings);
        List<String> sortInfoStrings = sortInfos.stream().map(sortInfo -> {
            String directionString = sortInfo.direction() == SortDirection.DESCENDING ? "" : SORT_REVERSE_KEY;
            return directionString + sortInfo.provider().getName();
        }).toList();
        String sortInfoString = sortInfos.isEmpty() ? "" : "sort:" + String.join((CharSequence)LIST_SEPARATOR, sortInfoStrings);
        String plainTextString = String.join((CharSequence)" ", plainTextTokens);
        return (plainTextString + " " + filterString + " " + sortInfoString).trim().replace("  ", " ");
    }

    private ErrorOr<ItemStatProvider<?>> getItemStatProvider(String name, List<ItemProviderType> supportedProviderTypes) {
        Optional<ItemStatProvider> itemStatProviderOpt = this.itemStatProviders.stream().filter(provider -> provider.getFilterTypes().stream().anyMatch(supportedProviderTypes::contains)).filter(filter -> filter.getName().equalsIgnoreCase(name) || filter.getAliases().stream().anyMatch(alias -> alias.equalsIgnoreCase(name))).findFirst();
        if (itemStatProviderOpt.isPresent()) {
            return ErrorOr.of(itemStatProviderOpt.get());
        }
        return ErrorOr.error(I18n.get((String)"service.wynntils.itemFilter.unknownStat", (Object[])new Object[]{name}));
    }

    public <T> ErrorOr<StatFilter<?>> getStatFilter(Class<T> type, String value) {
        Optional<StatFilter> statFilterFactoryOpt = this.statFilters.stream().filter(filter -> ((Class)filter.key()).equals(type)).map(filter -> ((StatFilterFactory)filter.value()).create(value)).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (statFilterFactoryOpt.isPresent()) {
            return ErrorOr.of(statFilterFactoryOpt.get());
        }
        return ErrorOr.error(I18n.get((String)"service.wynntils.itemFilter.invalidFilter", (Object[])new Object[]{value, type.getSimpleName()}));
    }

    private boolean filterMatches(ItemSearchQuery searchQuery, WynnItem wynnItem) {
        return searchQuery.filters().matches(wynnItem);
    }

    private boolean itemNameMatches(ItemSearchQuery searchQuery, String itemName) {
        return searchQuery.plainTextTokens().isEmpty() || itemName.toLowerCase(Locale.ROOT).contains(String.join((CharSequence)" ", searchQuery.plainTextTokens()).toLowerCase(Locale.ROOT));
    }

    private ErrorOr<List<SortInfo>> getStatSortOrder(String inputString, List<ItemProviderType> supportedProviderTypes) {
        List<Pair> providerNamesWithDirection = Arrays.stream(inputString.split(LIST_SEPARATOR)).map(String::trim).filter(s -> !s.isBlank()).map(s -> {
            if (s.startsWith(SORT_REVERSE_KEY)) {
                return Pair.of(SortDirection.ASCENDING, s.substring(1));
            }
            return Pair.of(SortDirection.DESCENDING, s);
        }).toList();
        List<Pair> errorsOrProviders = providerNamesWithDirection.stream().map(pair -> Pair.of((SortDirection)((Object)((Object)pair.key())), this.getItemStatProvider((String)pair.value(), supportedProviderTypes))).toList();
        Optional<Pair> firstError = errorsOrProviders.stream().filter(pair -> ((ErrorOr)pair.value()).hasError()).findFirst();
        if (firstError.isPresent()) {
            return ErrorOr.error(((ErrorOr)firstError.get().value()).getError());
        }
        ArrayList<SortInfo> sorts = new ArrayList<SortInfo>();
        for (Pair pair2 : errorsOrProviders) {
            sorts.add(new SortInfo((SortDirection)((Object)pair2.key()), (ItemStatProvider)((ErrorOr)pair2.value()).getValue()));
        }
        return ErrorOr.of(sorts);
    }

    private void registerStatProviders() {
        this.registerStatProvider(new PriceStatProvider());
        this.registerStatProvider(new TotalPriceStatProvider());
        this.registerStatProvider(new TradeAmountStatProvider());
        this.registerStatProvider(new EmeraldValueStatProvider());
        this.registerStatProvider(new LevelStatProvider());
        this.registerStatProvider(new RarityStatProvider());
        this.registerStatProvider(new ItemTypeStatProvider());
        this.registerStatProvider(new GearTypeStatProvider());
        this.registerStatProvider(new CountedItemStatProvider());
        this.registerStatProvider(new DurabilityStatProvider());
        this.registerStatProvider(new TierStatProvider());
        this.registerStatProvider(new UsesStatProvider());
        this.registerStatProvider(new ClassStatProvider());
        this.registerStatProvider(new GearRestrictionStatProvider());
        this.registerStatProvider(new MajorIdStatProvider());
        this.registerStatProvider(new PowderSlotsStatProvider());
        this.registerStatProvider(new HealthStatProvider());
        this.registerStatProvider(new TargetStatProvider());
        this.registerStatProvider(new TomeTypeStatProvider());
        for (ProfessionType professionType : ProfessionType.values()) {
            this.registerStatProvider(new ProfessionStatProvider(professionType));
        }
        this.registerStatProvider(new QualityTierStatProvider());
        this.registerStatProvider(new DurationStatProvider());
        for (Enum enum_ : IngredientPosition.values()) {
            this.registerStatProvider(new IngredientEffectivenessStatProvider((IngredientPosition)enum_));
        }
        this.registerStatProvider(new ChargesModifierStatProvider());
        this.registerStatProvider(new DurabilityModifierStatProvider());
        this.registerStatProvider(new DurationModifierStatProvider());
        this.registerStatProvider(new OverallStatProvider());
        for (Skill skill : Models.Element.getGearSkillOrder()) {
            this.registerStatProvider(new SkillStatProvider(skill));
            this.registerStatProvider(new SkillReqStatProvider(skill));
        }
        for (StatType statType : Models.Stat.getAllStatTypes()) {
            this.registerStatProvider(new ActualStatProvider(statType));
        }
        this.registerStatProvider(new FavoriteStatProvider());
        this.registerStatProvider(new TerritoryNameStatProvider());
        this.registerStatProvider(new TerritoryOverallProductionStatProvider());
        for (GuildResource guildResource : GuildResource.values()) {
            this.registerStatProvider(new TerritoryProductionStatProvider(guildResource));
            this.registerStatProvider(new TerritoryStorageStatProvider(guildResource));
        }
        for (TerritoryUpgrade territoryUpgrade : TerritoryUpgrade.values()) {
            this.registerStatProvider(new TerritoryUpgradeLevelStatProvider(territoryUpgrade));
        }
        this.registerStatProvider(new TerritoryDefenseStatProvider());
        this.registerStatProvider(new TerritoryUpgradeCountStatProvider());
        this.registerStatProvider(new TerritoryTreasuryStatProvider());
        this.registerStatProvider(new TerritoryAlertStatProvider());
    }

    private void registerStatProvider(ItemStatProvider<?> statProvider) {
        this.itemStatProviders.add(statProvider);
    }

    private void registerStatFilters() {
        this.registerStatFilter(Integer.class, new AnyStatFilters.AnyIntegerStatFilter.AnyIntegerStatFilterFactory());
        this.registerStatFilter(String.class, new AnyStatFilters.AnyStringStatFilter.AnyStringStatFilterFactory());
        this.registerStatFilter(CappedValue.class, new AnyStatFilters.AnyCappedValueStatFilter.AnyCappedValueStatFilterFactory());
        this.registerStatFilter(StatValue.class, new AnyStatFilters.AnyStatValueStatFilter.AnyStatValueStatFilterFactory());
        this.registerStatFilter(Integer.class, new RangedStatFilters.RangedIntegerStatFilter.RangedIntegerStatFilterFactory());
        this.registerStatFilter(CappedValue.class, new RangedStatFilters.RangedCappedValueStatFilter.RangedCappedValueStatFilterFactory());
        this.registerStatFilter(StatValue.class, new RangedStatFilters.RangedStatValueStatFilter.RangedStatValueStatFilterFactory());
        this.registerStatFilter(StatValue.class, new PercentageStatFilter.PercentageStatFilterFactory());
        this.registerStatFilter(Boolean.class, new BooleanStatFilter.BooleanStatFilterFactory());
        this.registerStatFilter(String.class, new StringStatFilter.StringStatFilterFactory());
    }

    private <T> void registerStatFilter(Class<T> clazz, StatFilterFactory<? extends StatFilter<T>> statFilterFactory) {
        this.statFilters.add(Pair.of(clazz, statFilterFactory));
    }
}

