/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.itemfilter.statproviders;

import com.wynntils.core.components.Models;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.trademarket.type.TradeMarketPriceInfo;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;

public class PriceStatProvider
extends ItemStatProvider<Integer> {
    @Override
    public Optional<Integer> getValue(WynnItem wynnItem) {
        TradeMarketPriceInfo priceInfo = wynnItem.getData().getOrCalculate("price", () -> {
            TradeMarketPriceInfo calculatedInfo = Models.TradeMarket.calculateItemPriceInfo((ItemStack)wynnItem.getData().get("itemstack"));
            return calculatedInfo;
        });
        if (priceInfo == TradeMarketPriceInfo.EMPTY) {
            return Optional.empty();
        }
        return Optional.of(priceInfo.silverbullPrice());
    }

    @Override
    public List<ItemProviderType> getFilterTypes() {
        return List.of(ItemProviderType.VALUED);
    }
}

