/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.itemfilter.statproviders.territory;

import com.wynntils.models.items.items.gui.TerritoryItem;
import com.wynntils.models.territories.type.GuildResource;
import com.wynntils.services.itemfilter.statproviders.territory.TerritoryStatProvider;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class TerritoryProductionStatProvider
extends TerritoryStatProvider<Integer> {
    private final GuildResource guildResource;

    public TerritoryProductionStatProvider(GuildResource guildResource) {
        this.guildResource = guildResource;
    }

    @Override
    public Optional<Integer> getValue(TerritoryItem territoryItem) {
        Integer generation = territoryItem.getProduction().get((Object)this.guildResource);
        return generation == null ? Optional.empty() : Optional.of(generation);
    }

    @Override
    public String getName() {
        return this.guildResource.getName().toLowerCase(Locale.ROOT);
    }

    @Override
    public String getDisplayName() {
        return this.guildResource.getName() + " Production";
    }

    @Override
    public List<String> getAliases() {
        return List.of(this.guildResource.getName().toLowerCase(Locale.ROOT) + "Production", this.guildResource.getName().toLowerCase(Locale.ROOT) + "Prod");
    }

    @Override
    public String getDescription() {
        return this.getTranslation("description", this.guildResource.getName());
    }
}

