/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.itemfilter.type;

import com.google.common.base.CaseFormat;
import com.wynntils.core.persisted.Translatable;
import java.util.Optional;
import net.minecraft.client.resources.language.I18n;

public abstract class StatFilterFactory<T>
implements Translatable {
    private final String name;
    private final String translationKey;

    protected StatFilterFactory() {
        String name = this.getClass().getSimpleName().replace("StatFilterFactory", "");
        this.name = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
        this.translationKey = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, name);
    }

    public abstract Optional<T> create(String var1);

    public String getName() {
        return this.name;
    }

    @Override
    public String getTranslation(String keySuffix, Object ... formatValues) {
        return I18n.get((String)("service.wynntils.itemFilter.filter." + this.translationKey + "." + keySuffix), (Object[])formatValues);
    }

    @Override
    public String getTypeName() {
        return "Service";
    }

    public String getDescription() {
        return this.getTranslation("description", new Object[0]);
    }

    public String getUsage() {
        return this.getTranslation("usage", new Object[0]);
    }
}

