/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.itemrecord;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Service;
import com.wynntils.core.components.Services;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.items.WynnItem;
import com.wynntils.services.itemrecord.type.SavedItem;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class ItemRecordService
extends Service {
    private static final String DEFAULT_CATEGORY = "Uncategorized";
    @Persisted
    public final Storage<Set<SavedItem>> savedItems = new Storage(new TreeSet());
    @Persisted
    private final Storage<Set<SavedItem>> faultyItems = new Storage(new TreeSet());
    @Persisted
    public final Storage<Set<String>> categories = new Storage<TreeSet<String>>(new TreeSet<String>(List.of("Uncategorized")));

    public ItemRecordService() {
        super(List.of());
    }

    public boolean saveItem(WynnItem wynnItem, ItemStack itemStack, Component itemName) {
        SavedItem itemToSave = SavedItem.create(wynnItem, new TreeSet<String>(List.of(Services.ItemRecord.getDefaultCategory())), itemStack);
        if (((Set)this.savedItems.get()).contains(itemToSave)) {
            McUtils.sendMessageToClient((Component)Component.translatable((String)"screens.wynntils.itemSharing.alreadySaved", (Object[])new Object[]{StyledText.fromComponent(itemName).getString() + String.valueOf(ChatFormatting.RED)}).withStyle(ChatFormatting.RED));
            return false;
        }
        ((Set)this.savedItems.get()).add(itemToSave);
        Services.ItemRecord.savedItems.touched();
        McUtils.sendMessageToClient((Component)Component.translatable((String)"screens.wynntils.itemSharing.savedToRecord", (Object[])new Object[]{StyledText.fromComponent(itemName).getString() + String.valueOf(ChatFormatting.GREEN)}).withStyle(ChatFormatting.GREEN));
        return true;
    }

    public void moveSelectedItems(List<Pair<String, String>> selectedItems, String category, boolean keepOriginal) {
        for (Pair<String, String> selectedItem : selectedItems) {
            SavedItem savedItem = Services.ItemRecord.getItem(selectedItem.b());
            this.moveItemCategory(savedItem, category, selectedItem.a(), keepOriginal);
        }
    }

    public void moveItemCategory(SavedItem savedItem, String currentCategory, String originalCategory, boolean keepOriginal) {
        savedItem.categories().add(currentCategory);
        if (!keepOriginal) {
            savedItem.categories().remove(originalCategory);
        }
        Services.ItemRecord.savedItems.touched();
    }

    public void deleteItem(String base64) {
        for (SavedItem savedItem : (Set)this.savedItems.get()) {
            if (!savedItem.base64().equals(base64)) continue;
            ((Set)Services.ItemRecord.savedItems.get()).remove(savedItem);
            Services.ItemRecord.savedItems.touched();
            break;
        }
    }

    public void addCategory(String newCategory, List<Pair<String, String>> selectedItems, boolean keepOriginals) {
        ((Set)Services.ItemRecord.categories.get()).add(newCategory);
        Services.ItemRecord.categories.touched();
        if (!selectedItems.isEmpty()) {
            this.moveSelectedItems(selectedItems, newCategory, keepOriginals);
        }
    }

    public void renameCategory(String originalName, String newName) {
        ((Set)this.categories.get()).add(newName);
        ((Set)this.categories.get()).remove(originalName);
        this.categories.touched();
        for (SavedItem savedItem : (Set)this.savedItems.get()) {
            if (!savedItem.categories().contains(originalName)) continue;
            savedItem.categories().add(newName);
            savedItem.categories().remove(originalName);
        }
        this.savedItems.touched();
    }

    public void deleteCategory(String categoryToDelete) {
        if (KeyboardUtils.isShiftDown()) {
            TreeSet<SavedItem> newSavedItems = new TreeSet<SavedItem>();
            for (SavedItem savedItem : (Set)this.savedItems.get()) {
                savedItem.categories().remove(categoryToDelete);
                if (savedItem.categories().isEmpty()) continue;
                newSavedItems.add(savedItem);
            }
            Services.ItemRecord.savedItems.store(newSavedItems);
            Services.ItemRecord.savedItems.touched();
        } else if (!categoryToDelete.equals(Services.ItemRecord.getDefaultCategory())) {
            for (SavedItem savedItem : (Set)this.savedItems.get()) {
                savedItem.categories().remove(categoryToDelete);
                savedItem.categories().add(Services.ItemRecord.getDefaultCategory());
            }
            Services.ItemRecord.savedItems.store((Set)this.savedItems.get());
            Services.ItemRecord.savedItems.touched();
        }
        if (!categoryToDelete.equals(Services.ItemRecord.getDefaultCategory())) {
            ((Set)Services.ItemRecord.categories.get()).remove(categoryToDelete);
            Services.ItemRecord.categories.touched();
        }
    }

    public String getDefaultCategory() {
        return DEFAULT_CATEGORY;
    }

    public void cleanupItemRecord() {
        ArrayList<SavedItem> itemsToRemove = new ArrayList<SavedItem>();
        for (SavedItem savedItem : (Set)this.savedItems.get()) {
            try {
                savedItem.wynnItem();
            }
            catch (Exception e) {
                WynntilsMod.warn("Removing invalid item from item record: " + savedItem.base64(), e);
                itemsToRemove.add(savedItem);
                ((Set)this.faultyItems.get()).add(savedItem);
            }
        }
        ArrayList<SavedItem> itemsToReadd = new ArrayList<SavedItem>();
        for (SavedItem faultyItem : (Set)this.faultyItems.get()) {
            try {
                faultyItem.wynnItem();
                itemsToReadd.add(faultyItem);
            }
            catch (Exception exception) {}
        }
        if (itemsToRemove.isEmpty() && itemsToReadd.isEmpty()) {
            return;
        }
        ((Set)this.savedItems.get()).removeAll(itemsToRemove);
        ((Set)this.faultyItems.get()).addAll(itemsToRemove);
        ((Set)this.faultyItems.get()).removeAll(itemsToReadd);
        ((Set)this.savedItems.get()).addAll(itemsToReadd);
        this.faultyItems.touched();
        this.savedItems.touched();
        WynntilsMod.warn("Item record cleanup complete. Removed " + itemsToRemove.size() + " invalid items. Readded " + itemsToReadd.size() + " items that can now be decoded.");
        McUtils.sendMessageToClient((Component)Component.translatable((String)"service.wynntils.itemRecord.cleanupComplete", (Object[])new Object[]{itemsToRemove.size(), itemsToReadd.size()}).withStyle(ChatFormatting.YELLOW));
    }

    private SavedItem getItem(String base64) {
        for (SavedItem savedItem : (Set)this.savedItems.get()) {
            if (!savedItem.base64().equals(base64)) continue;
            return savedItem;
        }
        return null;
    }
}

