/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.lootrunpaths;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.wynntils.core.WynntilsMod;
import com.wynntils.services.lootrunpaths.UncompiledLootrunPath;
import com.wynntils.services.lootrunpaths.type.LootrunNote;
import com.wynntils.services.lootrunpaths.type.LootrunPath;
import com.wynntils.services.lootrunpaths.type.LootrunSaveResult;
import com.wynntils.utils.mc.McUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.phys.Vec3;

public final class LootrunPathFileParser {
    public static UncompiledLootrunPath readJson(File file, JsonObject json) {
        JsonArray points = json.getAsJsonArray("points");
        LootrunPath pointsList = new LootrunPath(new ArrayList<Vec3>());
        for (JsonElement element : points) {
            JsonObject pointJson = element.getAsJsonObject();
            Vec3 position = new Vec3(pointJson.get("x").getAsDouble(), pointJson.get("y").getAsDouble(), pointJson.get("z").getAsDouble());
            pointsList.points().add(position);
        }
        JsonArray chestsJson = json.getAsJsonArray("chests");
        HashSet<BlockPos> chests = new HashSet<BlockPos>();
        if (chestsJson != null) {
            for (JsonElement element : chestsJson) {
                JsonObject chestJson = element.getAsJsonObject();
                BlockPos pos = new BlockPos(chestJson.get("x").getAsInt(), chestJson.get("y").getAsInt(), chestJson.get("z").getAsInt());
                chests.add(pos);
            }
        }
        JsonArray notesJson = json.getAsJsonArray("notes");
        ArrayList<LootrunNote> notes = new ArrayList<LootrunNote>();
        if (notesJson != null) {
            for (JsonElement element : notesJson) {
                JsonObject noteJson = element.getAsJsonObject();
                JsonObject positionJson = noteJson.getAsJsonObject("position");
                if (positionJson == null) {
                    positionJson = noteJson.getAsJsonObject("location");
                }
                Vec3 position = new Vec3(positionJson.get("x").getAsDouble(), positionJson.get("y").getAsDouble(), positionJson.get("z").getAsDouble());
                MutableComponent component = Component.Serializer.fromJson((JsonElement)noteJson.get("note"), (HolderLookup.Provider)McUtils.mc().player.registryAccess());
                LootrunNote note = new LootrunNote((Position)position, (Component)component);
                notes.add(note);
            }
        }
        return new UncompiledLootrunPath(pointsList, chests, notes, file);
    }

    public static LootrunSaveResult writeJson(UncompiledLootrunPath activeLootrun, File file) {
        try {
            boolean result = file.createNewFile();
            if (!result) {
                return LootrunSaveResult.ERROR_ALREADY_EXISTS;
            }
            JsonObject json = new JsonObject();
            JsonArray points = new JsonArray();
            for (Position position : activeLootrun.path().points()) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("x", (Number)position.x());
                jsonObject.addProperty("y", (Number)position.y());
                jsonObject.addProperty("z", (Number)position.z());
                points.add((JsonElement)jsonObject);
            }
            json.add("points", (JsonElement)points);
            JsonArray chests = new JsonArray();
            for (BlockPos blockPos : activeLootrun.chests()) {
                JsonObject chestJson = new JsonObject();
                chestJson.addProperty("x", (Number)blockPos.getX());
                chestJson.addProperty("y", (Number)blockPos.getY());
                chestJson.addProperty("z", (Number)blockPos.getZ());
                chests.add((JsonElement)chestJson);
            }
            json.add("chests", (JsonElement)chests);
            JsonArray jsonArray = new JsonArray();
            for (LootrunNote note : activeLootrun.notes()) {
                JsonObject noteJson = new JsonObject();
                JsonObject locationJson = new JsonObject();
                Position position = note.position();
                locationJson.addProperty("x", (Number)position.x());
                locationJson.addProperty("y", (Number)position.y());
                locationJson.addProperty("z", (Number)position.z());
                noteJson.add("location", (JsonElement)locationJson);
                String noteString = Component.Serializer.toJson((Component)note.component(), (HolderLookup.Provider)McUtils.mc().player.registryAccess());
                JsonElement noteElement = JsonParser.parseString((String)noteString);
                noteJson.add("note", noteElement);
                jsonArray.add((JsonElement)noteJson);
            }
            json.add("notes", (JsonElement)jsonArray);
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.now(), ZoneId.systemDefault());
            DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(Locale.US);
            json.addProperty("date", zonedDateTime.format(formatter));
            FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);
            WynntilsMod.GSON.toJson((JsonElement)json, (Appendable)writer);
            writer.close();
            return LootrunSaveResult.SAVED;
        }
        catch (IOException ex) {
            return LootrunSaveResult.ERROR_SAVING;
        }
    }
}

