/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.lootrunpaths.type;

import com.wynntils.services.lootrunpaths.type.ColoredPosition;
import com.wynntils.utils.mc.PosUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public enum BlockValidness {
    VALID,
    HAS_BARRIER,
    INVALID;


    public static BlockValidness checkBlockValidness(Level level, ColoredPosition point) {
        BlockValidness state = INVALID;
        Iterable<BlockPos> blocks = BlockValidness.getBlocksForPoint(point);
        for (BlockPos blockInArea : blocks) {
            BlockState blockStateInArea = level.getBlockState(blockInArea);
            if (blockStateInArea.is(Blocks.BARRIER)) {
                state = HAS_BARRIER;
                continue;
            }
            if (blockStateInArea.getCollisionShape((BlockGetter)level, blockInArea) == null) continue;
            state = VALID;
            return state;
        }
        return state;
    }

    private static Iterable<BlockPos> getBlocksForPoint(ColoredPosition loc) {
        BlockPos minPos = PosUtils.newBlockPos(loc.position().x() - 0.3, loc.position().y() - 1.0, loc.position().z() - 0.3);
        BlockPos maxPos = PosUtils.newBlockPos(loc.position().x() + 0.3, loc.position().y() - 1.0, loc.position().z() + 0.3);
        return BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos);
    }
}

