/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.map.pois;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.territories.TerritoryInfo;
import com.wynntils.models.territories.profile.TerritoryProfile;
import com.wynntils.screens.maps.GuildMapScreen;
import com.wynntils.services.map.pois.Poi;
import com.wynntils.services.map.type.DisplayPriority;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.PoiLocation;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;

public class TerritoryPoi
implements Poi {
    private final Supplier<TerritoryProfile> territoryProfileSupplier;
    private final PoiLocation territoryCenter;
    private final int width;
    private final int height;
    private final TerritoryInfo territoryInfo;
    private final boolean fakeTerritoryInfo;
    private TerritoryProfile territoryProfileCache;

    public TerritoryPoi(TerritoryProfile territoryProfile) {
        this(() -> territoryProfile, null);
    }

    public TerritoryPoi(Supplier<TerritoryProfile> territoryProfileSupplier, TerritoryInfo territoryInfo) {
        this(territoryProfileSupplier, territoryInfo, false);
    }

    public TerritoryPoi(TerritoryProfile territoryProfile, TerritoryInfo territoryInfo) {
        this(() -> territoryProfile, territoryInfo, true);
    }

    private TerritoryPoi(Supplier<TerritoryProfile> territoryProfileSupplier, TerritoryInfo territoryInfo, boolean fakeTerritoryInfo) {
        this.territoryProfileSupplier = territoryProfileSupplier;
        TerritoryProfile territoryProfile = this.getTerritoryProfile();
        this.width = territoryProfile.getEndX() - territoryProfile.getStartX();
        this.height = territoryProfile.getEndZ() - territoryProfile.getStartZ();
        this.territoryCenter = new PoiLocation(territoryProfile.getStartX() + this.width / 2, null, territoryProfile.getStartZ() + this.height / 2);
        this.territoryInfo = territoryInfo;
        this.fakeTerritoryInfo = fakeTerritoryInfo;
        this.territoryProfileCache = territoryProfileSupplier.get();
    }

    @Override
    public void renderAt(PoseStack poseStack, MultiBufferSource bufferSource, float renderX, float renderY, boolean hovered, float scale, float zoomRenderScale, float zoomLevel, boolean showLabels) {
        GuildMapScreen guildMapScreen;
        Screen screen;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 100.0f);
        float renderWidth = (float)this.width * zoomRenderScale;
        float renderHeight = (float)this.height * zoomRenderScale;
        float actualRenderX = renderX - renderWidth / 2.0f;
        float actualRenderZ = renderY - renderHeight / 2.0f;
        TerritoryProfile territoryProfile = this.getTerritoryProfile();
        List<CustomColor> colors = this.isTerritoryInfoUsable() && (screen = McUtils.mc().screen) instanceof GuildMapScreen && (guildMapScreen = (GuildMapScreen)screen).isResourceMode() ? this.territoryInfo.getResourceColors() : (this.isTerritoryInfoUsable() && this.territoryInfo.getGuildName().equals(TerritoryProfile.GuildInfo.NONE.name()) || territoryProfile.getGuildInfo() == TerritoryProfile.GuildInfo.NONE ? List.of(CommonColors.WHITE) : List.of(Models.Guild.getColor(this.isTerritoryInfoUsable() ? this.territoryInfo.getGuildName() : territoryProfile.getGuild())));
        BufferedRenderUtils.drawMulticoloredRect(poseStack, bufferSource, colors.stream().map(x -> x.withAlpha(80)).toList(), actualRenderX, actualRenderZ, 0.0f, renderWidth, renderHeight);
        BufferedRenderUtils.drawMulticoloredRectBorders(poseStack, bufferSource, colors, actualRenderX, actualRenderZ, 0.0f, renderWidth, renderHeight, 1.5f, 0.5f);
        if (this.isTerritoryInfoUsable() && this.territoryInfo.isHeadquarters()) {
            BufferedRenderUtils.drawTexturedRect(poseStack, bufferSource, Texture.GUILD_HEADQUARTERS, actualRenderX + renderWidth / 2.0f - (float)Texture.GUILD_HEADQUARTERS.width() / 2.0f, actualRenderZ + renderHeight / 2.0f - (float)Texture.GUILD_HEADQUARTERS.height() / 2.0f);
        } else {
            String guildPrefix = this.isTerritoryInfoUsable() ? this.territoryInfo.getGuildPrefix() : territoryProfile.getGuildPrefix();
            BufferedFontRenderer.getInstance().renderAlignedTextInBox(poseStack, bufferSource, StyledText.fromString(guildPrefix), actualRenderX, actualRenderX + renderWidth, actualRenderZ, actualRenderZ + renderHeight, 0.0f, colors.getFirst(), HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.OUTLINE);
        }
        Models.GuildAttackTimer.getAttackTimerForTerritory(territoryProfile.getFriendlyName()).ifPresent(attackTimer -> {
            String timeLeft = attackTimer.timerString();
            BufferedFontRenderer.getInstance().renderAlignedTextInBox(poseStack, bufferSource, StyledText.fromString(timeLeft), actualRenderX, actualRenderX + renderWidth, actualRenderZ, actualRenderZ + renderHeight, 0.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.OUTLINE);
        });
        if (hovered) {
            BufferedFontRenderer.getInstance().renderAlignedTextInBox(poseStack, bufferSource, StyledText.fromString(territoryProfile.getFriendlyName()), actualRenderX, actualRenderX + renderWidth, actualRenderZ, actualRenderZ + renderHeight, 0.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.OUTLINE);
        }
        poseStack.popPose();
    }

    private boolean isTerritoryInfoUsable() {
        return !this.fakeTerritoryInfo && this.territoryInfo != null;
    }

    @Override
    public PoiLocation getLocation() {
        return this.territoryCenter;
    }

    @Override
    public boolean hasStaticLocation() {
        return true;
    }

    @Override
    public int getWidth(float mapZoom, float scale) {
        return (int)((float)this.width * mapZoom);
    }

    @Override
    public int getHeight(float mapZoom, float scale) {
        return (int)((float)this.height * mapZoom);
    }

    @Override
    public String getName() {
        return this.getTerritoryProfile().getName();
    }

    @Override
    public DisplayPriority getDisplayPriority() {
        return DisplayPriority.HIGHEST;
    }

    public TerritoryInfo getTerritoryInfo() {
        return this.territoryInfo;
    }

    public boolean isFakeTerritoryInfo() {
        return this.fakeTerritoryInfo;
    }

    public TerritoryProfile getTerritoryProfile() {
        return this.tryGetUpdatedTerritoryProfile();
    }

    private TerritoryProfile tryGetUpdatedTerritoryProfile() {
        TerritoryProfile territoryProfile = this.territoryProfileSupplier.get();
        if (territoryProfile != null) {
            this.territoryProfileCache = territoryProfile;
        }
        return this.territoryProfileCache;
    }
}

