/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.mapdata;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.services.mapdata.attributes.type.MapDecoration;
import com.wynntils.services.mapdata.attributes.type.MapIcon;
import com.wynntils.services.mapdata.attributes.type.ResolvedMapAttributes;
import com.wynntils.services.mapdata.type.MapFeature;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;

public final class MapFeatureRenderer {
    private static final int SPACING = 2;
    private static final float TEXT_SCALE = 1.0f;

    public static void renderMapFeature(PoseStack poseStack, MultiBufferSource bufferSource, MapFeature feature, ResolvedMapAttributes attributes, float renderX, float renderY, boolean hovered, float scale, float zoomLevel, boolean showLabels) {
        MapDecoration decoration;
        boolean drawLevel;
        float labelAlpha;
        boolean drawLabel;
        boolean drawIcon;
        float renderScale = hovered ? scale * 1.05f : scale;
        float hoverAlphaFactor = hovered ? 1.0f : 0.9f;
        Objects.requireNonNull(FontRenderer.getInstance().getFont());
        int labelHeight = (int)(9.0f * renderScale * 1.0f);
        int yOffset = 0;
        poseStack.pushPose();
        poseStack.translate(renderX, renderY, (float)attributes.priority());
        poseStack.scale(renderScale, renderScale, renderScale);
        float iconAlpha = hoverAlphaFactor * Services.MapData.calculateVisibility(attributes.iconVisibility(), zoomLevel);
        Optional<MapIcon> icon = Services.MapData.getIcon(attributes.iconId());
        boolean bl = drawIcon = (double)iconAlpha > 0.01;
        if (icon.isPresent() && drawIcon) {
            int iconWidth = icon.get().getWidth();
            int iconHeight = icon.get().getHeight();
            if (hovered) {
                iconAlpha = 1.0f;
            }
            BufferedRenderUtils.drawColoredTexturedRect(poseStack, bufferSource, icon.get().getResourceLocation(), attributes.iconColor(), iconAlpha, 0.0f - (float)iconWidth / 2.0f, (float)yOffset - (float)iconHeight / 2.0f, 0.0f, iconWidth, iconHeight);
            yOffset += (iconHeight + labelHeight) / 2 + 2;
        }
        boolean bl2 = drawLabel = (double)(labelAlpha = hoverAlphaFactor * Services.MapData.calculateVisibility(attributes.labelVisibility(), zoomLevel)) > 0.01 || drawIcon && hovered;
        if (!attributes.label().isEmpty() && drawLabel && showLabels) {
            if (drawIcon && hovered) {
                labelAlpha = 1.0f;
            }
            CustomColor color = attributes.labelColor().withAlpha(labelAlpha);
            BufferedFontRenderer.getInstance().renderText(poseStack, bufferSource, StyledText.fromString(attributes.label()), 0.0f, (float)yOffset, color, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, attributes.labelShadow(), 1.0f);
            yOffset += labelHeight + 2;
        }
        int level = attributes.level();
        boolean bl3 = drawLevel = hovered && (drawIcon || drawLabel);
        if (level >= 1 && drawLevel) {
            BufferedFontRenderer.getInstance().renderText(poseStack, bufferSource, StyledText.fromString("[Lv. " + level + "]"), 0.0f, (float)yOffset, attributes.labelColor(), HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, attributes.labelShadow(), 1.0f);
        }
        if ((decoration = attributes.iconDecoration()).isVisible()) {
            decoration.render(poseStack, bufferSource, hovered, zoomLevel);
        }
        poseStack.popPose();
    }
}

