/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;

public class DateFormatter
extends Format {
    private static final Map<ChronoUnit, String> MAPPINGS = Map.of(ChronoUnit.YEARS, "y", ChronoUnit.MONTHS, "mo", ChronoUnit.DAYS, "d", ChronoUnit.HOURS, "h", ChronoUnit.MINUTES, "m", ChronoUnit.SECONDS, "s");
    private final boolean longFormat;

    public DateFormatter(boolean longFormat) {
        this.longFormat = longFormat;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof Long) {
            Long time = (Long)obj;
            if (this.longFormat) {
                return this.formatLongDate(time, toAppendTo, pos);
            }
            return this.formatShortDate(time, toAppendTo, pos);
        }
        throw new IllegalArgumentException("Unsupported object type for date formatting");
    }

    private StringBuffer formatShortDate(Long time, StringBuffer toAppendTo, FieldPosition pos) {
        Duration duration = Duration.ofMillis(time);
        LinkedHashMap<ChronoUnit, Long> timeUnits = new LinkedHashMap<ChronoUnit, Long>();
        timeUnits.put(ChronoUnit.DAYS, duration.toDays());
        duration = duration.minusDays((Long)timeUnits.get(ChronoUnit.DAYS));
        timeUnits.put(ChronoUnit.HOURS, duration.toHours());
        duration = duration.minusHours((Long)timeUnits.get(ChronoUnit.HOURS));
        timeUnits.put(ChronoUnit.MINUTES, duration.toMinutes());
        duration = duration.minusMinutes((Long)timeUnits.get(ChronoUnit.MINUTES));
        timeUnits.put(ChronoUnit.SECONDS, duration.getSeconds());
        timeUnits.forEach((timeUnit, value) -> {
            if (value > 0L) {
                toAppendTo.append(value).append(MAPPINGS.get(timeUnit)).append(" ");
            }
        });
        return toAppendTo;
    }

    private StringBuffer formatLongDate(Long time, StringBuffer toAppendTo, FieldPosition pos) {
        LocalDateTime startDateTime = LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC);
        LocalDateTime endDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneOffset.UTC);
        Period period = Period.between(startDateTime.toLocalDate(), endDateTime.toLocalDate());
        Duration duration = Duration.between(startDateTime.toLocalTime(), endDateTime.toLocalTime());
        LinkedHashMap<ChronoUnit, Long> timeUnits = new LinkedHashMap<ChronoUnit, Long>();
        timeUnits.put(ChronoUnit.YEARS, Long.valueOf(period.getYears()));
        timeUnits.put(ChronoUnit.MONTHS, Long.valueOf(period.getMonths()));
        timeUnits.put(ChronoUnit.DAYS, Long.valueOf(period.getDays()));
        timeUnits.put(ChronoUnit.HOURS, duration.toHours());
        duration = duration.minusHours((Long)timeUnits.get(ChronoUnit.HOURS));
        timeUnits.put(ChronoUnit.MINUTES, duration.toMinutes());
        duration = duration.minusMinutes((Long)timeUnits.get(ChronoUnit.MINUTES));
        timeUnits.put(ChronoUnit.SECONDS, duration.getSeconds());
        timeUnits.forEach((timeUnit, value) -> {
            if (value > 0L) {
                toAppendTo.append(value).append(MAPPINGS.get(timeUnit)).append(" ");
            }
        });
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        throw new UnsupportedOperationException("Parsing relative time is not supported.");
    }
}

