/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.mc;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.wynntils.core.text.StyledText;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.Level;

public final class LoreUtils {
    public static LinkedList<StyledText> getLore(ItemStack itemStack) {
        List lines = ((ItemLore)itemStack.getOrDefault(DataComponents.LORE, (Object)ItemLore.EMPTY)).lines();
        return lines.stream().map(StyledText::fromComponent).collect(LinkedList::new, LinkedList::add, LinkedList::addAll);
    }

    public static Matcher matchLoreLine(ItemStack itemStack, int startLineNum, Pattern pattern) {
        StyledText line;
        LinkedList<StyledText> lore = LoreUtils.getLore(itemStack);
        Matcher matcher = StyledText.EMPTY.getMatcher(pattern);
        for (int i = startLineNum; i < Math.min(startLineNum + 6, lore.size()) && !(matcher = pattern.matcher((line = lore.get(i)).getString())).matches(); ++i) {
        }
        return matcher;
    }

    public static StyledText getStringLore(ItemStack itemStack) {
        return StyledText.concat(LoreUtils.getLore(itemStack));
    }

    public static List<Component> getTooltipLines(ItemStack itemStack) {
        TooltipFlag.Default flag = McUtils.options().advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL;
        return itemStack.getTooltipLines(Item.TooltipContext.of((Level)McUtils.mc().level), (Player)McUtils.player(), (TooltipFlag)flag);
    }

    public static List<Component> appendTooltip(ItemStack itemStack, List<Component> baseTooltip, List<Component> tooltipAddon) {
        int advancedStartLine;
        if (McUtils.options().advancedItemTooltips && (advancedStartLine = LoreUtils.getAdvancedStartLine(baseTooltip, itemStack)) != -1) {
            ArrayList<Component> newTooltip = new ArrayList<Component>();
            for (int i = 0; i < baseTooltip.size(); ++i) {
                if (i == advancedStartLine) {
                    newTooltip.addAll(tooltipAddon);
                }
                newTooltip.add(baseTooltip.get(i));
            }
            return newTooltip;
        }
        ArrayList<Component> newTooltip = new ArrayList<Component>(baseTooltip);
        newTooltip.addAll(tooltipAddon);
        return newTooltip;
    }

    private static int getAdvancedStartLine(List<Component> baseTooltip, ItemStack itemStack) {
        MutableComponent typeLine = Component.literal((String)BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString()).withStyle(ChatFormatting.DARK_GRAY);
        MutableComponent damagedLine = Component.translatable((String)"item.durability", (Object[])new Object[]{itemStack.getMaxDamage() - itemStack.getDamageValue(), itemStack.getMaxDamage()});
        int advancedStartLine = -1;
        for (int i = baseTooltip.size() - 1; i >= Math.max(0, baseTooltip.size() - 4); --i) {
            Component line = baseTooltip.get(i);
            if (!line.equals((Object)typeLine)) continue;
            advancedStartLine = i;
            break;
        }
        if (advancedStartLine > 1 && baseTooltip.get(advancedStartLine - 1).equals((Object)damagedLine)) {
            --advancedStartLine;
        }
        return advancedStartLine;
    }

    public static JsonObject getJsonFromIngameLore(ItemStack itemStack) {
        String rawLore = StringUtils.substringBeforeLast(LoreUtils.getStringLore(itemStack).getString(), "}") + "}";
        try {
            return JsonParser.parseString((String)rawLore).getAsJsonObject();
        }
        catch (JsonSyntaxException e) {
            return new JsonObject();
        }
    }
}

