/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.wynntils.commands.LocateCommand;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.features.map.WorldWaypointDistanceFeature;
import com.wynntils.models.marker.MarkerModel;
import com.wynntils.models.marker.type.MarkerInfo;
import com.wynntils.models.territories.profile.TerritoryProfile;
import com.wynntils.services.map.pois.LabelPoi;
import com.wynntils.services.map.pois.Poi;
import com.wynntils.services.map.pois.ServicePoi;
import com.wynntils.services.map.type.ServiceKind;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.mc.type.PoiLocation;
import com.wynntils.utils.wynn.LocationUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class CompassCommand
extends Command {
    private static final SuggestionProvider<CommandSourceStack> SHARE_TARGET_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(Stream.concat(Stream.of("party", "guild"), McUtils.mc().level.players().stream().map(Player::getScoreboardName)), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<CommandSourceStack> TERRITORY_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(Models.Territory.getTerritoryNames(), (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "compass";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommandBuilder(LiteralArgumentBuilder<CommandSourceStack> base, CommandBuildContext context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(Commands.literal((String)"at").then(Commands.argument((String)"location", (ArgumentType)Vec3Argument.vec3()).executes(this::compassAtVec3)))).then(((LiteralArgumentBuilder)Commands.literal((String)"share").then(Commands.literal((String)"location").then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.word()).suggests(SHARE_TARGET_SUGGESTION_PROVIDER).executes(this::shareLocation)))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)StringArgumentType.word()).suggests(SHARE_TARGET_SUGGESTION_PROVIDER).then(Commands.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(this::shareCompassIndex))).executes(this::shareCompass)))).then(Commands.literal((String)"service").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(LocateCommand.SERVICE_SUGGESTION_PROVIDER).executes(this::compassService)))).then(Commands.literal((String)"place").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(LocateCommand.PLACES_SUGGESTION_PROVIDER).executes(this::compassPlace)))).then(Commands.literal((String)"territory").then(Commands.argument((String)"territory", (ArgumentType)StringArgumentType.greedyString()).suggests(TERRITORY_SUGGESTION_PROVIDER).executes(this::territory)))).then(Commands.literal((String)"npc").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(this::notImplemented)))).then(Commands.literal((String)"other").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(this::notImplemented)))).then(Commands.literal((String)"clear").executes(this::compassClear))).then(Commands.argument((String)"location", (ArgumentType)StringArgumentType.greedyString()).executes(this::compassAtString))).executes(this::syntaxError);
    }

    private int shareCompassIndex(CommandContext<CommandSourceStack> context) {
        List<MarkerInfo> markers = MarkerModel.USER_WAYPOINTS_PROVIDER.getMarkerInfos().toList();
        if (markers.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"You don't have a compass set!").withStyle(ChatFormatting.RED));
            return 1;
        }
        String target = StringArgumentType.getString(context, (String)"target");
        int index = IntegerArgumentType.getInteger(context, (String)"index");
        LocationUtils.shareCompass(target, markers.get(index).location());
        return 1;
    }

    private int shareCompass(CommandContext<CommandSourceStack> context) {
        List<MarkerInfo> markers = MarkerModel.USER_WAYPOINTS_PROVIDER.getMarkerInfos().toList();
        if (markers.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"You don't have a compass set!").withStyle(ChatFormatting.RED));
            return 1;
        }
        String target = StringArgumentType.getString(context, (String)"target");
        LocationUtils.shareCompass(target, markers.getFirst().location());
        return 1;
    }

    private int shareLocation(CommandContext<CommandSourceStack> context) {
        String target = StringArgumentType.getString(context, (String)"target");
        LocationUtils.shareLocation(target);
        return 1;
    }

    private int compassAtVec3(CommandContext<CommandSourceStack> context) {
        Coordinates coordinates = Vec3Argument.getCoordinates(context, (String)"location");
        Location location = new Location(coordinates.getBlockPos((CommandSourceStack)context.getSource()));
        MarkerModel.USER_WAYPOINTS_PROVIDER.removeAllLocations();
        MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(location, null);
        MutableComponent response = Component.literal((String)"Compass set to ").withStyle(ChatFormatting.AQUA);
        response.append((Component)Component.literal((String)location.toString()).withStyle(ChatFormatting.WHITE));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int compassAtString(CommandContext<CommandSourceStack> context) {
        String coordinates = StringArgumentType.getString(context, (String)"location");
        Optional<Location> location = LocationUtils.parseFromString(coordinates);
        if (location.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Incorrect coordinates!"));
            return 0;
        }
        MarkerModel.USER_WAYPOINTS_PROVIDER.removeAllLocations();
        MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(location.get(), null);
        MutableComponent response = Component.literal((String)"Compass set to ").withStyle(ChatFormatting.AQUA);
        response.append((Component)Component.literal((String)location.get().toString()).withStyle(ChatFormatting.WHITE));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int compassService(CommandContext<CommandSourceStack> context) {
        String searchedName = (String)context.getArgument("name", String.class);
        ServiceKind selectedKind = LocateCommand.getServiceKind(context, searchedName);
        if (selectedKind == null) {
            return 0;
        }
        Vec3 currentLocation = McUtils.player().position();
        Optional<ServicePoi> closestServiceOptional = Services.Poi.getServicePois().filter(poi -> poi.getKind() == selectedKind).min(Comparator.comparingDouble(poi -> currentLocation.distanceToSqr((double)poi.getLocation().getX(), (double)poi.getLocation().getY().orElse((int)currentLocation.y).intValue(), (double)poi.getLocation().getZ())));
        if (closestServiceOptional.isEmpty()) {
            MutableComponent response = Component.literal((String)("Found no services of kind '" + selectedKind.getName() + "'")).withStyle(ChatFormatting.RED);
            ((CommandSourceStack)context.getSource()).sendFailure((Component)response);
            return 0;
        }
        Poi closestService = closestServiceOptional.get();
        MarkerModel.USER_WAYPOINTS_PROVIDER.removeAllLocations();
        MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(closestService.getLocation().asLocation(), closestServiceOptional.get().getIcon(), (Boolean)Managers.Feature.getFeatureInstance(WorldWaypointDistanceFeature.class).showAdditionalTextInWorld.get() != false ? closestServiceOptional.get().getName() : null);
        MutableComponent response = Component.literal((String)("Compass set to " + selectedKind.getName() + " at ")).withStyle(ChatFormatting.AQUA);
        response.append((Component)Component.literal((String)closestService.getLocation().toString()).withStyle(ChatFormatting.WHITE));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int compassPlace(CommandContext<CommandSourceStack> context) {
        Poi place;
        String searchedName = (String)context.getArgument("name", String.class);
        ArrayList<LabelPoi> places = new ArrayList<LabelPoi>(Services.Poi.getLabelPois().filter(poi -> StringUtils.partialMatch(poi.getName(), searchedName)).toList());
        if (places.isEmpty()) {
            MutableComponent response = Component.literal((String)("Found no places matching '" + searchedName + "'")).withStyle(ChatFormatting.RED);
            ((CommandSourceStack)context.getSource()).sendFailure((Component)response);
            return 0;
        }
        if (places.size() > 1) {
            Optional<Poi> exactMatch = places.stream().filter(poi -> poi.getName().equals(searchedName)).findFirst();
            if (exactMatch.isEmpty()) {
                MutableComponent response = Component.literal((String)("Found multiple places matching '" + searchedName + "', but none matched exactly. Matching: ")).withStyle(ChatFormatting.RED);
                response.append((Component)Component.literal((String)String.join((CharSequence)", ", places.stream().map(Poi::getName).toList())));
                ((CommandSourceStack)context.getSource()).sendFailure((Component)response);
                return 0;
            }
            place = exactMatch.get();
        } else {
            place = (Poi)places.getFirst();
        }
        MarkerModel.USER_WAYPOINTS_PROVIDER.removeAllLocations();
        MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(place.getLocation().asLocation(), place.getName());
        MutableComponent response = Component.literal((String)("Compass set to " + place.getName() + " at ")).withStyle(ChatFormatting.AQUA);
        response.append((Component)Component.literal((String)place.getLocation().toString()).withStyle(ChatFormatting.WHITE));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    public int territory(CommandContext<CommandSourceStack> context) {
        String territoryArg = (String)context.getArgument("territory", String.class);
        TerritoryProfile territoryProfile = Models.Territory.getTerritoryProfile(territoryArg);
        if (territoryProfile == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Can't find territory '" + territoryArg + "'")).withStyle(ChatFormatting.RED));
            return 1;
        }
        PoiLocation location = territoryProfile.getCenterLocation();
        MarkerModel.USER_WAYPOINTS_PROVIDER.removeAllLocations();
        MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(location.asLocation(), null);
        MutableComponent response = Component.literal((String)("Compass set to middle of " + territoryProfile.getFriendlyName() + " at ")).withStyle(ChatFormatting.AQUA);
        response.append((Component)Component.literal((String)location.toString()).withStyle(ChatFormatting.WHITE));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int compassClear(CommandContext<CommandSourceStack> context) {
        MarkerModel.USER_WAYPOINTS_PROVIDER.removeAllLocations();
        MutableComponent response = Component.literal((String)"Compass cleared").withStyle(ChatFormatting.AQUA);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int notImplemented(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Not implemented yet").withStyle(ChatFormatting.RED));
        return 0;
    }

    public int syntaxError(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Missing argument").withStyle(ChatFormatting.RED));
        return 0;
    }
}

