/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.google.common.base.CaseFormat;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.overlays.DynamicOverlay;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.OverlayGroupHolder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.StringUtils;

public class ConfigCommand
extends Command {
    private static final SuggestionProvider<CommandSourceStack> FEATURE_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(Managers.Feature.getFeatures().stream().map(Feature::getShortName), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> OVERLAY_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(() -> {
        String featureName = (String)context.getArgument("feature", String.class);
        Optional<Feature> foundFeature = Managers.Feature.getFeatureFromString(featureName);
        return foundFeature.map(feature -> Managers.Overlay.getFeatureOverlays((Feature)feature).stream().map(Overlay::getShortName).iterator()).orElse(Collections.emptyIterator());
    }, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> FEATURE_CONFIG_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(() -> {
        String featureName = (String)context.getArgument("feature", String.class);
        Optional<Feature> foundFeature = Managers.Feature.getFeatureFromString(featureName);
        return foundFeature.map(feature -> feature.getVisibleConfigOptions().stream().map(Config::getFieldName).iterator()).orElse(Collections.emptyIterator());
    }, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> OVERLAY_GROUP_FEATURE_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(Managers.Feature.getFeatures().stream().filter(feature -> !Managers.Overlay.getFeatureOverlayGroups((Feature)feature).isEmpty()).map(Feature::getShortName), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> OVERLAY_CONFIG_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(() -> {
        String featureName = (String)context.getArgument("feature", String.class);
        String overlayName = (String)context.getArgument("overlay", String.class);
        Optional<Feature> featureOptional = Managers.Feature.getFeatureFromString(featureName);
        if (featureOptional.isEmpty()) {
            return Collections.emptyIterator();
        }
        Feature feature = featureOptional.get();
        Optional<Overlay> overlayOptional = Managers.Overlay.getFeatureOverlays(feature).stream().filter(overlay -> overlay.getShortName().equals(overlayName)).findFirst();
        return overlayOptional.map(overlay -> overlay.getVisibleConfigOptions().stream().map(Config::getFieldName).iterator()).orElse(Collections.emptyIterator());
    }, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> CONFIG_VALUE_SUGGESTION_PROVIDER = (context, builder) -> {
        String configName;
        String featureName = (String)context.getArgument("feature", String.class);
        Config<?> config = ConfigCommand.getConfigFromArguments((CommandContext<CommandSourceStack>)context, featureName, configName = (String)context.getArgument("config", String.class));
        if (config == null) {
            return SharedSuggestionProvider.suggest(Stream.of(new String[0]), (SuggestionsBuilder)builder);
        }
        return SharedSuggestionProvider.suggest(config.getValidLiterals(), (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<CommandSourceStack> OVERLAY_CONFIG_VALUE_SUGGESTION_PROVIDER = (context, builder) -> {
        String configName;
        String overlayName;
        String featureName = (String)context.getArgument("feature", String.class);
        Config<?> config = ConfigCommand.getOverlayConfigFromArguments((CommandContext<CommandSourceStack>)context, featureName, overlayName = (String)context.getArgument("overlay", String.class), configName = (String)context.getArgument("config", String.class));
        if (config == null) {
            return SharedSuggestionProvider.suggest(Stream.of(new String[0]), (SuggestionsBuilder)builder);
        }
        return SharedSuggestionProvider.suggest(config.getValidLiterals(), (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<CommandSourceStack> OVERLAY_GROUP_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(() -> {
        String featureName = (String)context.getArgument("feature", String.class);
        Optional<Feature> featureOptional = Managers.Feature.getFeatureFromString(featureName);
        return featureOptional.map(feature -> Managers.Overlay.getFeatureOverlayGroups((Feature)feature).stream().map(OverlayGroupHolder::getFieldName).iterator()).orElse(Collections.emptyIterator());
    }, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> OVERLAY_GROUP_REMOVE_ID_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(() -> {
        String groupName;
        String featureName = (String)context.getArgument("feature", String.class);
        OverlayGroupHolder overlayGroupHolder = ConfigCommand.getOverlayGroupHolderFromArguments((CommandContext<CommandSourceStack>)context, featureName, groupName = (String)context.getArgument("group", String.class));
        if (overlayGroupHolder == null) {
            return Collections.emptyIterator();
        }
        return overlayGroupHolder.getOverlays().stream().map(overlay -> ((DynamicOverlay)overlay).getId()).map(String::valueOf).iterator();
    }, (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "config";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommandBuilder(LiteralArgumentBuilder<CommandSourceStack> base, CommandBuildContext context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(this.buildGetConfigNode())).then(this.buildSetConfigNode())).then(this.buildResetConfigNode())).then(this.buildReloadConfigNode())).then(this.buildOverlayGroupNode())).executes(this::syntaxError);
    }

    private LiteralCommandNode<CommandSourceStack> buildGetConfigNode() {
        LiteralArgumentBuilder getConfigArgBuilder = Commands.literal((String)"get");
        getConfigArgBuilder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"feature", (ArgumentType)StringArgumentType.word()).suggests(FEATURE_SUGGESTION_PROVIDER).then(Commands.literal((String)"overlay").then(((RequiredArgumentBuilder)Commands.argument((String)"overlay", (ArgumentType)StringArgumentType.word()).suggests(OVERLAY_SUGGESTION_PROVIDER).then(Commands.argument((String)"config", (ArgumentType)StringArgumentType.word()).suggests(OVERLAY_CONFIG_SUGGESTION_PROVIDER).executes(this::getSpecificOverlayConfigOption))).executes(this::listAllOverlayConfigs)))).then(Commands.argument((String)"config", (ArgumentType)StringArgumentType.word()).suggests(FEATURE_CONFIG_SUGGESTION_PROVIDER).executes(this::getSpecificConfigOption))).executes(this::listAllConfigOptions));
        return getConfigArgBuilder.build();
    }

    private LiteralCommandNode<CommandSourceStack> buildSetConfigNode() {
        LiteralArgumentBuilder setConfigArgBuilder = Commands.literal((String)"set");
        setConfigArgBuilder.then(((RequiredArgumentBuilder)Commands.argument((String)"feature", (ArgumentType)StringArgumentType.word()).suggests(FEATURE_SUGGESTION_PROVIDER).then(Commands.literal((String)"overlay").then(Commands.argument((String)"overlay", (ArgumentType)StringArgumentType.word()).suggests(OVERLAY_SUGGESTION_PROVIDER).then(Commands.argument((String)"config", (ArgumentType)StringArgumentType.word()).suggests(OVERLAY_CONFIG_SUGGESTION_PROVIDER).then(Commands.argument((String)"newValue", (ArgumentType)StringArgumentType.greedyString()).suggests(OVERLAY_CONFIG_VALUE_SUGGESTION_PROVIDER).executes(this::changeOverlayConfig)))))).then(Commands.argument((String)"config", (ArgumentType)StringArgumentType.word()).suggests(FEATURE_CONFIG_SUGGESTION_PROVIDER).then(Commands.argument((String)"newValue", (ArgumentType)StringArgumentType.greedyString()).suggests(CONFIG_VALUE_SUGGESTION_PROVIDER).executes(this::changeFeatureConfig))));
        return setConfigArgBuilder.build();
    }

    private LiteralCommandNode<CommandSourceStack> buildResetConfigNode() {
        LiteralArgumentBuilder resetConfigArgBuilder = Commands.literal((String)"reset");
        resetConfigArgBuilder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"feature", (ArgumentType)StringArgumentType.word()).suggests(FEATURE_SUGGESTION_PROVIDER).then(Commands.literal((String)"overlay").then(((RequiredArgumentBuilder)Commands.argument((String)"overlay", (ArgumentType)StringArgumentType.word()).suggests(OVERLAY_SUGGESTION_PROVIDER).then(Commands.argument((String)"config", (ArgumentType)StringArgumentType.word()).suggests(OVERLAY_CONFIG_SUGGESTION_PROVIDER).executes(this::resetOverlayConfigOption))).executes(this::resetAllOverlayConfigOptions)))).then(Commands.argument((String)"config", (ArgumentType)StringArgumentType.word()).suggests(FEATURE_CONFIG_SUGGESTION_PROVIDER).executes(this::resetFeatureConfigOption))).executes(this::resetAllConfigOptions));
        return resetConfigArgBuilder.build();
    }

    private LiteralCommandNode<CommandSourceStack> buildReloadConfigNode() {
        LiteralArgumentBuilder reloadConfigArgBuilder = Commands.literal((String)"reload");
        reloadConfigArgBuilder.executes(this::reloadAllConfigOptions);
        return reloadConfigArgBuilder.build();
    }

    private LiteralCommandNode<CommandSourceStack> buildOverlayGroupNode() {
        LiteralArgumentBuilder overlayGroupArgBuilder = Commands.literal((String)"overlaygroup");
        overlayGroupArgBuilder.then(Commands.argument((String)"feature", (ArgumentType)StringArgumentType.word()).suggests(OVERLAY_GROUP_FEATURE_SUGGESTION_PROVIDER).then(((RequiredArgumentBuilder)Commands.argument((String)"group", (ArgumentType)StringArgumentType.word()).suggests(OVERLAY_GROUP_SUGGESTION_PROVIDER).then(Commands.literal((String)"add").executes(this::addOverlayGroup))).then(Commands.literal((String)"remove").then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.word()).suggests(OVERLAY_GROUP_REMOVE_ID_SUGGESTION_PROVIDER).executes(this::removeOverlayGroup)))));
        return overlayGroupArgBuilder.build();
    }

    private int addOverlayGroup(CommandContext<CommandSourceStack> context) {
        String groupName;
        String featureName = (String)context.getArgument("feature", String.class);
        OverlayGroupHolder overlayGroupHolder = ConfigCommand.getOverlayGroupHolderFromArguments(context, featureName, groupName = (String)context.getArgument("group", String.class));
        if (overlayGroupHolder == null) {
            return 0;
        }
        int newId = Managers.Overlay.extendOverlayGroup(overlayGroupHolder);
        Managers.Config.reloadConfiguration(false);
        Managers.Config.saveConfig();
        Managers.Config.reloadConfiguration(true);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Successfully added a new %s to %s with the id %d.".formatted(overlayGroupHolder.getOverlayClass().getSimpleName(), overlayGroupHolder.getFieldName(), newId)).withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    private int removeOverlayGroup(CommandContext<CommandSourceStack> context) {
        String featureName = (String)context.getArgument("feature", String.class);
        String groupName = (String)context.getArgument("group", String.class);
        String idName = (String)context.getArgument("id", String.class);
        OverlayGroupHolder overlayGroupHolder = ConfigCommand.getOverlayGroupHolderFromArguments(context, featureName, groupName);
        if (overlayGroupHolder == null) {
            return 0;
        }
        int id = Integer.parseInt(idName);
        Managers.Overlay.removeIdFromOverlayGroup(overlayGroupHolder, id);
        Managers.Config.reloadConfiguration(false);
        Managers.Config.saveConfig();
        Managers.Config.reloadConfiguration(true);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Successfully removed %s from %s with the id %d.".formatted(overlayGroupHolder.getOverlayClass().getSimpleName(), overlayGroupHolder.getFieldName(), id)).withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    private int reloadAllConfigOptions(CommandContext<CommandSourceStack> context) {
        Managers.Config.reloadConfiguration(true);
        Managers.Config.saveConfig();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Successfully reloaded configs from file.").withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    private int resetOverlayConfigOption(CommandContext<CommandSourceStack> context) {
        String configName;
        String overlayName;
        String featureName = (String)context.getArgument("feature", String.class);
        Config<?> config = ConfigCommand.getOverlayConfigFromArguments(context, featureName, overlayName = (String)context.getArgument("overlay", String.class), configName = (String)context.getArgument("config", String.class));
        if (config == null) {
            return 0;
        }
        config.reset();
        Managers.Config.saveConfig();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Successfully reset ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)config.getDisplayName()).withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)".").withStyle(ChatFormatting.GREEN)), false);
        return 1;
    }

    private int resetAllOverlayConfigOptions(CommandContext<CommandSourceStack> context) {
        String overlayName;
        String featureName = (String)context.getArgument("feature", String.class);
        Overlay overlay = ConfigCommand.getOverlayFromArguments(context, featureName, overlayName = (String)context.getArgument("overlay", String.class));
        if (overlay == null) {
            return 0;
        }
        overlay.getConfigOptions().forEach(Config::reset);
        Managers.Config.saveConfig();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Successfully reset ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)featureName).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"'s config options.").withStyle(ChatFormatting.GREEN)), false);
        return 1;
    }

    private int listAllOverlayConfigs(CommandContext<CommandSourceStack> context) {
        String overlayName;
        String featureName = (String)context.getArgument("feature", String.class);
        Overlay overlay = ConfigCommand.getOverlayFromArguments(context, featureName, overlayName = (String)context.getArgument("overlay", String.class));
        if (overlay == null) {
            return 0;
        }
        MutableComponent response = Component.literal((String)overlayName).withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)"'s config options:\n").withStyle(ChatFormatting.WHITE));
        for (Config<?> config : overlay.getVisibleConfigOptions()) {
            MutableComponent current = this.getComponentForConfig(config);
            current.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/wynntils config set " + featureName + " overlay " + overlayName + " " + config.getFieldName() + " ")));
            response.append((Component)current);
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int getSpecificOverlayConfigOption(CommandContext<CommandSourceStack> context) {
        String configName;
        String overlayName;
        String featureName = (String)context.getArgument("feature", String.class);
        Config<?> config = ConfigCommand.getOverlayConfigFromArguments(context, featureName, overlayName = (String)context.getArgument("overlay", String.class), configName = (String)context.getArgument("config", String.class));
        if (config == null) {
            return 0;
        }
        String longParentName = Arrays.stream(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, overlayName).split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
        MutableComponent response = Component.literal((String)(longParentName + "\n")).withStyle(ChatFormatting.AQUA);
        response.append((Component)this.getSpecificConfigComponent(config));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int changeOverlayConfig(CommandContext<CommandSourceStack> context) {
        String featureName = (String)context.getArgument("feature", String.class);
        String overlayName = (String)context.getArgument("overlay", String.class);
        String configName = (String)context.getArgument("config", String.class);
        Config<?> config = ConfigCommand.getOverlayConfigFromArguments(context, featureName, overlayName, configName);
        return ConfigCommand.changeConfig(context, config);
    }

    private int getSpecificConfigOption(CommandContext<CommandSourceStack> context) {
        String configName;
        String featureName = (String)context.getArgument("feature", String.class);
        Config<?> config = ConfigCommand.getConfigFromArguments(context, featureName, configName = (String)context.getArgument("config", String.class));
        if (config == null) {
            return 0;
        }
        String longParentName = Arrays.stream(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, featureName).split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
        MutableComponent response = Component.literal((String)(longParentName + "\n")).withStyle(ChatFormatting.YELLOW);
        response.append((Component)this.getSpecificConfigComponent(config));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int listAllConfigOptions(CommandContext<CommandSourceStack> context) {
        MutableComponent current;
        String featureName = (String)context.getArgument("feature", String.class);
        Feature feature = ConfigCommand.getFeatureFromArguments(context, featureName);
        if (feature == null) {
            return 0;
        }
        MutableComponent response = Component.literal((String)featureName).withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)"'s config options:\n").withStyle(ChatFormatting.WHITE));
        for (Config<?> config : feature.getVisibleConfigOptions()) {
            current = this.getComponentForConfig(config);
            current.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/wynntils config set " + featureName + " " + config.getFieldName() + " ")));
            response.append((Component)current);
        }
        response.append("\n").append((Component)Component.literal((String)featureName).withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)"'s overlays:\n").withStyle(ChatFormatting.WHITE)));
        for (Overlay overlay : Managers.Overlay.getFeatureOverlays(feature)) {
            current = this.getComponentForOverlay(overlay);
            current.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/wynntils config set " + featureName + " overlay " + overlay.getShortName() + " ")));
            response.append((Component)current);
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int changeFeatureConfig(CommandContext<CommandSourceStack> context) {
        String featureName = (String)context.getArgument("feature", String.class);
        String configName = (String)context.getArgument("config", String.class);
        Config<?> config = ConfigCommand.getConfigFromArguments(context, featureName, configName);
        return ConfigCommand.changeConfig(context, config);
    }

    private static <T> int changeConfig(CommandContext<CommandSourceStack> context, Config<T> config) {
        if (config == null) {
            return 0;
        }
        String newValue = (String)context.getArgument("newValue", String.class);
        T parsedValue = config.tryParseStringValue(newValue);
        if (parsedValue == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Failed to parse the inputted value to the correct type!").withStyle(ChatFormatting.RED));
            return 0;
        }
        Object oldValue = config.get();
        String oldValueString = config.getValueString();
        if (Objects.equals(oldValue, parsedValue)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"The new value is the same as the current setting.").withStyle(ChatFormatting.RED));
            return 0;
        }
        config.setValue(parsedValue);
        String newValueString = config.getValueString();
        Managers.Config.saveConfig();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Successfully set ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)config.getDisplayName()).withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)" from ").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)oldValueString).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.RED)).append((Component)Component.literal((String)" to ").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)newValueString).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)".").withStyle(ChatFormatting.GREEN)), false);
        return 1;
    }

    private int resetFeatureConfigOption(CommandContext<CommandSourceStack> context) {
        String configName;
        String featureName = (String)context.getArgument("feature", String.class);
        Config<?> config = ConfigCommand.getConfigFromArguments(context, featureName, configName = (String)context.getArgument("config", String.class));
        if (config == null) {
            return 0;
        }
        config.reset();
        Managers.Config.saveConfig();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Successfully reset ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)config.getDisplayName()).withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)".").withStyle(ChatFormatting.GREEN)), false);
        return 1;
    }

    private int resetAllConfigOptions(CommandContext<CommandSourceStack> context) {
        String featureName = (String)context.getArgument("feature", String.class);
        Feature feature = ConfigCommand.getFeatureFromArguments(context, featureName);
        if (feature == null) {
            return 0;
        }
        feature.getVisibleConfigOptions().forEach(Config::reset);
        Managers.Config.saveConfig();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Successfully reset ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)featureName).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"'s config options.").withStyle(ChatFormatting.GREEN)), false);
        return 1;
    }

    private static Feature getFeatureFromArguments(CommandContext<CommandSourceStack> context, String featureName) {
        Optional<Feature> featureOptional = Managers.Feature.getFeatureFromString(featureName);
        if (featureOptional.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Feature not found!").withStyle(ChatFormatting.RED));
            return null;
        }
        return featureOptional.get();
    }

    private static Config<?> getConfigFromArguments(CommandContext<CommandSourceStack> context, String featureName, String configName) {
        Feature feature = ConfigCommand.getFeatureFromArguments(context, featureName);
        if (feature == null) {
            return null;
        }
        Optional<Config<?>> configOptional = feature.getConfigOptionFromString(configName);
        if (configOptional.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Config not found!").withStyle(ChatFormatting.RED));
            return null;
        }
        return configOptional.get();
    }

    private static Config<?> getOverlayConfigFromArguments(CommandContext<CommandSourceStack> context, String featureName, String overlayName, String configName) {
        Overlay overlay = ConfigCommand.getOverlayFromArguments(context, featureName, overlayName);
        if (overlay == null) {
            return null;
        }
        Optional<Config<?>> configOptional = overlay.getConfigOptionFromString(configName);
        if (configOptional.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Config not found!").withStyle(ChatFormatting.RED));
            return null;
        }
        return configOptional.get();
    }

    private static Overlay getOverlayFromArguments(CommandContext<CommandSourceStack> context, String featureName, String overlayName) {
        Feature feature = ConfigCommand.getFeatureFromArguments(context, featureName);
        if (feature == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Feature not found!").withStyle(ChatFormatting.RED));
            return null;
        }
        Optional<Overlay> overlayOptional = Managers.Overlay.getFeatureOverlays(feature).stream().filter(overlay -> overlay.getShortName().equals(overlayName)).findFirst();
        if (overlayOptional.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Overlay not found!").withStyle(ChatFormatting.RED));
            return null;
        }
        return overlayOptional.get();
    }

    private static OverlayGroupHolder getOverlayGroupHolderFromArguments(CommandContext<CommandSourceStack> context, String featureName, String overlayGroupName) {
        Feature feature = ConfigCommand.getFeatureFromArguments(context, featureName);
        if (feature == null) {
            return null;
        }
        Optional<OverlayGroupHolder> group = Managers.Overlay.getFeatureOverlayGroups(feature).stream().filter(overlayGroupHolder -> overlayGroupHolder.getFieldName().equalsIgnoreCase(overlayGroupName)).findFirst();
        if (group.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Overlay group not found!").withStyle(ChatFormatting.RED));
            return null;
        }
        return group.get();
    }

    private MutableComponent getComponentForConfig(Config<?> config) {
        String configNameString = config.getDisplayName();
        String configTypeString = " (" + ((Class)config.getType()).getSimpleName() + ")";
        String valueString = config.getValueString();
        return Component.literal((String)"\n - ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)configNameString).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Description: " + config.getDescription())).withStyle(ChatFormatting.LIGHT_PURPLE)))).withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)configTypeString).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)": ")).append((Component)Component.literal((String)valueString).withStyle(ChatFormatting.GREEN).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click here to change this setting."))))));
    }

    private MutableComponent getComponentForOverlay(Overlay overlay) {
        return Component.literal((String)"\n - ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)overlay.getShortName()).withStyle(ChatFormatting.AQUA));
    }

    private MutableComponent getSpecificConfigComponent(Config<?> config) {
        String valueString = config.getValueString();
        String configTypeString = "(" + ((Class)config.getType()).getSimpleName() + ")";
        MutableComponent response = Component.literal((String)"");
        response.append((Component)Component.literal((String)"Config option: ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)config.getDisplayName()).withStyle(ChatFormatting.YELLOW)).append("\n"));
        response.append((Component)Component.literal((String)"Value: ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)configTypeString)).append((Component)Component.literal((String)": ")).append((Component)Component.literal((String)valueString).withStyle(ChatFormatting.GREEN))).append("\n");
        response.append((Component)Component.literal((String)"Description: ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)config.getDescription()))).append("\n");
        return response;
    }

    private int syntaxError(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Missing argument").withStyle(ChatFormatting.RED));
        return 0;
    }
}

