/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.core.consumers.functions.Function;
import com.wynntils.core.consumers.functions.GenericFunction;
import com.wynntils.core.consumers.functions.arguments.Argument;
import com.wynntils.core.consumers.functions.arguments.FunctionArguments;
import com.wynntils.core.consumers.functions.arguments.ListArgument;
import com.wynntils.core.text.StyledText;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;

public class FunctionCommand
extends Command {
    private static final SuggestionProvider<CommandSourceStack> FUNCTION_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(Stream.concat(Managers.Function.getFunctions().stream().map(Function::getName), Managers.Function.getFunctions().stream().map(Function::getAliasList).flatMap(Collection::stream)), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> CRASHED_FUNCTION_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(Managers.Function.getFunctions().stream().filter(Managers.Function::isCrashed).map(Function::getName), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> FUNCTION_LIST_TYPES_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(Arrays.stream(ListType.values()).map(Enum::name).map(s -> s.toLowerCase(Locale.ROOT)).toList(), (SuggestionsBuilder)builder);
    private static final Integer LIST_PAGE_LIMIT = 15;

    @Override
    public String getCommandName() {
        return "function";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommandBuilder(LiteralArgumentBuilder<CommandSourceStack> base, CommandBuildContext context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").executes(this::listFunctions)).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::listFunctions))).then(((RequiredArgumentBuilder)Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests(FUNCTION_LIST_TYPES_SUGGESTION_PROVIDER).executes(this::listFunctions)).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::listFunctions))))).then(Commands.literal((String)"enable").then(Commands.argument((String)"function", (ArgumentType)StringArgumentType.word()).suggests(CRASHED_FUNCTION_SUGGESTION_PROVIDER).executes(this::enableFunction)))).then(Commands.literal((String)"get").then(((RequiredArgumentBuilder)Commands.argument((String)"function", (ArgumentType)StringArgumentType.word()).suggests(FUNCTION_SUGGESTION_PROVIDER).executes(this::getValue)).then(Commands.argument((String)"argument", (ArgumentType)StringArgumentType.greedyString()).executes(this::getValue))))).then(Commands.literal((String)"help").then(Commands.argument((String)"function", (ArgumentType)StringArgumentType.word()).suggests(FUNCTION_SUGGESTION_PROVIDER).executes(this::helpForFunction)))).then((CommandNode)((LiteralArgumentBuilder)Commands.literal((String)"test").then(Commands.argument((String)"template", (ArgumentType)StringArgumentType.greedyString()).executes(this::testExpression))).build())).executes(this::syntaxError);
    }

    private int testExpression(CommandContext<CommandSourceStack> context) {
        String template = (String)context.getArgument("template", String.class);
        StyledText[] result = Managers.Function.doFormatLines(template);
        StyledText resultString = StyledText.join(", ", result);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Template calculated: \"%s\u00a7r\" -> [%s\u00a7r]".formatted(template, resultString.getString())), false);
        return 1;
    }

    private int listFunctions(CommandContext<CommandSourceStack> context) {
        int page;
        String type;
        try {
            type = (String)context.getArgument("type", String.class);
        }
        catch (Exception e) {
            type = "all";
        }
        try {
            page = (Integer)context.getArgument("page", Integer.class);
        }
        catch (Exception e) {
            page = 1;
        }
        boolean all = type.equalsIgnoreCase("all");
        boolean onlyGeneric = type.equalsIgnoreCase("generic");
        boolean onlyNormal = type.equalsIgnoreCase("normal");
        List<Object> functions = Managers.Function.getFunctions().stream().filter(function -> all || onlyNormal && !(function instanceof GenericFunction) || onlyGeneric && function instanceof GenericFunction).sorted(Comparator.comparing(function -> function instanceof GenericFunction).thenComparing(o -> ((Function)o).getName())).toList();
        int totalPages = (int)Math.ceil((double)functions.size() / (double)LIST_PAGE_LIMIT.intValue());
        if (page > totalPages) {
            page = totalPages;
        }
        int fromIndex = (page - 1) * LIST_PAGE_LIMIT;
        List<Object> paginatedFunctions = functions.size() <= fromIndex ? functions : functions.subList(fromIndex, Math.min(fromIndex + LIST_PAGE_LIMIT, functions.size()));
        MutableComponent response = Component.literal((String)(onlyGeneric ? "Available generic functions: " : "Available functions:")).withStyle(ChatFormatting.AQUA);
        for (Function function2 : paginatedFunctions) {
            MutableComponent functionComponent = Component.literal((String)"\n - ").withStyle(ChatFormatting.GRAY);
            functionComponent.append((Component)Component.literal((String)function2.getName()).withStyle(function2 instanceof GenericFunction ? ChatFormatting.GOLD : ChatFormatting.YELLOW)).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/function help " + function2.getName())));
            if (!function2.getAliasList().isEmpty()) {
                String aliasList = String.join((CharSequence)", ", function2.getAliasList());
                functionComponent.append((Component)Component.literal((String)" [alias: ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)aliasList).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)"]").withStyle(ChatFormatting.GRAY));
            }
            functionComponent.withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)function2.getDescription()))));
            response.append((Component)functionComponent);
        }
        int previousPage = page == 1 ? totalPages : page - 1;
        int n = page == totalPages ? 1 : page + 1;
        String previousPageCommand = "/function list " + type + " " + previousPage;
        String nextPageCommand = "/function list " + type + " " + n;
        MutableComponent pageComponent = Component.literal((String)"\n").append((Component)Component.literal((String)"< Previous").withStyle(ChatFormatting.DARK_AQUA).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, previousPageCommand))).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Go to previous page"))))).append((Component)Component.literal((String)(" (" + page + "/" + totalPages + ") ")).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)"Next >").withStyle(ChatFormatting.DARK_AQUA).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, nextPageCommand))).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Go to next page")))));
        response.append((Component)pageComponent);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int enableFunction(CommandContext<CommandSourceStack> context) {
        String functionName = (String)context.getArgument("function", String.class);
        Optional<Function<?>> functionOptional = Managers.Function.forName(functionName);
        if (functionOptional.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Function not found!").withStyle(ChatFormatting.RED));
            return 0;
        }
        Function<?> function = functionOptional.get();
        if (!Managers.Function.isCrashed(function)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Function does not need to be enabled").withStyle(ChatFormatting.RED));
            return 0;
        }
        Managers.Function.enableFunction(function);
        MutableComponent response = Component.literal((String)function.getName()).withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)" is now enabled").withStyle(ChatFormatting.WHITE));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> FunctionCommand.lambda$enableFunction$15((Component)response), false);
        return 1;
    }

    private int getValue(CommandContext<CommandSourceStack> context) {
        MutableComponent argument;
        try {
            argument = Component.literal((String)StringArgumentType.getString(context, (String)"argument"));
        }
        catch (IllegalArgumentException e) {
            argument = Component.literal((String)"");
        }
        String functionName = (String)context.getArgument("function", String.class);
        Optional<Function<?>> functionOptional = Managers.Function.forName(functionName);
        if (functionOptional.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Function not found").withStyle(ChatFormatting.RED));
            return 0;
        }
        Function<?> function = functionOptional.get();
        MutableComponent result = Component.literal((String)"");
        result.append(Managers.Function.getSimpleValueString(function, argument.getString(), ChatFormatting.YELLOW, true));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> result, false);
        return 1;
    }

    private int helpForFunction(CommandContext<CommandSourceStack> context) {
        String functionName = (String)context.getArgument("function", String.class);
        Optional<Function<?>> functionOptional = Managers.Function.forName(functionName);
        if (functionOptional.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Function not found").withStyle(ChatFormatting.RED));
            return 0;
        }
        Function<?> function = functionOptional.get();
        MutableComponent helpComponent = Component.empty();
        boolean isArgumentOptional = function.getArgumentsBuilder() instanceof FunctionArguments.OptionalArgumentBuilder;
        helpComponent.append(String.valueOf(ChatFormatting.GRAY) + "Type: " + String.valueOf(ChatFormatting.WHITE) + (function instanceof GenericFunction ? "Generic" : "Normal") + "\n");
        helpComponent.append(String.valueOf(ChatFormatting.GRAY) + "Description: " + String.valueOf(ChatFormatting.WHITE) + function.getDescription() + "\n");
        helpComponent.append(String.valueOf(ChatFormatting.GRAY) + "Aliases:" + String.valueOf(ChatFormatting.WHITE) + " [" + String.join((CharSequence)", ", function.getAliasList()) + "]\n");
        helpComponent.append(String.valueOf(ChatFormatting.GRAY) + "Returns: " + String.valueOf(ChatFormatting.WHITE) + function.getReturnTypeName() + "\n");
        helpComponent.append(String.valueOf(ChatFormatting.GRAY) + "Arguments:" + String.valueOf(ChatFormatting.WHITE) + " (" + (isArgumentOptional ? "Optional" : "Required") + ")");
        for (Argument<?> argument : function.getArgumentsBuilder().getArguments()) {
            Object type = isArgumentOptional ? "(%s, default: %s)".formatted(argument.getType().getSimpleName(), argument.getDefaultValue().toString()) : (argument instanceof ListArgument ? "(List<" + argument.getType().getSimpleName() + ">)" : "(" + argument.getType().getSimpleName() + ")");
            String argumentDescription = "\n - " + String.valueOf(ChatFormatting.YELLOW) + argument.getName() + " " + (String)type + String.valueOf(ChatFormatting.WHITE) + ": " + function.getArgumentDescription(argument.getName());
            helpComponent.append(argumentDescription);
        }
        MutableComponent response = Component.literal((String)"Function Manual: ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)(function.getName() + "\n")).withStyle(ChatFormatting.BOLD)).append((Component)helpComponent.withStyle(ChatFormatting.WHITE));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> FunctionCommand.lambda$helpForFunction$17((Component)response), false);
        return 1;
    }

    private int syntaxError(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Missing argument").withStyle(ChatFormatting.RED));
        return 0;
    }

    private static /* synthetic */ Component lambda$helpForFunction$17(Component response) {
        return response;
    }

    private static /* synthetic */ Component lambda$enableFunction$15(Component response) {
        return response;
    }

    private static enum ListType {
        ALL,
        GENERIC,
        NORMAL;

    }
}

