/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.functions.expressions.parser;

import com.wynntils.core.consumers.functions.expressions.ConstantExpression;
import com.wynntils.core.consumers.functions.expressions.Expression;
import com.wynntils.core.consumers.functions.expressions.FunctionExpression;
import com.wynntils.utils.type.ErrorOr;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public final class ExpressionParser {
    private static final List<Function<String, ErrorOr<Optional<Expression>>>> registeredExpressions = List.of(FunctionExpression::tryParse, ConstantExpression::tryParse);

    private ExpressionParser() {
    }

    public static ErrorOr<Expression> tryParse(String rawExpression) {
        for (Function<String, ErrorOr<Optional<Expression>>> expression : registeredExpressions) {
            ErrorOr<Optional<Expression>> optionalExpression = expression.apply(rawExpression);
            if (optionalExpression.hasError()) {
                return ErrorOr.error(optionalExpression.getError());
            }
            if (!optionalExpression.getValue().isPresent()) continue;
            return ErrorOr.of(optionalExpression.getValue().get());
        }
        return ErrorOr.error("Could not parse expression: \"" + rawExpression + "\"");
    }
}

