/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.overlays;

import com.wynntils.core.consumers.overlays.Corner;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.utils.type.Pair;
import net.minecraft.world.phys.Vec2;

public enum Edge {
    TOP(Corner.TOP_LEFT, Corner.TOP_RIGHT),
    LEFT(Corner.TOP_LEFT, Corner.BOTTOM_LEFT),
    RIGHT(Corner.TOP_RIGHT, Corner.BOTTOM_RIGHT),
    BOTTOM(Corner.BOTTOM_LEFT, Corner.BOTTOM_RIGHT);

    private final Corner cornerA;
    private final Corner cornerB;

    private Edge(Corner a, Corner b) {
        this.cornerA = a;
        this.cornerB = b;
    }

    public Corner getCornerA() {
        return this.cornerA;
    }

    public Corner getCornerB() {
        return this.cornerB;
    }

    public boolean isVerticalLine() {
        return this == LEFT || this == RIGHT;
    }

    public Pair<Vec2, Vec2> getEdgePos(Overlay overlay) {
        return new Pair<Vec2, Vec2>(overlay.getCornerPoints(this.cornerA), overlay.getCornerPoints(this.cornerB));
    }
}

