/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.text;

import com.wynntils.core.text.StyledTextPart;
import com.wynntils.utils.colors.CustomColor;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;

public final class PartStyle {
    private static final String STYLE_PREFIX = "\u00a7";
    private static final Int2ObjectMap<ChatFormatting> INTEGER_TO_CHATFORMATTING_MAP = (Int2ObjectMap)Arrays.stream(ChatFormatting.values()).filter(ChatFormatting::isColor).collect(() -> new Int2ObjectOpenHashMap(ChatFormatting.values().length), (map, cf) -> map.put(cf.getColor() | 0xFF000000, cf), Map::putAll);
    private final StyledTextPart owner;
    private final CustomColor color;
    private final CustomColor shadowColor;
    private final boolean obfuscated;
    private final boolean bold;
    private final boolean strikethrough;
    private final boolean underlined;
    private final boolean italic;
    private final ClickEvent clickEvent;
    private final HoverEvent hoverEvent;
    private final ResourceLocation font;

    private PartStyle(StyledTextPart owner, CustomColor color, CustomColor shadowColor, boolean obfuscated, boolean bold, boolean strikethrough, boolean underlined, boolean italic, ClickEvent clickEvent, HoverEvent hoverEvent, ResourceLocation font) {
        this.owner = owner;
        this.color = color;
        this.shadowColor = shadowColor;
        this.obfuscated = obfuscated;
        this.bold = bold;
        this.strikethrough = strikethrough;
        this.underlined = underlined;
        this.italic = italic;
        this.clickEvent = clickEvent;
        this.hoverEvent = hoverEvent;
        this.font = font;
    }

    PartStyle(PartStyle partStyle, StyledTextPart owner) {
        this.owner = owner;
        this.color = partStyle.color;
        this.shadowColor = partStyle.shadowColor;
        this.obfuscated = partStyle.obfuscated;
        this.bold = partStyle.bold;
        this.strikethrough = partStyle.strikethrough;
        this.underlined = partStyle.underlined;
        this.italic = partStyle.italic;
        this.clickEvent = partStyle.clickEvent;
        this.hoverEvent = partStyle.hoverEvent;
        this.font = partStyle.font;
    }

    static PartStyle fromStyle(Style style, StyledTextPart owner, Style parentStyle) {
        Style inheritedStyle = parentStyle == null ? style : style.applyTo(parentStyle);
        return new PartStyle(owner, inheritedStyle.getColor() == null ? CustomColor.NONE : CustomColor.fromInt(inheritedStyle.getColor().getValue() | 0xFF000000), inheritedStyle.getShadowColor() == null ? CustomColor.NONE : CustomColor.fromInt(inheritedStyle.getShadowColor() | 0xFF000000), inheritedStyle.isObfuscated(), inheritedStyle.isBold(), inheritedStyle.isStrikethrough(), inheritedStyle.isUnderlined(), inheritedStyle.isItalic(), inheritedStyle.getClickEvent(), inheritedStyle.getHoverEvent(), inheritedStyle.getFont());
    }

    public String asString(PartStyle previousStyle, StyleType type) {
        if (type == StyleType.NONE) {
            return "";
        }
        StringBuilder styleString = new StringBuilder();
        boolean skipFormatting = false;
        if (previousStyle != null && (this.color == CustomColor.NONE || previousStyle.color.equals(this.color))) {
            String differenceString = this.tryConstructDifference(previousStyle, type == StyleType.INCLUDE_EVENTS);
            if (differenceString != null) {
                styleString.append(differenceString);
                skipFormatting = true;
            } else {
                styleString.append(STYLE_PREFIX).append(ChatFormatting.RESET.getChar());
            }
        }
        if (!skipFormatting) {
            if (this.color != CustomColor.NONE) {
                ChatFormatting chatFormatting = (ChatFormatting)INTEGER_TO_CHATFORMATTING_MAP.get(this.color.asInt());
                if (chatFormatting != null) {
                    styleString.append(STYLE_PREFIX).append(chatFormatting.getChar());
                } else {
                    styleString.append(STYLE_PREFIX).append(this.color.toHexString());
                }
            }
            if (this.obfuscated) {
                styleString.append(STYLE_PREFIX).append(ChatFormatting.OBFUSCATED.getChar());
            }
            if (this.bold) {
                styleString.append(STYLE_PREFIX).append(ChatFormatting.BOLD.getChar());
            }
            if (this.strikethrough) {
                styleString.append(STYLE_PREFIX).append(ChatFormatting.STRIKETHROUGH.getChar());
            }
            if (this.underlined) {
                styleString.append(STYLE_PREFIX).append(ChatFormatting.UNDERLINE.getChar());
            }
            if (this.italic) {
                styleString.append(STYLE_PREFIX).append(ChatFormatting.ITALIC.getChar());
            }
            if (type == StyleType.INCLUDE_EVENTS) {
                if (this.clickEvent != null) {
                    styleString.append(STYLE_PREFIX).append("[").append(this.owner.getParent().getClickEventIndex(this.clickEvent)).append("]");
                }
                if (this.hoverEvent != null) {
                    styleString.append(STYLE_PREFIX).append("<").append(this.owner.getParent().getHoverEventIndex(this.hoverEvent)).append(">");
                }
            }
        }
        return styleString.toString();
    }

    public Style getStyle() {
        TextColor textColor = this.color == CustomColor.NONE ? null : TextColor.fromRgb((int)(this.color.asInt() & 0xFFFFFF));
        Integer shadowColorInt = this.shadowColor == CustomColor.NONE ? null : Integer.valueOf(this.shadowColor.asInt() & 0xFFFFFF);
        return new Style(textColor, shadowColorInt, Boolean.valueOf(this.bold), Boolean.valueOf(this.italic), Boolean.valueOf(this.underlined), Boolean.valueOf(this.strikethrough), Boolean.valueOf(this.obfuscated), this.clickEvent, this.hoverEvent, null, this.font);
    }

    public PartStyle withColor(ChatFormatting color) {
        if (!color.isColor()) {
            throw new IllegalArgumentException("ChatFormatting " + String.valueOf(color) + " is not a color!");
        }
        CustomColor newColor = CustomColor.fromInt(color.getColor() | 0xFF000000);
        return new PartStyle(this.owner, newColor, this.shadowColor, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.font);
    }

    public PartStyle withColor(CustomColor color) {
        return new PartStyle(this.owner, color, this.shadowColor, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.font);
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isObfuscated() {
        return this.obfuscated;
    }

    public boolean isStrikethrough() {
        return this.strikethrough;
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public ClickEvent getClickEvent() {
        return this.clickEvent;
    }

    public HoverEvent getHoverEvent() {
        return this.hoverEvent;
    }

    public CustomColor getColor() {
        return this.color;
    }

    public CustomColor getShadowColor() {
        return this.shadowColor;
    }

    public ResourceLocation getFont() {
        return this.font;
    }

    public PartStyle withShadowColor(CustomColor shadowColor) {
        return new PartStyle(this.owner, this.color, shadowColor, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.font);
    }

    public PartStyle withBold(boolean bold) {
        return new PartStyle(this.owner, this.color, this.shadowColor, this.obfuscated, bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.font);
    }

    public PartStyle withObfuscated(boolean obfuscated) {
        return new PartStyle(this.owner, this.color, this.shadowColor, obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.font);
    }

    public PartStyle withStrikethrough(boolean strikethrough) {
        return new PartStyle(this.owner, this.color, this.shadowColor, this.obfuscated, this.bold, strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.font);
    }

    public PartStyle withUnderlined(boolean underlined) {
        return new PartStyle(this.owner, this.color, this.shadowColor, this.obfuscated, this.bold, this.strikethrough, underlined, this.italic, this.clickEvent, this.hoverEvent, this.font);
    }

    public PartStyle withItalic(boolean italic) {
        return new PartStyle(this.owner, this.color, this.shadowColor, this.obfuscated, this.bold, this.strikethrough, this.underlined, italic, this.clickEvent, this.hoverEvent, this.font);
    }

    public PartStyle withClickEvent(ClickEvent clickEvent) {
        return new PartStyle(this.owner, this.color, this.shadowColor, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, clickEvent, this.hoverEvent, this.font);
    }

    public PartStyle withHoverEvent(HoverEvent hoverEvent) {
        return new PartStyle(this.owner, this.color, this.shadowColor, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, hoverEvent, this.font);
    }

    public PartStyle withFont(ResourceLocation font) {
        return new PartStyle(this.owner, this.color, this.shadowColor, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, font);
    }

    private String tryConstructDifference(PartStyle oldStyle, boolean includeEvents) {
        StringBuilder add = new StringBuilder();
        int oldColorInt = oldStyle.color.asInt();
        int newColorInt = this.color.asInt();
        if (oldColorInt == -1) {
            if (newColorInt != -1) {
                Arrays.stream(ChatFormatting.values()).filter(c -> c.isColor() && newColorInt == (c.getColor() | 0xFF000000)).findFirst().ifPresent(add::append);
            }
        } else if (oldColorInt != newColorInt) {
            return null;
        }
        if (oldStyle.obfuscated && !this.obfuscated) {
            return null;
        }
        if (!oldStyle.obfuscated && this.obfuscated) {
            add.append(ChatFormatting.OBFUSCATED);
        }
        if (oldStyle.bold && !this.bold) {
            return null;
        }
        if (!oldStyle.bold && this.bold) {
            add.append(ChatFormatting.BOLD);
        }
        if (oldStyle.strikethrough && !this.strikethrough) {
            return null;
        }
        if (!oldStyle.strikethrough && this.strikethrough) {
            add.append(ChatFormatting.STRIKETHROUGH);
        }
        if (oldStyle.underlined && !this.underlined) {
            return null;
        }
        if (!oldStyle.underlined && this.underlined) {
            add.append(ChatFormatting.UNDERLINE);
        }
        if (oldStyle.italic && !this.italic) {
            return null;
        }
        if (!oldStyle.italic && this.italic) {
            add.append(ChatFormatting.ITALIC);
        }
        if (includeEvents) {
            if (oldStyle.clickEvent != null && this.clickEvent == null) {
                return null;
            }
            if (oldStyle.clickEvent != this.clickEvent) {
                add.append(STYLE_PREFIX).append("[").append(this.owner.getParent().getClickEventIndex(this.clickEvent)).append("]");
            }
            if (oldStyle.hoverEvent != null && this.hoverEvent == null) {
                return null;
            }
            if (oldStyle.hoverEvent != this.hoverEvent) {
                add.append(STYLE_PREFIX).append("<").append(this.owner.getParent().getHoverEventIndex(this.hoverEvent)).append(">");
            }
        }
        return add.toString();
    }

    public String toString() {
        return "PartStyle{color=" + String.valueOf(this.color) + ", obfuscated=" + this.obfuscated + ", bold=" + this.bold + ", strikethrough=" + this.strikethrough + ", underlined=" + this.underlined + ", italic=" + this.italic + ", clickEvent=" + String.valueOf(this.clickEvent) + ", hoverEvent=" + String.valueOf(this.hoverEvent) + ", font=" + String.valueOf(this.font) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartStyle partStyle = (PartStyle)o;
        return this.obfuscated == partStyle.obfuscated && this.bold == partStyle.bold && this.strikethrough == partStyle.strikethrough && this.underlined == partStyle.underlined && this.italic == partStyle.italic && Objects.equals(this.color, partStyle.color) && Objects.equals(this.clickEvent, partStyle.clickEvent) && Objects.equals(this.hoverEvent, partStyle.hoverEvent) && Objects.equals(this.font, partStyle.font);
    }

    public int hashCode() {
        return Objects.hash(this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.font);
    }

    public static enum StyleType {
        INCLUDE_EVENTS,
        DEFAULT,
        NONE;

    }
}

