/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.PartStyle;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.InventoryMouseClickedEvent;
import com.wynntils.mc.event.SoundPlayedEvent;
import com.wynntils.models.territories.type.GuildResourceValues;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.mc.McUtils;
import java.util.LinkedList;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UNCATEGORIZED)
public class TerritoryDefenseMessageFeature
extends Feature {
    private static final Pattern ATTACK_SCREEN_TITLE = Pattern.compile("Attacking: (.+)");
    private static final Pattern TERRITORY_DEFENSE_PATTERN = Pattern.compile("Territory Defences: (.+)");
    private static final String DEFENSE_MESSAGE = "g %s defense is %s";
    private static final ResourceLocation ATTACK_SOUND = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"entity.ender_dragon.growl");
    private static final long MESSAGE_TIMEOUT = 2000L;
    private final Queue<QueuedTerritory> queuedTerritories = new LinkedList<QueuedTerritory>();

    @SubscribeEvent
    public void onInventoryClick(InventoryMouseClickedEvent event) {
        if (event.getHoveredSlot() == null || McUtils.mc().screen == null) {
            return;
        }
        Matcher titleMatcher = ATTACK_SCREEN_TITLE.matcher(McUtils.mc().screen.getTitle().getString());
        if (!titleMatcher.matches()) {
            return;
        }
        ItemStack itemStack = event.getHoveredSlot().getItem();
        for (Component tooltipLine : LoreUtils.getTooltipLines(itemStack)) {
            Matcher matcher = StyledText.fromComponent(tooltipLine).getMatcher(TERRITORY_DEFENSE_PATTERN, PartStyle.StyleType.NONE);
            if (!matcher.matches()) continue;
            this.queuedTerritories.add(new QueuedTerritory(titleMatcher.group(1), System.currentTimeMillis(), GuildResourceValues.fromString(matcher.group(1))));
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttackSound(SoundPlayedEvent event) {
        if (this.queuedTerritories.isEmpty() || !event.getSoundInstance().getLocation().equals((Object)ATTACK_SOUND)) {
            return;
        }
        while (!this.queuedTerritories.isEmpty()) {
            QueuedTerritory queuedTerritory = this.queuedTerritories.poll();
            if (System.currentTimeMillis() - queuedTerritory.timestamp() >= 2000L) continue;
            Handlers.Command.sendCommandImmediately(DEFENSE_MESSAGE.formatted(queuedTerritory.territory(), queuedTerritory.defense().getAsString()));
            break;
        }
    }

    private record QueuedTerritory(String territory, long timestamp, GuildResourceValues defense) {
    }
}

