/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.chat;

import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.AddGuiMessageLineEvent;
import com.wynntils.mc.event.ChatComponentRenderEvent;
import com.wynntils.mc.extension.GuiMessageExtension;
import com.wynntils.mc.extension.GuiMessageLineExtension;
import com.wynntils.mc.mixin.accessors.ChatComponentAccessor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.Pair;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.SubscribeEvent;

@StartDisabled
@ConfigCategory(value=Category.CHAT)
public class ChatTimestampFeature
extends Feature {
    @Persisted
    private final Config<String> formatPattern = new Config<String>("HH:mm:ss");
    private DateTimeFormatter formatter = DateTimeFormatter.ofPattern((String)this.formatPattern.get(), Locale.ROOT);
    private int timestampWidth = 0;

    @Override
    protected void onConfigUpdate(Config<?> config) {
        try {
            this.formatter = DateTimeFormatter.ofPattern((String)this.formatPattern.get(), Locale.ROOT);
        }
        catch (Exception e) {
            this.formatter = null;
            McUtils.sendErrorToClient(I18n.get((String)"feature.wynntils.chatTimestamp.invalidFormatMsg", (Object[])new Object[0]));
        }
    }

    @SubscribeEvent
    public void onGuiMessageLineAdd(AddGuiMessageLineEvent event) {
        GuiMessageExtension messageExtension = (GuiMessageExtension)event.getMessage();
        ((GuiMessageLineExtension)event.getLine()).setCreated(messageExtension.getCreated());
        if (event.getIndex() != 0 || this.formatter == null) {
            return;
        }
        GuiMessageLineExtension extension = (GuiMessageLineExtension)event.getLine();
        extension.setTimestamp((Component)Component.empty().append((Component)Component.literal((String)"[").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)extension.getCreated().format(this.formatter)).withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"] ").withStyle(ChatFormatting.DARK_GRAY)));
    }

    @SubscribeEvent
    public void onChatComponentRenderPre(ChatComponentRenderEvent.Pre event) {
        this.timestampWidth = 0;
        for (GuiMessage.Line line : ((ChatComponentAccessor)event.getChatComponent()).getTrimmedMessages()) {
            GuiMessageLineExtension extension = (GuiMessageLineExtension)line;
            Optional<Pair<Component, Integer>> timestamp = extension.getTimestamp();
            if (timestamp.isEmpty()) continue;
            this.timestampWidth = Math.max(this.timestampWidth, timestamp.get().b());
        }
    }

    @SubscribeEvent
    public void onChatComponentTranslate(ChatComponentRenderEvent.Translate event) {
        if (this.timestampWidth != 0) {
            event.setX(event.getX() + 4.0f + (float)this.timestampWidth);
        }
    }

    @SubscribeEvent
    public void onChatComponentMapMouseX(ChatComponentRenderEvent.MapMouseX event) {
        if (this.timestampWidth != 0) {
            event.setX(event.getX() - (double)(4 + this.timestampWidth));
        }
    }

    @SubscribeEvent
    public void onChatComponentRenderBackground(ChatComponentRenderEvent.Background event) {
        if (this.timestampWidth == 0) {
            return;
        }
        event.getGuiGraphics().pose().pushPose();
        event.getGuiGraphics().pose().translate((float)(-(this.timestampWidth + 4)), 0.0f, 0.0f);
        event.getGuiGraphics().fill(-2, event.getRenderX() - event.getLineHeight(), this.timestampWidth - 2, event.getRenderX(), event.getOpacity() << 24);
        event.getGuiGraphics().pose().popPose();
    }

    @SubscribeEvent
    public void onnChatComponentRenderText(ChatComponentRenderEvent.Text event) {
        if (this.timestampWidth == 0) {
            return;
        }
        GuiMessageLineExtension extension = (GuiMessageLineExtension)event.getLine();
        if (extension.getTimestamp().isEmpty()) {
            return;
        }
        event.getGuiGraphics().pose().pushPose();
        event.getGuiGraphics().pose().translate(-((float)extension.getTimestamp().get().b().intValue() + 4.0f), 0.0f, 0.0f);
        event.getGuiGraphics().drawString(event.getFont(), extension.getTimestamp().get().a(), 0, event.getRenderY(), 0xFFFFFF + (event.getTextOpacity() << 24));
        event.getGuiGraphics().pose().popPose();
    }
}

