/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.chat;

import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.handlers.chat.type.MessageType;
import com.wynntils.utils.mc.StyledTextUtils;
import com.wynntils.utils.type.Pair;
import java.util.List;
import java.util.regex.Pattern;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.CHAT)
public class MessageFilterFeature
extends Feature {
    private static final List<Pair<Pattern, Pattern>> WELCOME = List.of(Pair.of(Pattern.compile("^\u00a77Loading Resource Pack\\.\\.\\.$"), null), Pair.of(Pattern.compile("^\u00a76Thank you for using the WynnPack\\. Enjoy the game!$"), null), Pair.of(Pattern.compile("^\u00a7cSelect a character! Each character is saved individually across all servers, you can come back at any time with /class and select another character!$"), null), Pair.of(Pattern.compile("^ +\u00a76\u00a7lWelcome to Wynncraft!$"), null), Pair.of(Pattern.compile("^ +\u00a7fplay\\.wynncraft\\.com \u00a77-/-\u00a7f wynncraft\\.com$"), null));
    private static final Pattern SYSTEM_INFO_FG = Pattern.compile("^\u00a7#a0aec0ff(\ue01b\ue002|\ue001) .+$", 32);
    private static final Pattern SYSTEM_INFO_BG = Pattern.compile("^\u00a7#c0c0c0ff(\ue01b\ue002|\ue001) .+$", 32);
    private static final List<Pair<Pattern, Pattern>> SYSTEM_INFO = List.of(Pair.of(SYSTEM_INFO_FG, SYSTEM_INFO_BG));
    private static final List<Pair<Pattern, Pattern>> LEVEL_UP = List.of(Pair.of(Pattern.compile("^\u00a76.* is now (?:combat )?level .*(?: in \u00a7.*)?$"), Pattern.compile("^(?:\u00a78)?.* is now (?:combat )?level .*(?: in \u00a7.*)?$")), Pair.of(Pattern.compile("^\u00a78\\[\u00a77!\u00a78\\] \u00a77Congratulations to (\u00a7r)?.* for reaching (combat )?\u00a7flevel .*!$"), Pattern.compile("^(\u00a78)?\\[!\\] Congratulations to (\u00a7r)?.* for reaching (combat )?\u00a77level .*!$")));
    private static final Pattern PARTY_FINDER_FG = Pattern.compile("^\u00a75(\ue00a\ue002|\ue001) Party Finder:\u00a7d Hey (\u00a7o)?[\\w ]{1,20}(\u00a7r\u00a7d)?, over here! Join the \u00a7?[a-zA-Z0-9#' ]+\u00a7d queue and match up with \u00a7e\\d{1,2}\u00a7d other players?!$");
    private static final Pattern PARTY_FINDER_BG = Pattern.compile("^\u00a78(\ue00a\ue002|\ue001) Party Finder: Hey (\u00a7o)?[\\w ]{1,20}(\u00a7r\u00a78)?, over here! Join the [a-zA-Z' ]+ queue and match up with \\d{1,2} other players?!$");
    private static final List<Pair<Pattern, Pattern>> PARTY_FINDER = List.of(Pair.of(PARTY_FINDER_FG, PARTY_FINDER_BG));
    @Persisted
    private final Config<Boolean> hideWelcome = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> hideSystemInfo = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> hideLevelUp = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> hidePartyFinder = new Config<Boolean>(false);

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMessage(ChatMessageEvent.Match e) {
        StyledText msg = e.getMessage();
        MessageType messageType = e.getMessageType();
        if (((Boolean)this.hideWelcome.get()).booleanValue() && this.processFilter(msg, messageType, WELCOME)) {
            e.setCanceled(true);
            return;
        }
        if (((Boolean)this.hideLevelUp.get()).booleanValue() && this.processFilter(msg, messageType, LEVEL_UP)) {
            e.setCanceled(true);
            return;
        }
        StyledText unwrapped = StyledTextUtils.unwrap(msg).stripAlignment();
        if (((Boolean)this.hideSystemInfo.get()).booleanValue() && this.processFilter(unwrapped, messageType, SYSTEM_INFO)) {
            e.setCanceled(true);
            return;
        }
        if (((Boolean)this.hidePartyFinder.get()).booleanValue() && this.processFilter(unwrapped, messageType, PARTY_FINDER)) {
            e.setCanceled(true);
            return;
        }
    }

    private boolean processFilter(StyledText msg, MessageType messageType, List<Pair<Pattern, Pattern>> patternMap) {
        for (Pair<Pattern, Pattern> pair : patternMap) {
            Pattern pattern = this.getPattern(pair, messageType);
            if (pattern == null || !msg.getMatcher(pattern).find()) continue;
            return true;
        }
        return false;
    }

    private Pattern getPattern(Pair<Pattern, Pattern> p, MessageType messageType) {
        return switch (messageType) {
            default -> throw new MatchException(null, null);
            case MessageType.FOREGROUND -> p.a();
            case MessageType.BACKGROUND -> p.b();
        };
    }
}

