/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.combat;

import com.mojang.blaze3d.platform.InputConstants;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.KeyMappingEvent;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.wynn.InventoryUtils;
import com.wynntils.utils.wynn.ItemUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;
import net.neoforged.bus.api.SubscribeEvent;

@StartDisabled
@ConfigCategory(value=Category.COMBAT)
public class InvertAttackKeybindsFeature
extends Feature {
    @Persisted
    private final Config<Boolean> invertWarrior = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> invertArcher = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> invertAssassin = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> invertMage = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> invertShaman = new Config<Boolean>(false);
    private final Map<InputConstants.Key, InputConstants.Key> activeRemappings = new HashMap<InputConstants.Key, InputConstants.Key>();

    @SubscribeEvent
    public void onKeyMappingOperation(KeyMappingEvent event) {
        switch (event.getOperation()) {
            case SET: {
                InputConstants.Key target = this.remapKey(event.getKey());
                if (target == null) break;
                event.setCanceled(true);
                KeyMapping.set((InputConstants.Key)target, (boolean)true);
                this.activeRemappings.put(event.getKey(), target);
                break;
            }
            case UNSET: {
                InputConstants.Key target = this.activeRemappings.remove(event.getKey());
                if (target == null) break;
                event.setCanceled(true);
                KeyMapping.set((InputConstants.Key)target, (boolean)false);
                break;
            }
            case CLICK: {
                InputConstants.Key target = this.activeRemappings.get(event.getKey());
                if (target == null) break;
                event.setCanceled(true);
                KeyMapping.click((InputConstants.Key)target);
            }
        }
    }

    private boolean isInvertingForClass(ClassType classType) {
        return switch (Models.Character.getClassType()) {
            case ClassType.MAGE -> (Boolean)this.invertMage.get();
            case ClassType.ARCHER -> (Boolean)this.invertArcher.get();
            case ClassType.WARRIOR -> (Boolean)this.invertWarrior.get();
            case ClassType.ASSASSIN -> (Boolean)this.invertAssassin.get();
            case ClassType.SHAMAN -> (Boolean)this.invertShaman.get();
            default -> false;
        };
    }

    private InputConstants.Key remapKey(InputConstants.Key key) {
        KeyMapping target;
        Options options = McUtils.options();
        if (key.equals((Object)options.keyAttack.key)) {
            target = options.keyUse;
        } else if (key.equals((Object)options.keyUse.key)) {
            target = options.keyAttack;
        } else {
            return null;
        }
        if (!this.isInvertingForClass(Models.Character.getClassType())) {
            return null;
        }
        if (!ItemUtils.isWeapon(InventoryUtils.getItemInHand())) {
            return null;
        }
        return target.key;
    }
}

