/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.persisted.config.HiddenConfig;
import com.wynntils.mc.event.CommandSentEvent;
import com.wynntils.mc.event.CommandsAddedEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.COMMANDS)
public class CommandAliasesFeature
extends Feature {
    @Persisted
    private final HiddenConfig<List<CommandAlias>> aliases = new HiddenConfig<ArrayList<CommandAlias>>(new ArrayList<CommandAlias>(List.of(new CommandAlias("guild attack", List.of("gu a", "guild a")), new CommandAlias("guild manage", List.of("gu m", "gu man", "guild m", "guild man")), new CommandAlias("guild territory", List.of("gu t", "gu terr", "guild t", "guild terr")), new CommandAlias("partyfinder", List.of("pf")))));

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onCommandSent(CommandSentEvent e) {
        String message = e.getCommand();
        for (CommandAlias commandAlias : (List)this.aliases.get()) {
            if (!commandAlias.aliases().stream().anyMatch(alias -> Objects.equals(alias, message))) continue;
            e.setCanceled(true);
            Handlers.Command.sendCommandImmediately(commandAlias.originalCommand());
            break;
        }
    }

    @SubscribeEvent
    public void onCommandsAdded(CommandsAddedEvent event) {
        RootCommandNode<SharedSuggestionProvider> root = event.getRoot();
        for (CommandAlias commandAlias : (List)this.aliases.get()) {
            for (String alias : commandAlias.aliases()) {
                String[] parts = alias.split(" ");
                LiteralArgumentBuilder builder = Commands.literal((String)parts[0]);
                for (int i = 1; i < parts.length; ++i) {
                    builder.then((ArgumentBuilder)Commands.literal((String)parts[i]));
                }
                Managers.Command.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)builder.build());
            }
        }
    }

    private record CommandAlias(String originalCommand, List<String> aliases) {
    }
}

