/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.inventory;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.models.items.items.game.EmeraldPouchItem;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.TextRenderSetting;
import com.wynntils.utils.render.TextRenderTask;
import com.wynntils.utils.wynn.InventoryUtils;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

@ConfigCategory(value=Category.INVENTORY)
public class EmeraldPouchHotkeyFeature
extends Feature {
    private static final int NO_POUCHES = -1;
    private static final int MULTIPLE_POUCHES = -2;
    @RegisterKeyBind
    private final KeyBind emeraldPouchKeyBind = new KeyBind("Open Emerald Pouch", -1, true, this::onOpenPouchKeyPress);

    private void onOpenPouchKeyPress() {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        int slotNumber = this.getEmeraldPouchSlot();
        if (slotNumber == -1) {
            Managers.Notification.queueMessage(new TextRenderTask(String.valueOf(ChatFormatting.RED) + I18n.get((String)"feature.wynntils.emeraldPouchHotkey.noPouch", (Object[])new Object[0]), TextRenderSetting.DEFAULT.withCustomColor(CommonColors.RED)));
            return;
        }
        if (slotNumber == -2) {
            Managers.Notification.queueMessage(new TextRenderTask(String.valueOf(ChatFormatting.RED) + I18n.get((String)"feature.wynntils.emeraldPouchHotkey.multipleFilled", (Object[])new Object[0]), TextRenderSetting.DEFAULT.withCustomColor(CommonColors.RED)));
            return;
        }
        if (slotNumber < 9) {
            slotNumber += 36;
        }
        InventoryUtils.sendInventorySlotMouseClick(slotNumber, InventoryUtils.MouseClickType.RIGHT_CLICK);
    }

    private int getEmeraldPouchSlot() {
        int bestEmptyTier = -1;
        int bestEmptySlot = -1;
        int foundNonEmptySlot = -1;
        Inventory inventory = McUtils.inventory();
        for (int slot = 0; slot < inventory.getContainerSize(); ++slot) {
            ItemStack itemStack = inventory.getItem(slot);
            Optional<EmeraldPouchItem> optPouchItem = Models.Item.asWynnItem(itemStack, EmeraldPouchItem.class);
            if (optPouchItem.isEmpty()) continue;
            EmeraldPouchItem pouchItem = optPouchItem.get();
            if (pouchItem.getValue() == 0) {
                int tier = pouchItem.getTier();
                if (tier <= bestEmptyTier) continue;
                bestEmptySlot = slot;
                bestEmptyTier = tier;
                continue;
            }
            if (foundNonEmptySlot != -1) {
                return -2;
            }
            foundNonEmptySlot = slot;
        }
        if (foundNonEmptySlot == -1 && bestEmptySlot == -1) {
            return -1;
        }
        if (foundNonEmptySlot != -1) {
            return foundNonEmptySlot;
        }
        return bestEmptySlot;
    }
}

