/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.inventory;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.HotbarSlotRenderEvent;
import com.wynntils.mc.event.ItemCountOverlayRenderEvent;
import com.wynntils.mc.event.SlotRenderEvent;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.properties.CountedItemProperty;
import com.wynntils.models.items.properties.LeveledItemProperty;
import com.wynntils.models.items.properties.UsesItemProperty;
import com.wynntils.utils.mc.KeyboardUtils;
import java.util.Optional;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.INVENTORY)
public class ExtendedItemCountFeature
extends Feature {
    @Persisted
    private final Config<Boolean> inventoryTextOverlayEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> hotbarTextOverlayEnabled = new Config<Boolean>(true);
    private boolean isInventory;

    @SubscribeEvent
    public void onRenderSlotPre(SlotRenderEvent.Pre e) {
        this.isInventory = true;
    }

    @SubscribeEvent
    public void onRenderHotbarSlotPre(HotbarSlotRenderEvent.Pre e) {
        this.isInventory = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public void onItemCountOverlay(ItemCountOverlayRenderEvent event) {
        UsesItemProperty usesItem;
        if (this.isInventory && !((Boolean)this.inventoryTextOverlayEnabled.get()).booleanValue()) {
            return;
        }
        if (!this.isInventory && !((Boolean)this.hotbarTextOverlayEnabled.get()).booleanValue()) {
            return;
        }
        Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem(event.getItemStack());
        if (wynnItemOpt.isEmpty()) {
            return;
        }
        WynnItem wynnItem = wynnItemOpt.get();
        if (wynnItem instanceof LeveledItemProperty) {
            LeveledItemProperty leveledItem = (LeveledItemProperty)((Object)wynnItem);
            if (KeyboardUtils.isKeyDown(341) && this.isInventory) {
                event.setCountString(String.valueOf(leveledItem.getLevel()));
                return;
            }
        }
        if (wynnItem instanceof UsesItemProperty && (usesItem = (UsesItemProperty)((Object)wynnItem)).hasCount()) {
            event.setCountString(String.valueOf(usesItem.getCount() * event.getItemStack().getCount()));
            event.setCountColor(usesItem.getCountColor().asInt());
            return;
        }
        if (!(wynnItem instanceof CountedItemProperty)) return;
        CountedItemProperty countedItem = (CountedItemProperty)((Object)wynnItem);
        if (!countedItem.hasCount()) return;
        event.setCountString(String.valueOf(countedItem.getCount()));
        event.setCountColor(countedItem.getCountColor().asInt());
    }
}

