/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.inventory;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.persisted.config.HiddenConfig;
import com.wynntils.mc.event.ContainerClickEvent;
import com.wynntils.mc.event.ContainerRenderEvent;
import com.wynntils.mc.event.DropHeldItemEvent;
import com.wynntils.models.containers.type.FullscreenContainerProperty;
import com.wynntils.models.items.items.game.MultiHealthPotionItem;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.INVENTORY)
public class ItemLockFeature
extends Feature {
    @RegisterKeyBind
    private final KeyBind lockSlotKeyBind = new KeyBind("Lock Slot", 72, true, null, this::tryChangeLockStateOnHoveredSlot);
    @Persisted
    private final HiddenConfig<Map<String, Set<Integer>>> classSlotLockMap = new HiddenConfig(new TreeMap());
    @Persisted
    private final Config<Boolean> blockAllActionsOnLockedItems = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> allowClickOnEmeraldPouchInBlockingMode = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> allowClickOnMultiHealthPotionsInBlockingMode = new Config<Boolean>(true);

    @SubscribeEvent
    public void onContainerRender(ContainerRenderEvent event) {
        AbstractContainerScreen<?> abstractContainerScreen = event.getScreen();
        if (Models.Container.getCurrentContainer() instanceof FullscreenContainerProperty) {
            return;
        }
        for (Integer slotId : (Set)((Map)this.classSlotLockMap.get()).getOrDefault(Models.Character.getId(), new TreeSet())) {
            Optional<Slot> lockedSlot = abstractContainerScreen.getMenu().slots.stream().filter(slot -> slot.container instanceof Inventory && slot.getContainerSlot() == slotId.intValue()).findFirst();
            if (lockedSlot.isEmpty()) continue;
            this.renderLockedSlot(event.getGuiGraphics(), abstractContainerScreen, lockedSlot.get());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onInventoryClickEvent(ContainerClickEvent event) {
        AbstractContainerScreen abstractContainerScreen;
        block10: {
            block9: {
                Screen screen = McUtils.mc().screen;
                if (!(screen instanceof AbstractContainerScreen)) break block9;
                abstractContainerScreen = (AbstractContainerScreen)screen;
                if (!(Models.Container.getCurrentContainer() instanceof FullscreenContainerProperty)) break block10;
            }
            return;
        }
        if (!((Boolean)this.blockAllActionsOnLockedItems.get()).booleanValue() && event.getClickType() != ClickType.THROW) {
            return;
        }
        Optional<Slot> slotOptional = abstractContainerScreen.getMenu().slots.stream().filter(slot -> slot.container instanceof Inventory && slot.index == event.getSlotNum()).findFirst();
        if (slotOptional.isEmpty()) {
            return;
        }
        if (event.getMouseButton() == 1) {
            if (((Boolean)this.allowClickOnEmeraldPouchInBlockingMode.get()).booleanValue() && Models.Emerald.isEmeraldPouch(slotOptional.get().getItem())) {
                return;
            }
            if (((Boolean)this.allowClickOnMultiHealthPotionsInBlockingMode.get()).booleanValue() && Models.Item.asWynnItem(slotOptional.get().getItem(), MultiHealthPotionItem.class).isPresent()) {
                return;
            }
        }
        if (((Set)((Map)this.classSlotLockMap.get()).getOrDefault(Models.Character.getId(), new TreeSet())).contains(slotOptional.get().getContainerSlot())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDrop(DropHeldItemEvent event) {
        ItemStack selected = McUtils.inventory().getSelected();
        Optional<Slot> heldItemSlot = McUtils.inventoryMenu().slots.stream().filter(slot -> slot.getItem() == selected).findFirst();
        if (heldItemSlot.isEmpty()) {
            return;
        }
        if (((Set)((Map)this.classSlotLockMap.get()).getOrDefault(Models.Character.getId(), new TreeSet())).contains(heldItemSlot.get().getContainerSlot())) {
            event.setCanceled(true);
        }
    }

    private void renderLockedSlot(GuiGraphics guiGraphics, AbstractContainerScreen<?> containerScreen, Slot lockedSlot) {
        BufferedRenderUtils.drawTexturedRect(guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource, Texture.ITEM_LOCK.resource(), containerScreen.leftPos + lockedSlot.x + 12, containerScreen.topPos + lockedSlot.y - 4, 399.0f, 8.0f, 8.0f, Texture.ITEM_LOCK.width() / 2, Texture.ITEM_LOCK.height() / 2);
    }

    private void tryChangeLockStateOnHoveredSlot(Slot hoveredSlot) {
        if (hoveredSlot == null || !(hoveredSlot.container instanceof Inventory)) {
            return;
        }
        ((Map)this.classSlotLockMap.get()).putIfAbsent(Models.Character.getId(), new TreeSet());
        Set classSet = (Set)((Map)this.classSlotLockMap.get()).get(Models.Character.getId());
        if (classSet.contains(hoveredSlot.getContainerSlot())) {
            classSet.remove(hoveredSlot.getContainerSlot());
        } else {
            classSet.add(hoveredSlot.getContainerSlot());
        }
        this.classSlotLockMap.touched();
    }
}

