/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.inventory;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.PartStyle;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.ItemTooltipRenderEvent;
import com.wynntils.mc.extension.MinecraftExtension;
import com.wynntils.utils.SystemUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.wynn.ItemUtils;
import java.awt.HeadlessException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.imageio.ImageIO;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import org.joml.Vector2i;

@ConfigCategory(value=Category.INVENTORY)
public class ItemScreenshotFeature
extends Feature {
    private static final ClientTooltipPositioner NO_POSITIONER = (screenWidth, screenHeight, mouseX, mouseY, tooltipWidth, tooltipHeight) -> new Vector2i(4, 4);
    @RegisterKeyBind
    private final KeyBind itemScreenshotKeyBind = new KeyBind("Screenshot Item", 293, true, null, this::onInventoryPress);
    @Persisted
    private final Config<Boolean> saveToDisk = new Config<Boolean>(false);
    private Slot screenshotSlot = null;

    private void onInventoryPress(Slot hoveredSlot) {
        this.screenshotSlot = hoveredSlot;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void render(ItemTooltipRenderEvent.Pre e) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        if (this.screenshotSlot == null || !this.screenshotSlot.hasItem()) {
            return;
        }
        Screen screen = McUtils.mc().screen;
        if (!(screen instanceof AbstractContainerScreen)) {
            return;
        }
        this.takeScreenshot(screen, this.screenshotSlot, e.getTooltips());
        this.screenshotSlot = null;
    }

    private void takeScreenshot(Screen screen, Slot hoveredSlot, List<Component> itemTooltip) {
        ItemStack itemStack = hoveredSlot.getItem();
        ArrayList<Component> tooltip = new ArrayList<Component>(itemTooltip);
        ItemScreenshotFeature.removeLoreTooltipLines(tooltip);
        Font font = FontRenderer.getInstance().getFont();
        int width = 0;
        for (Component c : tooltip) {
            int w = font.width((FormattedText)c);
            if (w <= width) continue;
            width = w;
        }
        width += 8;
        int height = 16;
        if (tooltip.size() > 1) {
            height += 2 + (tooltip.size() - 1) * 10;
        }
        float scaleh = (float)screen.height / (float)height;
        float scalew = (float)screen.width / (float)width;
        Screen.DeferredTooltipRendering deferredTooltipRendering = new Screen.DeferredTooltipRendering(Lists.transform(tooltip, Component::getVisualOrderText), NO_POSITIONER);
        McUtils.mc().getMainRenderTarget().unbindWrite();
        ByteBufferBuilder byteBuffer = new ByteBufferBuilder(256);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.immediate((ByteBufferBuilder)byteBuffer);
        GuiGraphics guiGraphics = new GuiGraphics(McUtils.mc(), bufferSource);
        MainTarget fb = new MainTarget(width * 2, height * 2);
        fb.setClearColor(1.0f, 1.0f, 1.0f, 0.0f);
        fb.createBuffers(width * 2, height * 2);
        fb.bindWrite(false);
        ((MinecraftExtension)McUtils.mc()).setOverridenRenderTarget((RenderTarget)fb);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(scalew, scaleh, 1.0f);
        guiGraphics.renderTooltip(FontRenderer.getInstance().getFont(), deferredTooltipRendering.tooltip(), deferredTooltipRendering.positioner(), 0, 0);
        guiGraphics.pose().popPose();
        guiGraphics.flush();
        fb.unbindWrite();
        ((MinecraftExtension)McUtils.mc()).setOverridenRenderTarget(null);
        McUtils.mc().getMainRenderTarget().bindWrite(true);
        BufferedImage bi = SystemUtils.createScreenshot((RenderTarget)fb);
        byteBuffer.close();
        bufferSource = null;
        if (((Boolean)this.saveToDisk.get()).booleanValue()) {
            String itemNameForFile = StyledText.fromComponent(itemStack.getHoverName()).trim().replaceAll("\u2b21 ", "").replaceAll("[/ ]", "_").getNormalized().getString(PartStyle.StyleType.NONE);
            File screenshotDir = new File(McUtils.mc().gameDirectory, "screenshots");
            String filename = Util.getFilenameFormattedDateTime() + "-" + itemNameForFile + ".png";
            try {
                Files.createDirectories(screenshotDir.toPath(), new FileAttribute[0]);
                File outputfile = new File(screenshotDir, filename);
                ImageIO.write((RenderedImage)bi, "png", outputfile);
                McUtils.sendMessageToClient((Component)Component.translatable((String)"feature.wynntils.itemScreenshot.save.message", (Object[])new Object[]{itemStack.getHoverName(), Component.literal((String)outputfile.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, outputfile.getAbsolutePath())))}).withStyle(ChatFormatting.GREEN));
            }
            catch (IOException e) {
                WynntilsMod.error("Failed to save image to disk", e);
                McUtils.sendErrorToClient(I18n.get((String)"feature.wynntils.itemScreenshot.save.error", (Object[])new Object[]{itemStack.getHoverName(), filename}));
            }
            if (SystemUtils.isMac()) {
                McUtils.sendMessageToClient((Component)Component.translatable((String)"feature.wynntils.itemScreenshot.copy.mac").withStyle(ChatFormatting.GRAY));
                return;
            }
        } else if (SystemUtils.isMac()) {
            McUtils.sendMessageToClient((Component)Component.translatable((String)"feature.wynntils.itemScreenshot.copy.mac2").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"feature.wynntils.itemScreenshot.copy.mac.clickHere").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wynntils config set ItemScreenshot saveToDisk true")))));
            return;
        }
        try {
            SystemUtils.copyImageToClipboard(bi);
            McUtils.sendMessageToClient((Component)Component.translatable((String)"feature.wynntils.itemScreenshot.copy.message").withStyle(ChatFormatting.GREEN));
        }
        catch (HeadlessException ex) {
            WynntilsMod.error("Failed to copy image to clipboard", ex);
            McUtils.sendErrorToClient(I18n.get((String)"feature.wynntils.itemScreenshot.copy.error", (Object[])new Object[0]));
        }
    }

    private static void removeLoreTooltipLines(List<Component> tooltip) {
        int loreStart = -1;
        for (int i = 0; i < tooltip.size(); ++i) {
            String tooltipLine = tooltip.get(i).getString();
            Matcher matcher = ItemUtils.ITEM_RARITY_PATTERN.matcher(tooltipLine);
            if (!matcher.find()) continue;
            loreStart = i + 1;
            break;
        }
        if (loreStart != -1) {
            tooltip.subList(loreStart, tooltip.size()).clear();
        }
    }
}

