/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.redirects;

import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.handlers.chat.type.MessageType;
import com.wynntils.models.players.type.PlayerRank;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.mc.StyledTextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.REDIRECTS)
public class ChatRedirectFeature
extends Feature {
    @Persisted
    private final Config<RedirectAction> blacksmith = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> bloodPactHealth = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> craftedDurability = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> emptyManaBank = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> friendJoin = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> heal = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> horse = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> housingMaster = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> housingTeleport = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> ingredientPouch = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> loginAnnouncements = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> mageTeleport = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> notEnoughMana = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> potion = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> scrollTeleport = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> shaman = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> speed = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> toolDurability = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> unusedPoints = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> guildBank = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> guildRewards = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> merchant = new Config<RedirectAction>(RedirectAction.REDIRECT);
    @Persisted
    private final Config<RedirectAction> itemDropped = new Config<RedirectAction>(RedirectAction.REDIRECT);
    private final List<Redirector> redirectors = new ArrayList<Redirector>();

    public ChatRedirectFeature() {
        this.register(new BlacksmithRedirector());
        this.register(new BloodPactHealthDeficitRedirector());
        this.register(new CraftedDurabilityRedirector());
        this.register(new EmptyManaBankRedirector());
        this.register(new FriendJoinRedirector());
        this.register(new FriendLeaveRedirector());
        this.register(new GuildBankRedirector());
        this.register(new GuildRewardRedirector());
        this.register(new HealRedirector());
        this.register(new HealedByOtherRedirector());
        this.register(new HorseDespawnedRedirector());
        this.register(new HorseScaredRedirector());
        this.register(new HorseSpawnFailRedirector());
        this.register(new HousingMasterRedirector());
        this.register(new HousingTeleportArrivalCooldownRedirector());
        this.register(new HousingTeleportArrivalRedirector());
        this.register(new HousingTeleportDepartureCooldownRedirector());
        this.register(new HousingTeleportDepartureRedirector());
        this.register(new IngredientPouchSellRedirector());
        this.register(new ItemDroppedRedirector());
        this.register(new LoginRedirector());
        this.register(new MageTeleportationFailRedirector());
        this.register(new ManaDeficitRedirector());
        this.register(new MerchantRedirector());
        this.register(new NoTotemRedirector());
        this.register(new PotionAlreadyActiveRedirector());
        this.register(new PotionsMaxRedirector());
        this.register(new PotionsMovedRedirector());
        this.register(new PotionsReplacedRedirector());
        this.register(new ScrollTeleportationHousingFailRedirector());
        this.register(new SpeedBoostRedirector());
        this.register(new ToolDurabilityRedirector());
        this.register(new UnusedAbilityPointsRedirector());
        this.register(new UnusedSkillAndAbilityPointsRedirector());
        this.register(new UnusedSkillPointsRedirector());
    }

    private void register(Redirector redirector) {
        this.redirectors.add(redirector);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onChatMessage(ChatMessageEvent.Match e) {
        StyledText message = StyledTextUtils.unwrap(e.getMessage()).stripAlignment();
        MessageType messageType = e.getMessageType();
        for (Redirector redirector : this.redirectors) {
            Matcher matcher;
            Pattern pattern;
            RedirectAction action = redirector.getAction();
            if (action == RedirectAction.KEEP || (pattern = redirector.getPattern(messageType)) == null || !(matcher = message.getMatcher(pattern)).find()) continue;
            e.setCanceled(true);
            if (redirector.getAction() == RedirectAction.HIDE) continue;
            for (StyledText notification : redirector.getNotifications(matcher)) {
                Managers.Notification.queueMessage(notification);
            }
        }
    }

    public static enum RedirectAction {
        KEEP,
        HIDE,
        REDIRECT;

    }

    private class BlacksmithRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("\u00a75(\ue00a\ue002|\ue001) Blacksmith: \u00a7dYou have (sold|repaired) (.*)\u00a7d for \u00a7(a|3)(.*)");

        private BlacksmithRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.blacksmith.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromString(String.valueOf(ChatFormatting.LIGHT_PURPLE) + StringUtils.capitalizeFirst(matcher.group(2)) + " " + matcher.group(3) + String.valueOf(ChatFormatting.LIGHT_PURPLE) + " for \u00a7" + matcher.group(4) + matcher.group(5));
        }
    }

    protected static interface Redirector {
        public Pattern getPattern(MessageType var1);

        public RedirectAction getAction();

        public List<StyledText> getNotifications(Matcher var1);
    }

    private class BloodPactHealthDeficitRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a74(?:\ue008\ue002|\ue001) You don't have enough health to cast that spell!$");

        private BloodPactHealthDeficitRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.bloodPactHealth.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.bloodPactHealth.notification").withStyle(ChatFormatting.DARK_RED));
        }
    }

    private class CraftedDurabilityRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a74(?:\ue008\ue002|\ue001) Your items are damaged and have become less effective. Bring them to a Blacksmith to repair them.$");

        private CraftedDurabilityRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.craftedDurability.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.craftedDurability.notification").withStyle(ChatFormatting.DARK_RED));
        }
    }

    private class EmptyManaBankRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("\u00a74Your mana bank is empty!");
        private static final Pattern BACKGROUND_PATTERN = Pattern.compile("\u00a77Your mana bank is empty!");

        private EmptyManaBankRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        protected Pattern getBackgroundPattern() {
            return BACKGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.emptyManaBank.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.emptyManaBank.notification").withStyle(ChatFormatting.DARK_RED));
        }
    }

    private class FriendJoinRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("\u00a7a(\u00a7o)?(?<name>.+)\u00a72 has logged into server \u00a7a(?<server>.+)\u00a72 as \u00a7aan? (?<class>.+)");
        private static final Pattern BACKGROUND_PATTERN = Pattern.compile("\u00a77(\u00a7o)?(?<name>.+)\u00a78(\u00a7o)? has logged into server \u00a77(\u00a7o)?(?<server>.+)\u00a78(\u00a7o)? as \u00a77(\u00a7o)?an? (?<class>.+)");

        private FriendJoinRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        protected Pattern getBackgroundPattern() {
            return BACKGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.friendJoin.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            String playerName = matcher.group("name");
            String server = matcher.group("server");
            String playerClass = matcher.group("class");
            return StyledText.fromString(String.valueOf(ChatFormatting.GREEN) + "\u2192 " + String.valueOf(ChatFormatting.DARK_GREEN) + playerName + " [" + String.valueOf(ChatFormatting.GREEN) + server + "/" + playerClass + String.valueOf(ChatFormatting.DARK_GREEN) + "]");
        }
    }

    private class FriendLeaveRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("\u00a7a(?<name>.+) left the game\\.");
        private static final Pattern BACKGROUND_PATTERN = Pattern.compile("\u00a77(?<name>.+) left the game\\.");

        private FriendLeaveRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        protected Pattern getBackgroundPattern() {
            return BACKGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.friendJoin.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            String playerName = matcher.group("name");
            return StyledText.fromString(String.valueOf(ChatFormatting.RED) + "\u2190 " + String.valueOf(ChatFormatting.DARK_GREEN) + playerName);
        }
    }

    private final class GuildBankRedirector
    extends SimpleRedirector {
        private static final String DEPOSIT_SYMBOL = "\u2190";
        private static final String WITHDRAW_SYMBOL = "\u2192";
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a7b(?:\ue006\ue002|\ue001) \u00a73(?<player>.+)\u00a7b (?<transactiontype>withdrew|deposited) \u00a7e(?<count>\\d+)x (?<item>.+)\u00a7b (?:from|to) the Guild Bank \\(\u00a73(?<banktype>Everyone|High Ranked)\u00a7b\\)$");

        private GuildBankRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.guildBank.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            String player = matcher.group("player");
            String transactionType = matcher.group("transactiontype");
            String count = matcher.group("count");
            String item = matcher.group("item");
            String bankType = matcher.group("banktype");
            return StyledText.fromString(String.valueOf(ChatFormatting.AQUA) + (transactionType.equals("withdrew") ? WITHDRAW_SYMBOL : DEPOSIT_SYMBOL) + String.valueOf(ChatFormatting.DARK_AQUA) + " " + player + " " + count + "x " + item + " (" + bankType + ") ");
        }
    }

    private final class GuildRewardRedirector
    extends SimpleRedirector {
        private static final String REWARD_SYMBOL = "\u2192";
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a7b(?:\ue006\ue002|\ue001) \u00a73(?<sender>.+) rewarded \u00a7e(?<reward>.+)\u00a73 to (?<recipient>.+)$");

        private GuildRewardRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.guildRewards.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            String sender = matcher.group("sender");
            String reward = matcher.group("reward");
            String recipient = matcher.group("recipient");
            return StyledText.fromString(String.valueOf(ChatFormatting.AQUA) + sender + String.valueOf(ChatFormatting.DARK_AQUA) + " \u2192 " + String.valueOf(ChatFormatting.AQUA) + recipient + String.valueOf(ChatFormatting.DARK_AQUA) + ": " + reward);
        }
    }

    private class HealRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a7c\\[\\+(\\d+) \u2764\\]$");

        private HealRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.heal.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            String amount = matcher.group(1);
            return StyledText.fromString(String.valueOf(ChatFormatting.DARK_RED) + "[+" + amount + " \u2764]");
        }
    }

    private class HealedByOtherRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^.+ gave you \u00a7c\\[\\+(\\d+) \u2764\\]$");
        private static final Pattern BACKGROUND_PATTERN = Pattern.compile("^.+ gave you \u00a77\u00a7o\\[\\+(\\d+) \u2764\\]$");

        private HealedByOtherRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        protected Pattern getBackgroundPattern() {
            return BACKGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.heal.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            String amount = matcher.group(1);
            return StyledText.fromString(String.valueOf(ChatFormatting.DARK_RED) + "[+" + amount + " \u2764]");
        }
    }

    private class HorseDespawnedRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a7dSince you interacted with your inventory, your horse has despawned\\.$");

        private HorseDespawnedRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.horse.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.horse.notificationDespawned").withStyle(ChatFormatting.DARK_PURPLE));
        }
    }

    private class HorseScaredRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a7dYour horse is scared to come out right now, too many mobs are nearby\\.$");

        private HorseScaredRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.horse.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.horse.notificationScared").withStyle(ChatFormatting.DARK_RED));
        }
    }

    private class HorseSpawnFailRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a74(?:\ue008\ue002|\ue001) There is no room for a horse\\.$");

        private HorseSpawnFailRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.horse.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.horse.notificationNoRoom").withStyle(ChatFormatting.DARK_RED));
        }
    }

    private class HousingMasterRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("\u00a77The blocks have been added to your building inventory");

        private HousingMasterRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.housingMaster.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.housingMaster.added").withStyle(ChatFormatting.GRAY));
        }
    }

    private class HousingTeleportArrivalCooldownRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a74(?:\ue008\ue002|\ue001) You need to wait before joining another house\\.$");

        private HousingTeleportArrivalCooldownRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.housingTeleport.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.housingTeleport.notificationCooldown").withStyle(ChatFormatting.DARK_RED));
        }
    }

    private class HousingTeleportArrivalRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a7aYou have flown to your housing island\\.$");

        private HousingTeleportArrivalRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.housingTeleport.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.housingTeleport.notificationJoined").withStyle(ChatFormatting.GRAY));
        }
    }

    private class HousingTeleportDepartureCooldownRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a74(?:\ue008\ue002|\ue001) You need to wait a bit before leaving a house\\.$");

        private HousingTeleportDepartureCooldownRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.housingTeleport.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.housingTeleport.notificationCooldown").withStyle(ChatFormatting.DARK_RED));
        }
    }

    private class HousingTeleportDepartureRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a7a(?:\ue008\ue002|\ue001) You have flown to your original position\\.$");

        private HousingTeleportDepartureRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.housingTeleport.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.housingTeleport.notificationLeft").withStyle(ChatFormatting.GRAY));
        }
    }

    private class IngredientPouchSellRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("\u00a7dYou have sold \u00a77(.+)\u00a7d ingredients for a total of \u00a7a(.+)\u00a7d\\.$");

        private IngredientPouchSellRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.ingredientPouch.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            int ingredientCount = Integer.parseInt(matcher.group(1));
            MutableComponent formattedPlural = Component.literal((String)(ingredientCount + " ")).withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)("feature.wynntils.chatRedirect.ingredientPouch.ingredient" + (ingredientCount == 1 ? "Singular" : "Plural"))).withStyle(ChatFormatting.LIGHT_PURPLE));
            StyledText emeraldString = StyledText.fromString(String.valueOf(ChatFormatting.GREEN) + matcher.group(2) + String.valueOf(ChatFormatting.LIGHT_PURPLE));
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.ingredientPouch.notification", (Object[])new Object[]{formattedPlural.getString(), emeraldString.getString()}).withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    }

    private final class ItemDroppedRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a77There wasn't enough room in your inventory\\, so items were dropped\\.$");

        private ItemDroppedRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.itemDropped.notification").withStyle(ChatFormatting.GRAY));
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.itemDropped.get());
        }
    }

    public class LoginRedirector
    extends SimpleRedirector {
        private static final String RANK_STRING = Arrays.stream(PlayerRank.values()).map(PlayerRank::getTag).collect(Collectors.joining());
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a7f(?<rank>[" + RANK_STRING + "]) \u00a7(?:#[0-9a-f]{6,8}|.)(?:\u00a7o)?(?:\u00a7<\\d>)?(?<name>[\\w ]{1,20})\u00a7f \u00a7.has just logged in!$");
        private static final Pattern BACKGROUND_PATTERN = Pattern.compile("^(?:\u00a78)?\\[(\u00a7.)+\\|?(\u00a7.)*(?<rank>[" + RANK_STRING + "]) \u00a7(?:#[0-9a-f]{6,8}|.)(?:\u00a7o)?(?:\u00a7<\\d>)?(?<name>[\\w ]{1,20})\u00a7. has just logged in!$");

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        protected Pattern getBackgroundPattern() {
            return BACKGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.loginAnnouncements.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            String rankString = matcher.group("rank");
            String playerName = matcher.group("name");
            PlayerRank rank = PlayerRank.fromString(rankString);
            return StyledText.fromString(String.valueOf(ChatFormatting.GREEN) + "\u2192 " + String.valueOf(ChatFormatting.RESET) + rank.getTag() + " " + String.valueOf(rank.getTextColor()) + playerName);
        }
    }

    private class MageTeleportationFailRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a74(?:\ue008\ue002|\ue001) Sorry, you can't teleport\\.\\.\\. Try moving away from blocks\\.$");

        private MageTeleportationFailRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.mageTeleport.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.mageTeleport.notification").withStyle(ChatFormatting.DARK_RED));
        }
    }

    private class ManaDeficitRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a74(?:\ue008\ue002|\ue001) You don't have enough mana to cast that spell!$");

        private ManaDeficitRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.notEnoughMana.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.notEnoughMana.notification").withStyle(ChatFormatting.DARK_RED));
        }
    }

    private final class MerchantRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a75(?:\ue00a\ue002|\ue001) (?<merchant>.*):\u00a7d Thank you for your business\\. Come again!$");

        private MerchantRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.merchant.notification", (Object[])new Object[]{matcher.group("merchant")}).withStyle(ChatFormatting.LIGHT_PURPLE));
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.merchant.get());
        }
    }

    private class NoTotemRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a74(?:\ue008\ue002|\ue001) You have no active totems near you$");

        private NoTotemRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.shaman.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.shaman.notification").withStyle(ChatFormatting.DARK_RED));
        }
    }

    private class PotionAlreadyActiveRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a74(?:\ue008\ue002|\ue001) You already have that potion active\\.\\.\\.$");

        private PotionAlreadyActiveRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.potion.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.potion.notificationAlreadyActive").withStyle(ChatFormatting.DARK_RED));
        }
    }

    private class PotionsMaxRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a74(?:\ue008\ue002|\ue001) You already are holding the maximum amount of potions allowed\\.");

        private PotionsMaxRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.potion.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.potion.notificationChargeLimit").withStyle(ChatFormatting.DARK_RED));
        }
    }

    private class PotionsMovedRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a77You already are holding the maximum amount of potions allowed so your crafting result was moved to your Character Bank\\.$");

        private PotionsMovedRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.potion.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.potion.notificationMoved").withStyle(ChatFormatting.GRAY));
        }
    }

    private class PotionsReplacedRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("\u00a77One less powerful potion was replaced to open space for the added one\\.");

        private PotionsReplacedRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.potion.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.potion.notificationReplaced").withStyle(ChatFormatting.GRAY));
        }
    }

    private class ScrollTeleportationHousingFailRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a74(?:\ue008\ue002|\ue001) You can not teleport while inside a house$");

        private ScrollTeleportationHousingFailRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.scrollTeleport.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.scrollTeleport.notificationHousing").withStyle(ChatFormatting.DARK_RED));
        }
    }

    private class SpeedBoostRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a7b\\+([23]) minutes\u00a77 speed boost\\.$");

        private SpeedBoostRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.speed.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            String minutes = matcher.group(1);
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.speed.notificationFirst", (Object[])new Object[]{minutes}).withStyle(ChatFormatting.AQUA).append((Component)Component.translatable((String)"feature.wynntils.chatRedirect.speed.notificationSecond").withStyle(ChatFormatting.GRAY)));
        }
    }

    private class ToolDurabilityRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a74(?:\ue008\ue002|\ue001) Your tool has 0 durability left! You will not receive any new resources until you repair it at a Blacksmith\\.$");

        private ToolDurabilityRedirector() {
        }

        @Override
        public Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.toolDurability.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.toolDurability.notification").withStyle(ChatFormatting.DARK_RED));
        }
    }

    private class UnusedAbilityPointsRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a74You have \u00a7b\u00a7l(\\d+) unused Ability Points?! \u00a74Right-Click while holding your compass to use them$");

        private UnusedAbilityPointsRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.unusedPoints.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            String unusedAbilityPoints = matcher.group(1);
            return UnusedAbilityPointsRedirector.getUnusedAbilityPointsMessage(unusedAbilityPoints);
        }

        protected static StyledText getUnusedAbilityPointsMessage(String unusedAbilityPoints) {
            String pointsString = String.valueOf(ChatFormatting.BOLD) + unusedAbilityPoints + String.valueOf(ChatFormatting.RESET) + String.valueOf(ChatFormatting.DARK_AQUA);
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.unusedPoints.notificationAbility", (Object[])new Object[]{pointsString}).withStyle(ChatFormatting.DARK_AQUA));
        }
    }

    private class UnusedSkillAndAbilityPointsRedirector
    implements Redirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a74You have \u00a7c\u00a7l(\\d+) unused Skill Points?\u00a74 and \u00a7b\u00a7l(\\d+) unused Ability Points?! \u00a74Right-Click while holding your compass to use them$");

        private UnusedSkillAndAbilityPointsRedirector() {
        }

        @Override
        public Pattern getPattern(MessageType messageType) {
            if (messageType == MessageType.FOREGROUND) {
                return FOREGROUND_PATTERN;
            }
            return null;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.unusedPoints.get());
        }

        @Override
        public List<StyledText> getNotifications(Matcher matcher) {
            String unusedSkillPoints = matcher.group(1);
            String unusedAbilityPoints = matcher.group(2);
            return List.of(UnusedSkillPointsRedirector.getUnusedSkillPointsMessage(unusedSkillPoints), UnusedAbilityPointsRedirector.getUnusedAbilityPointsMessage(unusedAbilityPoints));
        }
    }

    private class UnusedSkillPointsRedirector
    extends SimpleRedirector {
        private static final Pattern FOREGROUND_PATTERN = Pattern.compile("^\u00a74You have \u00a7c\u00a7l(\\d+) unused Skill Points?! \u00a74Right-Click while holding your compass to use them$");

        private UnusedSkillPointsRedirector() {
        }

        @Override
        protected Pattern getForegroundPattern() {
            return FOREGROUND_PATTERN;
        }

        @Override
        public RedirectAction getAction() {
            return (RedirectAction)((Object)ChatRedirectFeature.this.unusedPoints.get());
        }

        @Override
        protected StyledText getNotification(Matcher matcher) {
            String unusedSkillPoints = matcher.group(1);
            return UnusedSkillPointsRedirector.getUnusedSkillPointsMessage(unusedSkillPoints);
        }

        protected static StyledText getUnusedSkillPointsMessage(String unusedSkillPoints) {
            String pointsString = String.valueOf(ChatFormatting.BOLD) + unusedSkillPoints + String.valueOf(ChatFormatting.RESET) + String.valueOf(ChatFormatting.DARK_RED);
            return StyledText.fromComponent((Component)Component.translatable((String)"feature.wynntils.chatRedirect.unusedPoints.notificationSkill", (Object[])new Object[]{pointsString}).withStyle(ChatFormatting.DARK_RED));
        }
    }

    public static abstract class SimpleRedirector
    implements Redirector {
        @Override
        public Pattern getPattern(MessageType messageType) {
            return switch (messageType) {
                default -> throw new MatchException(null, null);
                case MessageType.FOREGROUND -> this.getForegroundPattern();
                case MessageType.BACKGROUND -> this.getBackgroundPattern();
            };
        }

        protected Pattern getForegroundPattern() {
            return null;
        }

        protected Pattern getBackgroundPattern() {
            return null;
        }

        @Override
        public List<StyledText> getNotifications(Matcher matcher) {
            return List.of(this.getNotification(matcher));
        }

        protected abstract StyledText getNotification(Matcher var1);
    }
}

