/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.tooltips;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.tooltips.TooltipFittingFeature;
import com.wynntils.mc.event.ContainerClickEvent;
import com.wynntils.mc.event.ContainerCloseEvent;
import com.wynntils.mc.event.HotbarSlotRenderEvent;
import com.wynntils.mc.event.ItemTooltipRenderEvent;
import com.wynntils.mc.event.SlotRenderEvent;
import com.wynntils.mc.event.TooltipRenderEvent;
import com.wynntils.models.inventory.type.InventoryAccessory;
import com.wynntils.models.inventory.type.InventoryArmor;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.properties.GearTypeItemProperty;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.wynnitem.parsing.WynnItemParser;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.TooltipUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.wynn.InventoryUtils;
import com.wynntils.utils.wynn.ItemUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import org.joml.Vector2i;
import org.joml.Vector2ic;

@ConfigCategory(value=Category.TOOLTIPS)
public class ItemCompareFeature
extends Feature {
    @Persisted
    private final Config<Integer> maxCompareSelectedCount = new Config<Integer>(4);
    @Persisted
    private final Config<Boolean> removeFlavourText = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> removeSetInfoText = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> displayTag = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> centerItemName = new Config<Boolean>(false);
    @RegisterKeyBind
    private final KeyBind holdToCompareKeyBind = new KeyBind("Hold to compare", 335, false, null, null);
    @RegisterKeyBind
    private final KeyBind selectCompareKeyBind = new KeyBind("Select for comparing", 334, true, null, this::onSelectKeyPress);
    private final List<Pair<WynnItem, ItemStack>> selectedItems = new ArrayList<Pair<WynnItem, ItemStack>>();
    private static final int COMPARE_ITEM_PAD = 6;
    private static final String EQUIPPED_KEY = "feature.wynntils.itemCompare.tag.equipped";
    private static final String HOVERED_KEY = "feature.wynntils.itemCompare.tag.hovered";
    private static final String SELECTED_KEY = "feature.wynntils.itemCompare.tag.selected";
    private static final String HOVERED_SELECTED_KEY = "feature.wynntils.itemCompare.tag.hovered_selected";
    private int equippedCount = 0;
    private boolean changePositioner = false;

    @SubscribeEvent
    public void onWorldStateChangeEvent(WorldStateEvent event) {
        this.selectedItems.clear();
    }

    @SubscribeEvent
    public void onContainerCloseEvent(ContainerCloseEvent.Post event) {
        this.selectedItems.clear();
    }

    @SubscribeEvent
    public void onInventoryClickEvent(ContainerClickEvent event) {
        this.unselectItemStack(event.getItemStack());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTooltipRenderEvent(TooltipRenderEvent event) {
        if (!this.changePositioner) {
            return;
        }
        event.setPositioner(PassiveTooltipPositioner.INSTANCE);
    }

    @SubscribeEvent
    public void onSlotRenderEvent(SlotRenderEvent.Pre event) {
        Slot slot = event.getSlot();
        this.drawSelectionArc(event.getPoseStack(), slot.getItem(), slot.x, slot.y, false);
    }

    @SubscribeEvent
    public void onHotbarSlotRenderEvent(HotbarSlotRenderEvent.Pre event) {
        this.drawSelectionArc(event.getPoseStack(), event.getItemStack(), event.getX(), event.getY(), true);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemTooltipRenderEvent(ItemTooltipRenderEvent.Pre event) {
        float scaleFactor;
        Screen screen;
        if (!KeyboardUtils.isKeyDown(this.holdToCompareKeyBind.getKeyMapping().key.getValue())) {
            return;
        }
        if (McUtils.mc().screen == null || !((screen = McUtils.mc().screen) instanceof AbstractContainerScreen)) {
            return;
        }
        AbstractContainerScreen abstractContainerScreen = (AbstractContainerScreen)screen;
        if (abstractContainerScreen.hoveredSlot == null) {
            return;
        }
        ItemStack hoveredItemStack = abstractContainerScreen.hoveredSlot.getItem();
        if (event.getItemStack() != hoveredItemStack) {
            return;
        }
        Optional<WynnItem> hoveredWynnItemOpt = Models.Item.getWynnItem(hoveredItemStack);
        if (hoveredWynnItemOpt.isEmpty()) {
            return;
        }
        WynnItem hoveredWynnItem = hoveredWynnItemOpt.get();
        if (!(hoveredWynnItem instanceof GearTypeItemProperty)) {
            return;
        }
        GearTypeItemProperty hoveredGearItemProperty = (GearTypeItemProperty)((Object)hoveredWynnItem);
        ArrayList itemsToCompare = new ArrayList();
        if (!this.isItemStackSelected(hoveredItemStack)) {
            switch (hoveredGearItemProperty.getGearType()) {
                case HELMET: 
                case CHESTPLATE: 
                case LEGGINGS: 
                case BOOTS: {
                    NonNullList armors = McUtils.inventory().armor;
                    Optional<ItemStack> matchingArmorOpt = armors.stream().filter(itemStack -> this.isMatchingType((ItemStack)itemStack, hoveredGearItemProperty)).findFirst();
                    if (!matchingArmorOpt.isPresent()) break;
                    ItemStack armor = matchingArmorOpt.get();
                    Models.Item.getWynnItem(armor).ifPresent(wynnItem -> {
                        if (armor != hoveredItemStack) {
                            itemsToCompare.add(Pair.of(wynnItem, armor));
                            ++this.equippedCount;
                        }
                    });
                    break;
                }
                case RING: 
                case BRACELET: 
                case NECKLACE: {
                    List<ItemStack> accessories = InventoryUtils.getAccessories((Player)McUtils.player());
                    List<ItemStack> matchingAccessories = accessories.stream().filter(itemStack -> this.isMatchingType((ItemStack)itemStack, hoveredGearItemProperty)).filter(itemStack -> itemStack != hoveredItemStack).filter(itemStack -> !ItemUtils.isEmptyAccessorySlot(itemStack)).toList();
                    matchingAccessories.forEach(itemStack -> Models.Item.getWynnItem((ItemStack)itemStack).ifPresent(wynnItem -> {
                        itemsToCompare.add(Pair.of(wynnItem, itemStack));
                        ++this.equippedCount;
                    }));
                    break;
                }
                case SPEAR: 
                case WAND: 
                case DAGGER: 
                case BOW: 
                case RELIK: {
                    ItemStack inHand = McUtils.player().getMainHandItem();
                    if (inHand == ItemStack.EMPTY || inHand == hoveredItemStack) break;
                    Models.Item.getWynnItem(inHand).ifPresent(wynnItem -> {
                        if (this.isMatchingType((WynnItem)wynnItem, hoveredGearItemProperty)) {
                            itemsToCompare.add(Pair.of(wynnItem, inHand));
                            ++this.equippedCount;
                        }
                    });
                }
            }
        }
        List selectedMatchingHovered = this.selectedItems.stream().filter(pair -> this.isMatchingType((WynnItem)pair.a(), hoveredGearItemProperty)).filter(pair -> pair.b() != hoveredItemStack).filter(pair -> !itemsToCompare.contains(pair)).collect(Collectors.toCollection(ArrayList::new));
        while (selectedMatchingHovered.size() > (Integer)this.maxCompareSelectedCount.get()) {
            selectedMatchingHovered.removeLast();
        }
        itemsToCompare.addAll(selectedMatchingHovered);
        if (itemsToCompare.isEmpty()) {
            return;
        }
        Window window = McUtils.mc().getWindow();
        GuiGraphics guiGraphics = event.getGuiGraphics();
        Font font = FontRenderer.getInstance().getFont();
        PoseStack poseStack = guiGraphics.pose();
        float universalScale = ((Float)Managers.Feature.getFeatureInstance(TooltipFittingFeature.class).universalScale.get()).floatValue();
        int twoPad = 12;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 300.0f);
        ArrayList<Component> hoveredLines = new ArrayList<Component>(event.getTooltips());
        if (((Boolean)this.removeFlavourText.get()).booleanValue()) {
            this.removeFlavourText(hoveredLines);
        }
        if (((Boolean)this.removeSetInfoText.get()).booleanValue()) {
            this.removeSetInfoText(hoveredLines);
        }
        List<ClientTooltipComponent> hoveredClientComponents = TooltipUtils.getClientTooltipComponent(hoveredLines);
        int hoveredTooltipWidth = TooltipUtils.getTooltipWidth(hoveredClientComponents, font);
        int hoveredTooltipHeight = TooltipUtils.getTooltipHeight(hoveredClientComponents);
        if (((Boolean)this.centerItemName.get()).booleanValue()) {
            this.centerItemName(hoveredLines, hoveredTooltipWidth);
        }
        if (((Boolean)this.displayTag.get()).booleanValue()) {
            if (this.isItemStackSelected(hoveredItemStack)) {
                hoveredLines.addFirst((Component)this.getPaddedComponent(this.getTag(HOVERED_SELECTED_KEY), hoveredTooltipWidth));
            } else {
                hoveredLines.addFirst((Component)this.getPaddedComponent(this.getTag(HOVERED_KEY), hoveredTooltipWidth));
            }
            Objects.requireNonNull(font);
            hoveredTooltipHeight += 9;
        }
        float hoveredScaleFactor = universalScale;
        if (hoveredTooltipHeight + twoPad > window.getGuiScaledHeight()) {
            scaleFactor = (float)(window.getGuiScaledHeight() - twoPad) / (float)hoveredTooltipHeight;
            hoveredScaleFactor *= scaleFactor;
            hoveredTooltipWidth = (int)((float)hoveredTooltipWidth * scaleFactor);
            hoveredTooltipHeight = (int)((float)hoveredTooltipHeight * scaleFactor);
        }
        if ((float)(hoveredTooltipWidth + twoPad) > (float)window.getGuiScaledWidth() / 3.0f) {
            scaleFactor = ((float)window.getGuiScaledWidth() / 3.0f - (float)twoPad) / (float)hoveredTooltipWidth;
            hoveredScaleFactor *= scaleFactor;
            hoveredTooltipWidth = (int)((float)hoveredTooltipWidth * scaleFactor);
            hoveredTooltipHeight = (int)((float)hoveredTooltipHeight * scaleFactor);
        }
        int hoveredX = window.getGuiScaledWidth() - hoveredTooltipWidth - 6;
        int hoveredY = (int)((float)window.getGuiScaledHeight() / 2.0f - (float)hoveredTooltipHeight / 2.0f);
        ArrayList<Tooltip> tooltips = new ArrayList<Tooltip>();
        int prevX = hoveredX;
        for (Pair pair2 : itemsToCompare) {
            int maxWidth;
            List<Component> lines = this.getWynnOrVanillaLines(abstractContainerScreen, (WynnItem)pair2.key(), (ItemStack)pair2.value());
            if (((Boolean)this.removeFlavourText.get()).booleanValue()) {
                this.removeFlavourText(lines);
            }
            if (((Boolean)this.removeSetInfoText.get()).booleanValue()) {
                this.removeSetInfoText(lines);
            }
            List<ClientTooltipComponent> clientTooltipComponents = TooltipUtils.getClientTooltipComponent(lines);
            int tooltipWidth = TooltipUtils.getTooltipWidth(clientTooltipComponents, font);
            int tooltipHeight = TooltipUtils.getTooltipHeight(clientTooltipComponents);
            if (((Boolean)this.centerItemName.get()).booleanValue()) {
                this.centerItemName(lines, tooltipWidth);
            }
            if (((Boolean)this.displayTag.get()).booleanValue()) {
                if (this.equippedCount > 0) {
                    lines.addFirst((Component)this.getPaddedComponent(this.getTag(EQUIPPED_KEY), tooltipWidth));
                    --this.equippedCount;
                } else {
                    lines.addFirst((Component)this.getPaddedComponent(this.getTag(SELECTED_KEY), tooltipWidth));
                }
                Objects.requireNonNull(font);
                tooltipHeight += 9;
            }
            float tooltipScaleFactor = universalScale;
            if (tooltipHeight + twoPad > window.getGuiScaledHeight()) {
                float scaleFactor2 = (float)(window.getGuiScaledHeight() - twoPad) / (float)tooltipHeight;
                tooltipScaleFactor *= scaleFactor2;
                tooltipWidth = (int)((float)tooltipWidth * scaleFactor2);
                tooltipHeight = (int)((float)tooltipHeight * scaleFactor2);
            }
            if (tooltipWidth + twoPad > (maxWidth = Math.round((float)window.getGuiScaledWidth() / 3.0f))) {
                float scaleFactor3 = (float)(maxWidth - twoPad) / (float)tooltipWidth;
                tooltipScaleFactor *= scaleFactor3;
                tooltipWidth = (int)((float)tooltipWidth * scaleFactor3);
                tooltipHeight = (int)((float)tooltipHeight * scaleFactor3);
            }
            int x = prevX - twoPad - tooltipWidth;
            int y = (int)((float)window.getGuiScaledHeight() / 2.0f - (float)tooltipHeight / 2.0f);
            tooltips.add(new Tooltip(lines, x, y, tooltipWidth, tooltipHeight, tooltipScaleFactor, ((ItemStack)pair2.value()).getTooltipImage()));
            prevX = x;
        }
        if (!tooltips.isEmpty() && ((Tooltip)tooltips.getLast()).getX() < 0) {
            this.fixTooltipOverflow(tooltips, window.getGuiScaledHeight());
        }
        int d1 = ((Tooltip)tooltips.getLast()).getX();
        int d2 = window.getGuiScaledWidth() - (hoveredX + hoveredTooltipWidth);
        int offsetX = Math.floorDiv(d1 + d2, 2) - Math.max(d1, d2);
        tooltips.forEach(tooltip -> tooltip.offsetX(offsetX));
        event.setCanceled(true);
        this.changePositioner = true;
        poseStack.pushPose();
        poseStack.scale(hoveredScaleFactor, hoveredScaleFactor, 1.0f);
        guiGraphics.renderTooltip(font, hoveredLines, hoveredItemStack.getTooltipImage(), (int)((float)(hoveredX += offsetX) / hoveredScaleFactor), (int)((float)hoveredY / hoveredScaleFactor));
        poseStack.popPose();
        for (Tooltip tooltip2 : tooltips) {
            poseStack.pushPose();
            float scaleFactor4 = tooltip2.getScaleFactor();
            poseStack.scale(scaleFactor4, scaleFactor4, 1.0f);
            guiGraphics.renderTooltip(font, tooltip2.getLines(), tooltip2.getVisualTooltipComponent(), (int)((float)tooltip2.getX() / scaleFactor4), (int)((float)tooltip2.getY() / scaleFactor4));
            poseStack.popPose();
        }
        this.changePositioner = false;
        poseStack.popPose();
    }

    private boolean isMatchingType(WynnItem wynnItem, GearTypeItemProperty gearItemReference) {
        if (wynnItem instanceof GearItem) {
            GearItem gearItem = (GearItem)wynnItem;
            return gearItem.getGearType() == gearItemReference.getGearType();
        }
        return false;
    }

    private boolean isMatchingType(ItemStack itemStack, GearTypeItemProperty gearItemReference) {
        Optional<GearTypeItemProperty> gearOpt = Models.Item.asWynnItemProperty(itemStack, GearTypeItemProperty.class);
        return gearOpt.isEmpty() ? false : gearOpt.get().getGearType() == gearItemReference.getGearType();
    }

    private void onSelectKeyPress(Slot hoveredSlot) {
        if (hoveredSlot == null) {
            return;
        }
        int slot = hoveredSlot.getContainerSlot();
        for (int i : InventoryAccessory.getSlots()) {
            if (slot != i) continue;
            return;
        }
        for (int i : InventoryArmor.getArmorSlots()) {
            if (slot != i + 36) continue;
            return;
        }
        ItemStack itemStack = hoveredSlot.getItem();
        if (itemStack.isEmpty()) {
            return;
        }
        Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem(itemStack);
        if (wynnItemOpt.isEmpty()) {
            return;
        }
        WynnItem wynnItem = wynnItemOpt.get();
        if (!(wynnItem instanceof GearItem)) {
            return;
        }
        if (!this.unselectItemStack(itemStack)) {
            this.selectedItems.add(Pair.of(wynnItem, itemStack));
        }
    }

    private boolean isItemStackSelected(ItemStack newItem) {
        for (Pair<WynnItem, ItemStack> pair : this.selectedItems) {
            if (!ItemUtils.isItemEqual(pair.b(), newItem)) continue;
            return true;
        }
        return false;
    }

    private boolean unselectItemStack(ItemStack newItem) {
        for (int i = 0; i < this.selectedItems.size(); ++i) {
            if (!ItemUtils.isItemEqual(this.selectedItems.get(i).b(), newItem)) continue;
            this.selectedItems.remove(i);
            return true;
        }
        return false;
    }

    private String getTag(String key) {
        return I18n.get((String)key, (Object[])new Object[0]);
    }

    private void drawSelectionArc(PoseStack poseStack, ItemStack itemStack, int slotX, int slotY, boolean hotbar) {
        Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem(itemStack);
        if (wynnItemOpt.isEmpty()) {
            return;
        }
        if (this.isItemStackSelected(itemStack)) {
            RenderUtils.drawArc(poseStack, CommonColors.LIGHT_BLUE, slotX, slotY, hotbar ? 0.0f : 200.0f, 1.0f, 6, 8);
        }
    }

    private List<Component> getWynnOrVanillaLines(AbstractContainerScreen<?> screen, WynnItem wynnItem, ItemStack itemStack) {
        List wynnTooltip = TooltipUtils.getWynnItemTooltip(itemStack, wynnItem);
        return wynnTooltip.isEmpty() ? AbstractContainerScreen.getTooltipFromItem((Minecraft)McUtils.mc(), (ItemStack)itemStack) : wynnTooltip;
    }

    private MutableComponent getPaddedComponent(String string, int tooltipWidth) {
        Font font = FontRenderer.getInstance().getFont();
        int count = Math.round((float)(tooltipWidth - font.width(string)) / 2.0f / (float)font.width(" "));
        return Component.literal((String)(" ".repeat(count) + string));
    }

    private void removeFlavourText(List<Component> lines) {
        TextColor loreColor = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.DARK_GRAY);
        for (int i = lines.size() - 1; i >= 0; --i) {
            Component line = lines.get(i);
            StyledText styledText = StyledText.fromComponent(line);
            if (styledText.getPartCount() <= 0) continue;
            if (styledText.getFirstPart().getComponent().getStyle().getColor().equals((Object)loreColor)) {
                lines.remove(i);
                continue;
            }
            if (!ItemUtils.ITEM_RARITY_PATTERN.matcher(line.getString()).find()) continue;
            return;
        }
    }

    private void removeSetInfoText(List<Component> lines) {
        for (int i = lines.size() - 1; i >= 0; --i) {
            StyledText line = StyledText.fromComponent(lines.get(i)).getNormalized();
            if (line.getMatcher(WynnItemParser.SET_ITEM_PATTERN).matches()) {
                lines.remove(i);
                continue;
            }
            if (!line.getMatcher(WynnItemParser.SET_PATTERN).matches()) continue;
            lines.remove(i);
            lines.remove(i - 1);
            return;
        }
    }

    private void centerItemName(List<Component> lines, int tooltipWidth) {
        Component title = lines.removeFirst();
        String string = this.getPaddedComponent(title.getString(), tooltipWidth).getString();
        int count = string.indexOf(string.trim());
        MutableComponent newTitle = Component.literal((String)" ".repeat(count));
        title.getSiblings().forEach(arg_0 -> ((MutableComponent)newTitle).append(arg_0));
        lines.addFirst((Component)newTitle);
    }

    private void fixTooltipOverflow(List<Tooltip> tooltips, int screenHeight) {
        ArrayList<Tooltip> overflowTooltips = new ArrayList<Tooltip>();
        while (tooltips.getLast().getX() < 0) {
            overflowTooltips.add(tooltips.removeLast());
        }
        overflowTooltips.sort(Comparator.comparingInt(Tooltip::getHeight));
        ArrayList<Tooltip> heightSortedTooltips = new ArrayList<Tooltip>(tooltips);
        heightSortedTooltips.sort(Comparator.comparingInt(Tooltip::getHeight));
        Collections.reverse(heightSortedTooltips);
        if (heightSortedTooltips.size() > overflowTooltips.size()) {
            heightSortedTooltips.subList(0, heightSortedTooltips.size() - overflowTooltips.size()).clear();
        } else if (heightSortedTooltips.size() < overflowTooltips.size()) {
            overflowTooltips.subList(heightSortedTooltips.size(), overflowTooltips.size() - 1).clear();
        }
        for (int i = 0; i < heightSortedTooltips.size(); ++i) {
            float scaleFactor;
            Tooltip overflow = (Tooltip)overflowTooltips.get(i);
            Tooltip tooltip = (Tooltip)heightSortedTooltips.get(i);
            int index = tooltips.indexOf(tooltip);
            float tooltipScaleFactor = 1.0f;
            float overflowScaleFactor = 1.0f;
            int tooltipHeight = tooltip.getHeight();
            int overflowHeight = overflow.getHeight();
            int tooltipWidth = tooltip.getWidth();
            int overflowWidth = overflow.getWidth();
            if ((float)(tooltipHeight + overflowHeight) + 24.0f > (float)screenHeight) {
                scaleFactor = ((float)screenHeight - 24.0f) / (float)(tooltipHeight + overflowHeight);
                if (scaleFactor < 0.5f) continue;
                tooltipScaleFactor *= scaleFactor;
                overflowScaleFactor *= scaleFactor;
                int offsetX = (int)((float)tooltipWidth * (1.0f - scaleFactor));
                for (int j = index; j < tooltips.size(); ++j) {
                    Tooltip t = tooltips.get(j);
                    t.offsetX(offsetX);
                }
                tooltipHeight = (int)((float)tooltipHeight * scaleFactor);
                overflowHeight = (int)((float)overflowHeight * scaleFactor);
                tooltipWidth = (int)((float)tooltipWidth * scaleFactor);
                overflowWidth = (int)((float)overflowWidth * scaleFactor);
            }
            if (overflowWidth > tooltipWidth) {
                scaleFactor = (float)tooltipWidth / (float)overflowWidth;
                overflowScaleFactor *= scaleFactor;
                overflowHeight = (int)((float)overflowHeight * scaleFactor);
            }
            int tooltipY = 6;
            int overflowY = tooltipY + tooltipHeight + 12;
            int d1 = tooltipY;
            int d2 = screenHeight - overflowY - overflowHeight;
            int offsetY = Math.floorDiv(d1 + d2, 2) - Math.min(d1, d2);
            tooltip.setY(tooltipY += offsetY);
            tooltip.multScaleFactor(tooltipScaleFactor);
            overflow.setX(tooltip.getX());
            overflow.setY(overflowY += offsetY);
            overflow.multScaleFactor(overflowScaleFactor);
            tooltips.add(index, overflow);
        }
    }

    private static final class PassiveTooltipPositioner
    implements ClientTooltipPositioner {
        private static final ClientTooltipPositioner INSTANCE = new PassiveTooltipPositioner();

        private PassiveTooltipPositioner() {
        }

        public Vector2ic positionTooltip(int screenWidth, int screenHeight, int mouseX, int mouseY, int tooltipWidth, int tooltipHeight) {
            return new Vector2i(mouseX, mouseY);
        }
    }

    private static final class Tooltip {
        private final List<Component> lines;
        private int x;
        private int y;
        private final int width;
        private final int height;
        private float scaleFactor;
        private final Optional<TooltipComponent> visualTooltipComponent;

        private Tooltip(List<Component> lines, int x, int y, int width, int height, float scaleFactor, Optional<TooltipComponent> visualTooltipComponent) {
            this.lines = lines;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.scaleFactor = scaleFactor;
            this.visualTooltipComponent = visualTooltipComponent;
        }

        public List<Component> getLines() {
            return Collections.unmodifiableList(this.lines);
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public float getScaleFactor() {
            return this.scaleFactor;
        }

        public Optional<TooltipComponent> getVisualTooltipComponent() {
            return this.visualTooltipComponent;
        }

        public void setX(int x) {
            this.x = x;
        }

        public void setY(int y) {
            this.y = y;
        }

        public void offsetX(int offset) {
            this.x += offset;
        }

        public void multScaleFactor(float k) {
            this.scaleFactor *= k;
        }
    }
}

