/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.trademarket;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.models.account.AccountModel;
import com.wynntils.models.containers.containers.trademarket.TradeMarketSellContainer;
import com.wynntils.models.trademarket.event.TradeMarketSellDialogueUpdatedEvent;
import com.wynntils.models.trademarket.type.TradeMarketPriceCheckInfo;
import com.wynntils.models.trademarket.type.TradeMarketState;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.wynn.ContainerUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.TRADEMARKET)
public class TradeMarketPriceMatchFeature
extends Feature {
    @Persisted
    private final Config<Integer> undercutBy = new Config<Integer>(0);
    private boolean sendPriceMessage = false;
    private long priceToSend = 0L;

    @SubscribeEvent
    public void onSellDialogueUpdated(TradeMarketSellDialogueUpdatedEvent e) {
        Screen screen = McUtils.mc().screen;
        if (!(screen instanceof ContainerScreen)) {
            return;
        }
        ContainerScreen containerScreen = (ContainerScreen)screen;
        if (!(Models.Container.getCurrentContainer() instanceof TradeMarketSellContainer)) {
            return;
        }
        this.removePriceButtons(containerScreen);
        this.addPriceButtons(containerScreen);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onChatMessage(ChatMessageEvent.Match e) {
        if (!this.sendPriceMessage) {
            return;
        }
        if (Models.TradeMarket.getTradeMarketState() != TradeMarketState.PRICE_CHAT_INPUT) {
            return;
        }
        WynntilsMod.info("Trying to set trade market price to " + this.priceToSend);
        McUtils.sendChat(String.valueOf(this.priceToSend));
        e.setCanceled(true);
        this.sendPriceMessage = false;
    }

    private void addPriceButtons(ContainerScreen containerScreen) {
        TradeMarketPriceCheckInfo priceCheckInfo = Models.TradeMarket.getPriceCheckInfo();
        int rightPos = containerScreen.leftPos + containerScreen.imageWidth + 1;
        if (priceCheckInfo.bid() != -1) {
            int taxedBid = priceCheckInfo.bid();
            int untaxedBid = Models.Emerald.getWithoutTax(taxedBid);
            MutableComponent buttonTooltip = Component.translatable((String)"feature.wynntils.tradeMarketPriceMatch.highestBuyOfferMatchesTooltip").append((Component)Component.literal((String)"\n\n")).append((Component)Component.translatable((String)"feature.wynntils.tradeMarketPriceMatch.recommendedPrice").withStyle(ChatFormatting.LIGHT_PURPLE)).append((Component)this.getPriceComponent(priceCheckInfo.recommendedPrice())).append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)"feature.wynntils.tradeMarketPriceMatch.youReceive").withStyle(ChatFormatting.GREEN)).append((Component)this.getPriceComponent(untaxedBid)).append((Component)(Models.Account.isSilverbullSubscriber() ? AccountModel.SILVERBULL_STAR : Component.empty())).append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)"feature.wynntils.tradeMarketPriceMatch.totalPrice").withStyle(ChatFormatting.GOLD)).append((Component)this.getPriceComponent(taxedBid));
            PriceButton priceButton = new PriceButton(rightPos, containerScreen.topPos + 30, untaxedBid, (Component)Component.translatable((String)"feature.wynntils.tradeMarketPriceMatch.highestBuyOffer"), (Component)buttonTooltip);
            containerScreen.addRenderableWidget((GuiEventListener)priceButton);
        }
        if (priceCheckInfo.ask() != -1) {
            int lowestAsk = priceCheckInfo.ask();
            int taxedBid = lowestAsk <= (Integer)this.undercutBy.get() ? 1 : lowestAsk - (Integer)this.undercutBy.get();
            int untaxedBid = Models.Emerald.getWithoutTax(taxedBid);
            MutableComponent buttonTooltip = (Integer)this.undercutBy.get() == 0 ? Component.translatable((String)"feature.wynntils.tradeMarketPriceMatch.lowestSellOfferMatchesTooltip") : Component.translatable((String)"feature.wynntils.tradeMarketPriceMatch.lowestSellOfferUndercutTooltip", (Object[])new Object[]{this.undercutBy.get()});
            buttonTooltip.append((Component)Component.literal((String)"\n\n")).append((Component)Component.translatable((String)"feature.wynntils.tradeMarketPriceMatch.recommendedPrice").withStyle(ChatFormatting.LIGHT_PURPLE)).append((Component)this.getPriceComponent(priceCheckInfo.recommendedPrice())).append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)"feature.wynntils.tradeMarketPriceMatch.youReceive").withStyle(ChatFormatting.GREEN)).append((Component)this.getPriceComponent(untaxedBid)).append((Component)(Models.Account.isSilverbullSubscriber() ? AccountModel.SILVERBULL_STAR : Component.empty())).append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)"feature.wynntils.tradeMarketPriceMatch.totalPrice").withStyle(ChatFormatting.GOLD)).append((Component)this.getPriceComponent(taxedBid));
            PriceButton priceButton = new PriceButton(rightPos, containerScreen.topPos + 51, untaxedBid, (Component)Component.translatable((String)"feature.wynntils.tradeMarketPriceMatch.lowestSellOffer"), (Component)buttonTooltip);
            containerScreen.addRenderableWidget((GuiEventListener)priceButton);
        }
    }

    private MutableComponent getPriceComponent(int price) {
        return Component.literal((String)Models.Emerald.getEmeraldCountString(price, false)).withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)(" (" + Models.Emerald.getFormattedString(price, false) + ")")).withStyle(ChatFormatting.GRAY));
    }

    private void removePriceButtons(ContainerScreen containerScreen) {
        containerScreen.children.stream().filter(child -> child instanceof PriceButton).toList().forEach(arg_0 -> ((ContainerScreen)containerScreen).removeWidget(arg_0));
    }

    private final class PriceButton
    extends WynntilsButton {
        private static final int BUTTON_WIDTH = 100;
        private static final int BUTTON_HEIGHT = 20;
        private final int price;

        private PriceButton(int x, int y, int priceNoTax, Component name, Component hoverText) {
            super(x, y, 100, 20, name);
            this.price = priceNoTax;
            this.setTooltip(Tooltip.create((Component)hoverText));
        }

        public void onPress() {
            TradeMarketPriceMatchFeature.this.priceToSend = this.price;
            TradeMarketPriceMatchFeature.this.sendPriceMessage = true;
            ContainerUtils.clickOnSlot(28, McUtils.containerMenu().containerId, 0, (List<ItemStack>)McUtils.containerMenu().getItems());
        }
    }
}

