/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.ui;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.mod.TickSchedulerManager;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.mc.event.LoadingProgressEvent;
import com.wynntils.mc.event.ScreenClosedEvent;
import com.wynntils.mc.event.ScreenOpenedEvent;
import com.wynntils.mc.event.ServerResourcePackEvent;
import com.wynntils.mc.event.SubtitleSetTextEvent;
import com.wynntils.mc.event.TickAlwaysEvent;
import com.wynntils.mc.event.TitleSetTextEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.screens.loading.LoadingScreen;
import com.wynntils.utils.mc.McUtils;
import java.util.regex.Pattern;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UI)
public class CustomLoadingScreenFeature
extends Feature {
    private static final String IGNORED_TITLE = "\ue000\ue001\ue000";
    private static final Pattern SERVER_SWITCH_PATTERN = Pattern.compile("\u00a77Saving your player data before switching to \u00a7f(.*)\u00a77...");
    private LoadingScreen loadingScreen;
    private Screen replacedScreen;
    private TickSchedulerManager.ScheduledTask delayedRemoval;
    private boolean allowClosing;

    @SubscribeEvent
    public void onTickAlways(TickAlwaysEvent e) {
        if (this.replacedScreen != null) {
            this.replacedScreen.tick();
        }
    }

    @SubscribeEvent
    public void onChatMessageReceived(ChatMessageEvent.Match e) {
        if (e.getMessage().matches(SERVER_SWITCH_PATTERN)) {
            this.createCustomScreen();
            this.loadingScreen.setMessage(I18n.get((String)"feature.wynntils.customLoadingScreen.switchingServer", (Object[])new Object[0]));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onScreenClosed(ScreenClosedEvent.Pre event) {
        if (this.allowClosing) {
            return;
        }
        if (this.isCustomScreenVisible()) {
            event.setCanceled(true);
        }
        if (this.replacedScreen != null) {
            this.replacedScreen.removed();
            this.replacedScreen = null;
        }
        if (McUtils.mc().level == null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onScreenOpened(ScreenOpenedEvent.Pre event) {
        TranslatableContents tc;
        ComponentContents componentContents;
        Screen screen = event.getScreen();
        if (screen instanceof LoadingScreen) {
            return;
        }
        if (this.replacedScreen != null) {
            this.replacedScreen.removed();
            this.replacedScreen = null;
        }
        String messageUpdate = null;
        if (screen instanceof ProgressScreen) {
            ProgressScreen ps = (ProgressScreen)screen;
            messageUpdate = "feature.wynntils.customLoadingScreen.working";
        }
        if (screen instanceof ConnectScreen) {
            ConnectScreen cs = (ConnectScreen)screen;
            componentContents = cs.status.getContents();
            if (componentContents instanceof TranslatableContents && (tc = (TranslatableContents)componentContents).getKey().equals("connect.transferring")) {
                messageUpdate = "feature.wynntils.customLoadingScreen.transferConnecting";
            }
        }
        if (screen instanceof DisconnectedScreen) {
            DisconnectedScreen ds = (DisconnectedScreen)screen;
            componentContents = ds.details.reason().getContents();
            if (componentContents instanceof TranslatableContents && (tc = (TranslatableContents)componentContents).getKey().equals("disconnect.transfer")) {
                messageUpdate = "feature.wynntils.customLoadingScreen.transferRequest";
            }
        }
        if (screen instanceof ReceivingLevelScreen) {
            messageUpdate = "feature.wynntils.customLoadingScreen.receivingTerrain";
        }
        if (!this.isCustomScreenVisible()) {
            if (!Managers.Connection.onServer()) {
                return;
            }
            if (messageUpdate == null) {
                return;
            }
            this.createCustomScreen();
        }
        if (messageUpdate != null) {
            this.loadingScreen.setMessage(I18n.get((String)messageUpdate, (Object[])new Object[0]));
        }
        this.replacedScreen = screen;
        screen.init(McUtils.mc(), 1, 1);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onLoadingProgress(LoadingProgressEvent event) {
        if (!this.isCustomScreenVisible()) {
            return;
        }
        this.loadingScreen.setMessage(event.getMessage());
    }

    @SubscribeEvent
    public void onResourcePack(ServerResourcePackEvent.Load e) {
        if (!this.isCustomScreenVisible()) {
            return;
        }
        this.loadingScreen.setMessage(I18n.get((String)"feature.wynntils.customLoadingScreen.resourcePack", (Object[])new Object[0]));
    }

    @SubscribeEvent
    public void onTitleSetText(TitleSetTextEvent e) {
        if (!this.isCustomScreenVisible()) {
            return;
        }
        if (e.getComponent().getString().equals(IGNORED_TITLE)) {
            return;
        }
        this.loadingScreen.setStageTitle(e.getComponent().getString());
    }

    @SubscribeEvent
    public void onSubtitleSetText(SubtitleSetTextEvent e) {
        if (!this.isCustomScreenVisible()) {
            return;
        }
        this.loadingScreen.setSubtitle(e.getComponent().getString());
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        switch (event.getNewState()) {
            case CONNECTING: {
                this.createCustomScreen();
                this.loadingScreen.setMessage(I18n.get((String)"feature.wynntils.customLoadingScreen.connecting", (Object[])new Object[0]));
                break;
            }
            case INTERIM: {
                if (!this.isCustomScreenVisible()) {
                    this.createCustomScreen();
                }
                this.cancelDelayedRemoval();
                this.loadingScreen.setMessage(I18n.get((String)"feature.wynntils.customLoadingScreen.joiningWorld", (Object[])new Object[0]));
                break;
            }
            case HUB: {
                if (!this.isCustomScreenVisible()) {
                    return;
                }
                this.delayedRemoval = Managers.TickScheduler.scheduleLater(this::removeCustomScreen, 20);
                break;
            }
            case WORLD: 
            case NOT_CONNECTED: 
            case CHARACTER_SELECTION: {
                if (!this.isCustomScreenVisible()) {
                    return;
                }
                this.cancelDelayedRemoval();
                this.delayedRemoval = Managers.TickScheduler.scheduleLater(this::removeCustomScreen, 20);
            }
        }
    }

    private boolean isCustomScreenVisible() {
        return this.loadingScreen != null;
    }

    private void createCustomScreen() {
        this.loadingScreen = LoadingScreen.create(this::onLoadingScreenClosed);
        this.allowClosing = false;
        McUtils.mc().setScreen((Screen)this.loadingScreen);
    }

    private void removeCustomScreen() {
        this.delayedRemoval = null;
        this.loadingScreen = null;
        if (McUtils.mc().screen == null) {
            WynntilsMod.error("The custom LoadingScreen has disappeared");
        } else {
            McUtils.mc().setScreen(null);
        }
    }

    private void onLoadingScreenClosed() {
        this.allowClosing = true;
        if (this.replacedScreen != null) {
            this.replacedScreen.onClose();
        }
        this.delayedRemoval = null;
        this.loadingScreen = null;
    }

    private void cancelDelayedRemoval() {
        if (this.delayedRemoval != null) {
            Managers.TickScheduler.cancel(this.delayedRemoval);
            this.delayedRemoval = null;
        }
    }
}

