/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.utilities;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.persisted.config.HiddenConfig;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.models.character.event.CharacterUpdateEvent;
import com.wynntils.utils.mc.McUtils;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UTILITIES)
public class PerCharacterGuildContributionFeature
extends Feature {
    private static final Pattern CONTRIBUTION_PATTERN = Pattern.compile("\u00a73You will now contribute \u00a7b(\\d+)%\u00a73 of your XP to \u00a7b.*\u00a73.");
    @Persisted
    private final HiddenConfig<Map<String, Integer>> characterContributions = new HiddenConfig(new TreeMap());
    @Persisted
    private final Config<Boolean> hideContributionMessage = new Config<Boolean>(true);
    private boolean waitingForCommandResponse = false;

    @SubscribeEvent
    public void onCharacterChange(CharacterUpdateEvent e) {
        if (Models.Guild.getGuildName().isEmpty()) {
            return;
        }
        int amountToContribute = ((Map)this.characterContributions.get()).getOrDefault(Models.Character.getId(), -1);
        if (amountToContribute != -1) {
            this.waitingForCommandResponse = true;
            Handlers.Command.queueCommand("guild xp " + amountToContribute);
        }
    }

    @SubscribeEvent
    public void onChatReceived(ChatMessageEvent.Match event) {
        if (Models.Guild.getGuildName().isEmpty()) {
            return;
        }
        if (!Models.Character.hasCharacter()) {
            return;
        }
        StyledText message = event.getMessage();
        Matcher contributionMatcher = message.getMatcher(CONTRIBUTION_PATTERN);
        if (contributionMatcher.matches()) {
            event.setCanceled(true);
            if (this.waitingForCommandResponse) {
                this.waitingForCommandResponse = false;
                if (!((Boolean)this.hideContributionMessage.get()).booleanValue()) {
                    this.sendContributionMessage((Integer)((Map)this.characterContributions.get()).get(Models.Character.getId()));
                }
                return;
            }
            int contributionAmount = Integer.parseInt(contributionMatcher.group(1));
            if (contributionAmount < 0 || contributionAmount > 100) {
                return;
            }
            ((Map)this.characterContributions.get()).put(Models.Character.getId(), contributionAmount);
            this.characterContributions.touched();
            this.sendContributionMessage(contributionAmount);
        }
    }

    private void sendContributionMessage(int contributionAmount) {
        MutableComponent contributionMessage = Component.literal((String)(String.valueOf(ChatFormatting.DARK_AQUA) + "You will now contribute " + String.valueOf(ChatFormatting.AQUA) + contributionAmount + "%" + String.valueOf(ChatFormatting.DARK_AQUA) + " of your XP to " + String.valueOf(ChatFormatting.AQUA) + Models.Guild.getGuildName() + String.valueOf(ChatFormatting.DARK_AQUA) + ".\n"));
        contributionMessage.append((Component)Component.literal((String)"This will only apply to your current character.\n").withStyle(ChatFormatting.DARK_AQUA));
        contributionMessage.append((Component)Component.literal((String)"Click here").withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wynntils feature disable " + this.getShortName()))));
        contributionMessage.append((Component)Component.literal((String)" to disable this functionality.").withStyle(ChatFormatting.DARK_AQUA));
        McUtils.sendMessageToClient((Component)contributionMessage);
    }
}

