/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.wynntils;

import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.crowdsource.type.CrowdSourcedDataType;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.persisted.config.HiddenConfig;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.ConfirmedBoolean;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.WYNNTILS)
public class DataCrowdSourcingFeature
extends Feature {
    @Persisted
    public final HiddenConfig<Map<CrowdSourcedDataType, ConfirmedBoolean>> crowdSourcedDataTypeEnabledMap = new HiddenConfig(new TreeMap());

    @SubscribeEvent
    public void onWorldChange(WorldStateEvent event) {
        if (event.getNewState() != WorldState.WORLD) {
            return;
        }
        Map enabledMap = (Map)this.crowdSourcedDataTypeEnabledMap.get();
        List<CrowdSourcedDataType> nonConfirmedDataTypes = Arrays.stream(CrowdSourcedDataType.values()).filter(dataType -> !enabledMap.containsKey(dataType)).toList();
        if (nonConfirmedDataTypes.isEmpty()) {
            return;
        }
        MutableComponent component = Component.literal((String)"Wynntils Crowd Sourcing\n").withStyle(ChatFormatting.AQUA);
        component.append((Component)Component.literal((String)"Wynntils can collect data during your\ngameplay to improve the mod.\nThis data does not contain any personal information,\nand is only stored locally on your computer.\nTo share this data with the Wynntils team,\nyou must copy it to the clipboard and send it to us,\nduring periods when we are collecting data.\n").withStyle(ChatFormatting.GRAY));
        component.append((Component)Component.literal((String)"\nThe following data types are not confirmed to be collected:\n"));
        for (CrowdSourcedDataType dataType2 : nonConfirmedDataTypes) {
            component.append((Component)Component.literal((String)" - ").withStyle(ChatFormatting.GRAY));
            component.append((Component)Component.literal((String)dataType2.getTranslatedName()).withStyle(ChatFormatting.YELLOW));
            component.append((Component)Component.literal((String)"\n"));
        }
        component.append((Component)Component.literal((String)"\nYou can confirm or deny the collection of each data type in the Wynntils Crowd Sourcing Screen, which you can access from the Wynntils Menu."));
        McUtils.sendMessageToClient((Component)component);
    }
}

