/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.wynntils;

import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.AddEntityLookupEvent;
import com.wynntils.mc.event.PlayerInfoUpdateEvent;
import com.wynntils.mc.event.PlayerTeamEvent;
import com.wynntils.mc.event.SetEntityPassengersEvent;
import com.wynntils.mc.event.SetPlayerTeamEvent;
import com.wynntils.utils.mc.McUtils;
import java.util.List;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.WYNNTILS)
public class FixPacketBugsFeature
extends Feature {
    private static final int METHOD_ADD = 0;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onSetPlayerTeamPacket(SetPlayerTeamEvent event) {
        if (McUtils.mc().level == null) {
            return;
        }
        if (event.getMethod() != 0 && McUtils.mc().level.getScoreboard().getPlayerTeam(event.getTeamName()) == null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRemovePlayerFromTeam(PlayerTeamEvent.Removed event) {
        if (McUtils.mc().level == null) {
            return;
        }
        PlayerTeam playerTeamFromUserName = McUtils.mc().level.getScoreboard().getPlayersTeam(event.getUsername());
        if (playerTeamFromUserName != event.getPlayerTeam()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onSetEntityPassengersPacket(SetEntityPassengersEvent event) {
        if (McUtils.mc().level == null) {
            return;
        }
        Entity entity = McUtils.mc().level.getEntity(event.getVehicle());
        if (entity == null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAddEntityLookup(AddEntityLookupEvent event) {
        if (event.getEntityMap().containsKey(event.getUUID())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInfoUpdate(PlayerInfoUpdateEvent event) {
        ClientPacketListener connection = McUtils.mc().getConnection();
        List<ClientboundPlayerInfoUpdatePacket.Entry> replacementEntries = event.getEntries().stream().filter(entry -> connection.getPlayerInfo(entry.profileId()) != null || event.getNewEntries().stream().anyMatch(newEntry -> newEntry.profileId().equals(entry.profileId()))).toList();
        if (replacementEntries.size() == event.getEntries().size()) {
            return;
        }
        event.setEntries(replacementEntries);
    }
}

