/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.functions;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.functions.Function;
import com.wynntils.core.consumers.functions.arguments.Argument;
import com.wynntils.core.consumers.functions.arguments.FunctionArguments;
import com.wynntils.models.statuseffects.type.StatusEffect;
import com.wynntils.utils.type.NamedValue;
import java.util.List;
import net.minecraft.client.resources.language.I18n;

public class StatusEffectFunctions {

    public static class StatusEffectPrefixFunction
    extends StatusEffectFunctionBase<String> {
        @Override
        public String processEffect(StatusEffect effect) {
            return effect.getPrefix().getString();
        }

        @Override
        public String whenNotFound() {
            return "";
        }
    }

    public static class StatusEffectModifierFunction
    extends StatusEffectFunctionBase<NamedValue> {
        @Override
        public NamedValue processEffect(StatusEffect effect) {
            if (!effect.hasModifierValue()) {
                return this.whenNotFound();
            }
            return new NamedValue(effect.getModifierSuffix().getString(), effect.getModifierValue());
        }

        @Override
        public NamedValue whenNotFound() {
            return NamedValue.EMPTY;
        }
    }

    public static class StatusEffectDurationFunction
    extends StatusEffectFunctionBase<NamedValue> {
        @Override
        public NamedValue processEffect(StatusEffect effect) {
            return new NamedValue(effect.getName().getString(), effect.getDuration());
        }

        @Override
        public NamedValue whenNotFound() {
            return NamedValue.EMPTY;
        }
    }

    public static class StatusEffectActiveFunction
    extends Function<Boolean> {
        @Override
        public Boolean getValue(FunctionArguments arguments) {
            String query = arguments.getArgument("query").getStringValue();
            return Models.StatusEffect.getStatusEffects().stream().anyMatch(statusEffect -> statusEffect.getName().getStringWithoutFormatting().equals(query));
        }

        @Override
        protected List<String> getAliases() {
            return List.of("contains_effect");
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("query", String.class, null)));
        }
    }

    public static class StatusEffectsFunction
    extends Function<String> {
        @Override
        public String getValue(FunctionArguments arguments) {
            List<String> statusEffectsList = Models.StatusEffect.getStatusEffects().stream().map(statusEffect -> statusEffect.asString().getString()).toList();
            return String.join((CharSequence)"\n", statusEffectsList);
        }
    }

    private static abstract class StatusEffectFunctionBase<T>
    extends Function<T> {
        private StatusEffectFunctionBase() {
        }

        @Override
        public T getValue(FunctionArguments arguments) {
            String query = arguments.getArgument("query").getStringValue();
            StatusEffect effect = Models.StatusEffect.searchStatusEffectByName(query);
            if (effect == null) {
                return this.whenNotFound();
            }
            return this.processEffect(effect);
        }

        @Override
        public String getArgumentDescription(String argumentName) {
            return I18n.get((String)("function.wynntils.statusEffectFunctionBase.argument." + argumentName), (Object[])new Object[0]);
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("query", String.class, null)));
        }

        public abstract T processEffect(StatusEffect var1);

        public abstract T whenNotFound();
    }
}

