/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.functions.generic;

import com.wynntils.core.consumers.functions.GenericFunction;
import com.wynntils.core.consumers.functions.arguments.AnyArgument;
import com.wynntils.core.consumers.functions.arguments.Argument;
import com.wynntils.core.consumers.functions.arguments.FunctionArguments;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.type.CappedValue;
import java.util.List;

public class ConditionalFunctions {

    public static class IfCustomColorFunction
    extends IfFunctionBase<CustomColor> {
        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("condition", Boolean.class, null), new Argument<Object>("ifTrue", CustomColor.class, null), new Argument<Object>("ifFalse", CustomColor.class, null)));
        }

        @Override
        protected List<String> getAliases() {
            return List.of("if_color", "if_customcolor");
        }
    }

    public static class IfCappedValueFunction
    extends IfFunctionBase<CappedValue> {
        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("condition", Boolean.class, null), new Argument<Object>("ifTrue", CappedValue.class, null), new Argument<Object>("ifFalse", CappedValue.class, null)));
        }

        @Override
        protected List<String> getAliases() {
            return List.of("if_capped", "if_cap");
        }
    }

    public static class IfNumberFunction
    extends IfFunctionBase<Number> {
        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("condition", Boolean.class, null), new Argument<Object>("ifTrue", Number.class, null), new Argument<Object>("ifFalse", Number.class, null)));
        }

        @Override
        protected List<String> getAliases() {
            return List.of("if_num");
        }
    }

    public static class IfStringFunction
    extends IfFunctionBase<String> {
        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("condition", Boolean.class, null), new Argument<Object>("ifTrue", String.class, null), new Argument<Object>("ifFalse", String.class, null)));
        }

        @Override
        protected List<String> getAliases() {
            return List.of("if_str");
        }
    }

    public static class IfFunction
    extends IfFunctionBase<Object> {
        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("condition", Boolean.class, null), new AnyArgument("ifTrue"), new AnyArgument("ifFalse")));
        }
    }

    private static abstract class IfFunctionBase<T>
    extends GenericFunction<Object> {
        private IfFunctionBase() {
        }

        @Override
        public Object getValue(FunctionArguments arguments) {
            if (arguments.getArgument("condition").getBooleanValue().booleanValue()) {
                return arguments.getArgument("ifTrue").getValue();
            }
            return arguments.getArgument("ifFalse").getValue();
        }
    }
}

