/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.bossbar;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handler;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.bossbar.TrackedBar;
import com.wynntils.handlers.bossbar.event.BossBarAddedEvent;
import com.wynntils.mc.event.BossHealthUpdateEvent;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.world.BossEvent;
import net.neoforged.bus.api.SubscribeEvent;

public final class BossBarHandler
extends Handler {
    private final Map<UUID, TrackedBar> presentBars = new HashMap<UUID, TrackedBar>();
    private final List<TrackedBar> knownBars = new ArrayList<TrackedBar>();

    public void registerBar(TrackedBar trackedBar) {
        this.knownBars.add(trackedBar);
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onHealthBarEvent(BossHealthUpdateEvent event) {
        ClientboundBossEventPacket packet = event.getPacket();
        packet.dispatch((ClientboundBossEventPacket.Handler)new TrackedBarHandler(event));
    }

    private final class TrackedBarHandler
    implements ClientboundBossEventPacket.Handler {
        private final BossHealthUpdateEvent event;

        private TrackedBarHandler(BossHealthUpdateEvent event) {
            this.event = event;
        }

        public void add(UUID id, Component name, float progress, BossEvent.BossBarColor color, BossEvent.BossBarOverlay overlay, boolean darkenScreen, boolean playMusic, boolean createWorldFog) {
            Optional<Pair<TrackedBar, Matcher>> trackedBarOpt = this.matchBar(name);
            if (trackedBarOpt.isEmpty()) {
                return;
            }
            TrackedBar trackedBar = trackedBarOpt.get().a();
            Matcher matcher = trackedBarOpt.get().b();
            LerpingBossEvent bossEvent = new LerpingBossEvent(id, name, progress, color, overlay, darkenScreen, playMusic, createWorldFog);
            trackedBar.setEvent(bossEvent);
            BossBarAddedEvent barAddEvent = new BossBarAddedEvent(trackedBar);
            WynntilsMod.postEvent(barAddEvent);
            if (barAddEvent.isCanceled()) {
                trackedBar.setRendered(false);
                this.event.setCanceled(true);
            } else {
                trackedBar.setRendered(true);
            }
            trackedBar.onUpdateName(matcher);
            trackedBar.onUpdateProgress(progress);
            BossBarHandler.this.presentBars.put(id, trackedBar);
        }

        private void handleBarUpdate(UUID id, Consumer<TrackedBar> consumer) {
            TrackedBar trackedBar = BossBarHandler.this.presentBars.get(id);
            if (trackedBar != null) {
                if (!trackedBar.isRendered()) {
                    this.event.setCanceled(true);
                }
                consumer.accept(trackedBar);
            }
        }

        private Optional<Pair<TrackedBar, Matcher>> matchBar(Component name) {
            return BossBarHandler.this.knownBars.stream().flatMap(trackedBar -> trackedBar.patterns.stream().map(pattern -> new Pair<TrackedBar, Pattern>((TrackedBar)trackedBar, (Pattern)pattern))).map(pair -> new Pair<TrackedBar, Matcher>((TrackedBar)pair.a(), StyledText.fromComponent(name).getMatcher((Pattern)pair.b()))).filter(pair -> ((Matcher)pair.b()).matches()).findFirst();
        }

        public void remove(UUID id) {
            this.handleBarUpdate(id, trackedBar -> {
                trackedBar.reset();
                BossBarHandler.this.presentBars.remove(id);
            });
        }

        public void updateProgress(UUID id, float progress) {
            this.handleBarUpdate(id, trackedBar -> {
                trackedBar.getEvent().setProgress(progress);
                trackedBar.onUpdateProgress(progress);
            });
        }

        public void updateName(UUID id, Component name) {
            if (!BossBarHandler.this.presentBars.containsKey(id)) {
                Optional<Pair<TrackedBar, Matcher>> trackedBarOpt = this.matchBar(name);
                trackedBarOpt.ifPresent(trackedBarMatcherPair -> BossBarHandler.this.presentBars.put(id, (TrackedBar)trackedBarMatcherPair.a()));
            }
            this.handleBarUpdate(id, trackedBar -> {
                StyledText nameText = StyledText.fromComponent(name);
                for (Pattern pattern : trackedBar.patterns) {
                    Matcher matcher = nameText.getMatcher(pattern);
                    if (!matcher.matches()) continue;
                    trackedBar.onUpdateName(matcher);
                    return;
                }
                WynntilsMod.error("Failed to match already matched boss bar");
            });
        }

        public void updateStyle(UUID id, BossEvent.BossBarColor color, BossEvent.BossBarOverlay overlay) {
            this.handleBarUpdate(id, trackedBar -> {});
        }

        public void updateProperties(UUID id, boolean darkenScreen, boolean playMusic, boolean createWorldFog) {
            this.handleBarUpdate(id, trackedBar -> {});
        }
    }
}

