/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.container.scriptedquery;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.container.ContainerQueryException;
import com.wynntils.handlers.container.ContainerQueryStep;
import com.wynntils.handlers.container.scriptedquery.QueryBuilder;
import com.wynntils.handlers.container.scriptedquery.QueryStep;
import com.wynntils.handlers.container.type.ContainerContent;
import com.wynntils.handlers.container.type.ContainerContentChangeType;
import com.wynntils.utils.wynn.ItemUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.LinkedList;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class ScriptedContainerQuery
implements ContainerQueryStep {
    private final LinkedList<QueryStep> steps;
    private final Consumer<String> errorHandler;
    private final String name;
    private QueryStep currentStep = null;

    ScriptedContainerQuery(String name, LinkedList<QueryStep> steps, Consumer<String> errorHandler) {
        this.name = name;
        this.steps = steps;
        this.errorHandler = errorHandler;
    }

    public static QueryBuilder builder(String name) {
        return new QueryBuilder(name);
    }

    public static boolean containerHasSlot(ContainerContent container, int slotNum, Item expectedItemType, StyledText expectedItemName) {
        ItemStack itemStack = container.items().get(slotNum);
        return itemStack.is(expectedItemType) && ItemUtils.getItemName(itemStack).equals(expectedItemName);
    }

    public void executeQuery() {
        if (!this.popOneStep()) {
            return;
        }
        Handlers.ContainerQuery.runQuery(this);
    }

    @Override
    public boolean startStep(ContainerContent container) throws ContainerQueryException {
        return this.currentStep.startStep(this, container);
    }

    @Override
    public boolean verifyContainer(Component title, MenuType<?> menuType) {
        return this.currentStep.getVerification().verify(title, menuType);
    }

    @Override
    public boolean verifyContentChange(ContainerContent container, Int2ObjectMap<ItemStack> changes, ContainerContentChangeType changeType) {
        return this.currentStep.getContentVerification().verify(container, changes, changeType);
    }

    @Override
    public void handleContent(ContainerContent container) throws ContainerQueryException {
        this.currentStep.getHandleContent().processContainer(container);
    }

    @Override
    public ContainerQueryStep getNextStep(ContainerContent container) {
        return this.currentStep.getNextStep(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void onError(String errorMsg) {
        this.errorHandler.accept(errorMsg);
        this.currentStep = null;
        this.steps.clear();
    }

    boolean popOneStep() {
        if (this.steps.isEmpty()) {
            this.currentStep = null;
            return false;
        }
        this.currentStep = this.steps.pop();
        return true;
    }
}

