/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.tooltip;

import com.wynntils.core.components.Handler;
import com.wynntils.handlers.tooltip.TooltipBuilder;
import com.wynntils.handlers.tooltip.impl.crafted.CraftedTooltipBuilder;
import com.wynntils.handlers.tooltip.impl.crafted.CraftedTooltipComponent;
import com.wynntils.handlers.tooltip.impl.crafted.components.CraftedConsumableTooltipComponent;
import com.wynntils.handlers.tooltip.impl.crafted.components.CraftedGearTooltipComponent;
import com.wynntils.handlers.tooltip.impl.identifiable.IdentifiableTooltipBuilder;
import com.wynntils.handlers.tooltip.impl.identifiable.IdentifiableTooltipComponent;
import com.wynntils.handlers.tooltip.impl.identifiable.components.CharmTooltipComponent;
import com.wynntils.handlers.tooltip.impl.identifiable.components.GearTooltipComponent;
import com.wynntils.handlers.tooltip.impl.identifiable.components.TomeTooltipComponent;
import com.wynntils.models.items.items.game.CharmItem;
import com.wynntils.models.items.items.game.CraftedConsumableItem;
import com.wynntils.models.items.items.game.CraftedGearItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.items.game.TomeItem;
import com.wynntils.models.items.properties.CraftedItemProperty;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.ItemStack;

public final class TooltipHandler
extends Handler {
    private final Map<Class<? extends IdentifiableItemProperty>, IdentifiableTooltipComponent> identifiableTooltipComponents = new HashMap<Class<? extends IdentifiableItemProperty>, IdentifiableTooltipComponent>();
    private final Map<Class<? extends CraftedItemProperty>, CraftedTooltipComponent> craftedTooltipComponents = new HashMap<Class<? extends CraftedItemProperty>, CraftedTooltipComponent>();

    public TooltipHandler() {
        this.registerTooltipComponents();
    }

    public IdentifiableTooltipBuilder buildNew(IdentifiableItemProperty identifiableItem, boolean hideUnidentified, boolean showItemType) {
        return this.buildNew(identifiableItem, hideUnidentified, showItemType, "");
    }

    public IdentifiableTooltipBuilder buildNew(IdentifiableItemProperty identifiableItem, boolean hideUnidentified, boolean showItemType, String source) {
        IdentifiableTooltipComponent tooltipComponent = this.identifiableTooltipComponents.get(identifiableItem.getClass());
        if (tooltipComponent == null) {
            throw new IllegalArgumentException("No tooltip component registered for " + identifiableItem.getClass().getName());
        }
        return IdentifiableTooltipBuilder.buildNewItem(identifiableItem, tooltipComponent, hideUnidentified, showItemType, source);
    }

    public CraftedTooltipBuilder buildNew(CraftedItemProperty craftedItemProperty, String source) {
        CraftedTooltipComponent tooltipComponent = this.craftedTooltipComponents.get(craftedItemProperty.getClass());
        if (tooltipComponent == null) {
            throw new IllegalArgumentException("No tooltip component registered for " + craftedItemProperty.getClass().getName());
        }
        return CraftedTooltipBuilder.buildNewItem(craftedItemProperty, tooltipComponent, source);
    }

    public TooltipBuilder fromParsedItemStack(ItemStack itemStack, IdentifiableItemProperty itemInfo) {
        return IdentifiableTooltipBuilder.fromParsedItemStack(itemStack, itemInfo);
    }

    public TooltipBuilder fromParsedItemStack(ItemStack itemStack, CraftedItemProperty craftedItemProperty) {
        return CraftedTooltipBuilder.fromParsedItemStack(itemStack, craftedItemProperty);
    }

    private void registerTooltipComponents() {
        this.registerTooltipComponent(CharmItem.class, new CharmTooltipComponent());
        this.registerTooltipComponent(GearItem.class, new GearTooltipComponent());
        this.registerTooltipComponent(TomeItem.class, new TomeTooltipComponent());
        this.registerTooltipComponent(CraftedGearItem.class, new CraftedGearTooltipComponent());
        this.registerTooltipComponent(CraftedConsumableItem.class, new CraftedConsumableTooltipComponent());
    }

    private <T, U, I extends IdentifiableItemProperty<T, U>> void registerTooltipComponent(Class<I> itemClass, IdentifiableTooltipComponent<T, U> tooltipComponent) {
        this.identifiableTooltipComponents.put(itemClass, tooltipComponent);
    }

    private <T extends CraftedItemProperty> void registerTooltipComponent(Class<T> itemClass, CraftedTooltipComponent<T> tooltipComponent) {
        this.craftedTooltipComponents.put(itemClass, tooltipComponent);
    }
}

