/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.tooltip.impl.identifiable.components;

import com.wynntils.core.components.Models;
import com.wynntils.handlers.tooltip.impl.identifiable.IdentifiableTooltipComponent;
import com.wynntils.models.gear.type.GearRestrictions;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.rewards.type.CharmInfo;
import com.wynntils.models.rewards.type.CharmInstance;
import com.wynntils.models.rewards.type.CharmRequirements;
import com.wynntils.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CharmTooltipComponent
extends IdentifiableTooltipComponent<CharmInfo, CharmInstance> {
    @Override
    public List<Component> buildHeaderTooltip(CharmInfo charmInfo, CharmInstance charmInstance, boolean hideUnidentified) {
        ArrayList<Component> header = new ArrayList<Component>();
        String prefix = charmInstance == null && !hideUnidentified ? "Unidentified " : "";
        header.add((Component)Component.literal((String)(prefix + charmInfo.name())).withStyle(charmInfo.tier().getChatFormatting()));
        header.add((Component)Component.literal((String)"Keep in inventory to gain bonus").withStyle(ChatFormatting.GRAY));
        header.add((Component)Component.empty());
        CharmRequirements requirements = charmInfo.requirements();
        int level = requirements.level();
        if (level != 0) {
            boolean fulfilled = Models.CombatXp.getCombatLevel().current() >= level;
            header.add((Component)this.buildRequirementLine("Combat Lv. Min: " + level, fulfilled));
            header.add((Component)Component.empty());
        }
        return header;
    }

    @Override
    public List<Component> buildFooterTooltip(CharmInfo charmInfo, CharmInstance charmInstance, boolean showItemType) {
        ArrayList<Component> footer = new ArrayList<Component>();
        footer.add((Component)Component.empty());
        GearTier gearTier = charmInfo.tier();
        MutableComponent itemTypeName = showItemType ? Component.literal((String)"Charm") : Component.literal((String)"Raid Reward");
        MutableComponent tier = Component.literal((String)gearTier.getName()).withStyle(gearTier.getChatFormatting()).append(" ").append((Component)itemTypeName);
        if (charmInstance != null && charmInstance.rerolls() > 1) {
            tier.append(" [" + charmInstance.rerolls() + "]");
        }
        footer.add((Component)tier);
        if (charmInfo.metaInfo().restrictions() != GearRestrictions.NONE) {
            footer.add((Component)Component.literal((String)StringUtils.capitalizeFirst(charmInfo.metaInfo().restrictions().getDescription())).withStyle(ChatFormatting.RED));
        }
        return footer;
    }
}

