/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.tooltip.impl.identifiable.components;

import com.wynntils.core.components.Models;
import com.wynntils.handlers.tooltip.impl.identifiable.IdentifiableTooltipComponent;
import com.wynntils.models.gear.type.GearRestrictions;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.rewards.type.TomeInfo;
import com.wynntils.models.rewards.type.TomeInstance;
import com.wynntils.models.rewards.type.TomeRequirements;
import com.wynntils.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TomeTooltipComponent
extends IdentifiableTooltipComponent<TomeInfo, TomeInstance> {
    @Override
    public List<Component> buildHeaderTooltip(TomeInfo tomeInfo, TomeInstance tomeInstance, boolean hideUnidentified) {
        ArrayList<Component> header = new ArrayList<Component>();
        String prefix = tomeInstance == null && !hideUnidentified ? "Unidentified " : "";
        header.add((Component)Component.literal((String)(prefix + tomeInfo.name())).withStyle(tomeInfo.tier().getChatFormatting()));
        header.add((Component)Component.empty());
        TomeRequirements requirements = tomeInfo.requirements();
        int level = requirements.level();
        if (level != 0) {
            boolean fulfilled = Models.CombatXp.getCombatLevel().current() >= level;
            header.add((Component)this.buildRequirementLine("Combat Lv. Min: " + level, fulfilled));
            header.add((Component)Component.empty());
        }
        return header;
    }

    @Override
    public List<Component> buildFooterTooltip(TomeInfo tomeInfo, TomeInstance tomeInstance, boolean showItemType) {
        ArrayList<Component> footer = new ArrayList<Component>();
        footer.add((Component)Component.empty());
        GearTier gearTier = tomeInfo.tier();
        MutableComponent itemTypeName = showItemType ? Component.literal((String)"Tome") : Component.literal((String)"Raid Reward");
        MutableComponent tier = Component.literal((String)gearTier.getName()).withStyle(gearTier.getChatFormatting()).append(" ").append((Component)itemTypeName);
        if (tomeInstance != null && tomeInstance.rerolls() > 1) {
            tier.append(" [" + tomeInstance.rerolls() + "]");
        }
        footer.add((Component)tier);
        if (tomeInfo.metaInfo().restrictions() != GearRestrictions.NONE) {
            footer.add((Component)Component.literal((String)StringUtils.capitalizeFirst(tomeInfo.metaInfo().restrictions().getDescription())).withStyle(ChatFormatting.RED));
        }
        return footer;
    }
}

