/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.mc.mixin;

import com.wynntils.mc.extension.GuiMessageLineExtension;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.type.Pair;
import java.time.LocalDateTime;
import java.util.Optional;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiMessage.Line.class})
public abstract class GuiMessageLineMixin
implements GuiMessageLineExtension {
    @Unique
    private LocalDateTime createdAt;
    @Unique
    private Optional<Pair<Component, Integer>> timestamp;

    @Inject(method={"<init>(ILnet/minecraft/util/FormattedCharSequence;Lnet/minecraft/client/GuiMessageTag;Z)V"}, at={@At(value="TAIL")})
    private void init(int addedTime, FormattedCharSequence content, GuiMessageTag tag, boolean endOfEntry, CallbackInfo ci) {
        this.timestamp = Optional.empty();
    }

    @Override
    @Unique
    public LocalDateTime getCreated() {
        return this.createdAt;
    }

    @Override
    @Unique
    public void setCreated(LocalDateTime date) {
        this.createdAt = date;
    }

    @Override
    @Unique
    public Optional<Pair<Component, Integer>> getTimestamp() {
        return this.timestamp;
    }

    @Override
    @Unique
    public void setTimestamp(Component component) {
        this.timestamp = Optional.of(Pair.of(component, FontRenderer.getInstance().getFont().width((FormattedText)component)));
    }
}

