/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.mc.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.events.MixinHelper;
import com.wynntils.mc.event.PlayerNametagRenderEvent;
import com.wynntils.services.cosmetics.CosmeticsService;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerRenderState, PlayerModel> {
    protected PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel entityModel, float f) {
        super(context, (EntityModel)entityModel, f);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;Z)V"}, at={@At(value="RETURN")})
    private void onCtor(EntityRendererProvider.Context context, boolean bl, CallbackInfo ci) {
        CosmeticsService.getRegisteredLayers().forEach(layerProvider -> this.addLayer((RenderLayer)layerProvider.apply(this, context)));
    }

    @Inject(method={"renderNameTag(Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onNameTagRenderPre(PlayerRenderState renderState, Component displayName, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        PlayerNametagRenderEvent event = new PlayerNametagRenderEvent(renderState, displayName, poseStack, buffer, packedLight, this.entityRenderDispatcher, this.getFont());
        MixinHelper.post(event);
        if (event.isCanceled()) {
            ci.cancel();
        }
    }
}

